/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.UUID;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.xml.XmlFilteringUtil;
import ro.sync.basic.xml.schema.ExternalDTDInfo;
import ro.sync.ecss.component.AuthorContentMetadata;
import ro.sync.ecss.component.AuthorDocumentFragmentClipboardObject;
import ro.sync.ecss.component.bc;
import ro.sync.ecss.dom.x;
import ro.sync.ecss.dom.y;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.strictediting.ContentDescription;
import ro.sync.exml.v;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class AuthorClipboardObject
implements Serializable {
    private static final long serialVersionUID = 6031409352129925303L;
    private String textContent;
    protected String htmlContent;
    private AuthorDocumentFragmentClipboardObject[] fragments;
    private bc originalDocInfo;
    private int purposeID = -1;
    private String objectID;
    private SelectionInterpretationMode visualRepresentation;
    private AuthorContentMetadata metadata;

    public AuthorClipboardObject(String string, AuthorDocumentFragmentClipboardObject[] authorDocumentFragmentClipboardObjectArray, y y2) {
        this(string, null, authorDocumentFragmentClipboardObjectArray, null, y2, null);
    }

    public AuthorClipboardObject(String string2, String string3, AuthorDocumentFragmentClipboardObject[] authorDocumentFragmentClipboardObjectArray, AuthorContentMetadata authorContentMetadata, y y2, SelectionInterpretationMode selectionInterpretationMode) {
        this.textContent = (String)XmlFilteringUtil.filterInvalidXMLChars((CharSequence)string2, string -> {
            if (v.getInstance() != null) {
                v.getInstance().showWarningMessage((String)string, (String)null);
            }
        });
        this.htmlContent = string3;
        this.fragments = authorDocumentFragmentClipboardObjectArray;
        this.metadata = authorContentMetadata;
        this.originalDocInfo = new bc(y2);
        this.objectID = UUID.randomUUID().toString();
        this.visualRepresentation = selectionInterpretationMode;
    }

    public AuthorDocumentFragmentClipboardObject[] getFragments() {
        return this.fragments;
    }

    public AuthorContentMetadata getMetadata() {
        return this.metadata;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String string) {
        this.textContent = string;
    }

    public String getHtmlContent() {
        return this.htmlContent;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeObject(this.textContent);
            if (this.fragments != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < this.fragments.length; ++i2) {
                    String string = x.l(this.fragments[i2].getFragment(), this.originalDocInfo);
                    stringBuffer.append(string);
                    if (i2 == this.fragments.length - 1) continue;
                    stringBuffer.append('\u0000');
                }
                objectOutputStream.writeObject(new String[]{this.originalDocInfo.d(), this.originalDocInfo.e() != null ? this.originalDocInfo.e().toSerializedRepresentationWithMarkers() : null, stringBuffer.toString()});
                ContentDescription[] contentDescriptionArray = new ContentDescription[this.fragments.length];
                for (int i3 = 0; i3 < this.fragments.length; ++i3) {
                    contentDescriptionArray[i3] = this.fragments[i3].getContentDescription();
                    if (contentDescriptionArray[i3] != null) continue;
                    contentDescriptionArray = null;
                    break;
                }
                if (contentDescriptionArray != null) {
                    objectOutputStream.writeObject(contentDescriptionArray);
                }
                objectOutputStream.writeInt(this.purposeID);
                objectOutputStream.writeObject(this.objectID);
                objectOutputStream.writeObject((Object)this.visualRepresentation);
                objectOutputStream.writeObject(this.metadata);
            }
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.textContent = (String)objectInputStream.readObject();
        try {
            AuthorDocumentFragment[] authorDocumentFragmentArray;
            String[] stringArray = (String[])objectInputStream.readObject();
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            ArrayList<AuthorDocumentFragment> arrayList = new ArrayList<AuthorDocumentFragment>(1);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\u0000", false);
            while (stringTokenizer.hasMoreTokens()) {
                authorDocumentFragmentArray = stringTokenizer.nextToken();
                arrayList.add(x.h((String)authorDocumentFragmentArray, string, ExternalDTDInfo.fromSerializedRepresentationWithMarkers((String)string2)));
            }
            authorDocumentFragmentArray = arrayList.toArray(new AuthorDocumentFragment[0]);
            ContentDescription[] contentDescriptionArray = null;
            try {
                contentDescriptionArray = (ContentDescription[])objectInputStream.readObject();
                if (authorDocumentFragmentArray.length != contentDescriptionArray.length) {
                    throw new IOException("The documents fragments array length must be equals with the content description array length");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fragments = new AuthorDocumentFragmentClipboardObject[authorDocumentFragmentArray.length];
            for (int i2 = 0; i2 < authorDocumentFragmentArray.length; ++i2) {
                this.fragments[i2] = new AuthorDocumentFragmentClipboardObject(authorDocumentFragmentArray[i2], contentDescriptionArray == null ? null : contentDescriptionArray[i2]);
            }
            this.purposeID = objectInputStream.readInt();
            this.objectID = (String)objectInputStream.readObject();
            this.visualRepresentation = (SelectionInterpretationMode)((Object)objectInputStream.readObject());
            this.metadata = (AuthorContentMetadata)objectInputStream.readObject();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public void setPurposeID(int n2) {
        this.purposeID = n2;
    }

    public int getPurposeID() {
        return this.purposeID;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public SelectionInterpretationMode getVisualRepresentation() {
        return this.visualRepresentation;
    }

    public AuthorDocumentType getDocumentType() {
        return this.originalDocInfo != null ? this.originalDocInfo.f() : null;
    }
}

