/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.oxygen.json.schema.generator;

import ro.sync.oxygen.json.schema.generator.JSONSchemaSpec;

public class FormatMatcher {
    private static final String EMAIL_REGEX = "^[a-zA-Z0-9_!#$%&\ufffd*+/=?`{|}~^.-]+@[a-zA-Z0-9.-]+$";
    private static final String DATE_TIME_REGEX = "^[0-9]{4}-(1[0-2]|0[1-9])-(3[01]\\\"|[12][0-9]|0[1-9])T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:Z|[+-][01]\\d:[0-5]\\d)$";
    private static final String DATE_REGEX = "^[0-9]{4}-(1[0-2]|0[1-9])-(3[01]\"|[12][0-9]|0[1-9])$";
    private static final String TIME_REGEX = "^(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:Z|[+-][01]\\d:[0-5]\\d)$";
    private static final String IPV4_REGEX = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String IPV6_REGEX = "^(?:^|(?<=\\s))(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))(?=\\s|$)$";
    private static final String URI_REGEX = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]$";
    private static final String DURATION_REGEX = "^P(?!$)(\\d+(?:\\.\\d+)?Y)?(\\d+(?:\\.\\d+)?M)?(\\d+(?:\\.\\d+)?W)?(\\d+(?:\\.\\d+)?D)?(T(?=\\d)(\\d+(?:\\.\\d+)?H)?(\\d+(?:\\.\\d+)?M)?(\\d+(?:\\.\\d+)?S)?)?$";
    private JSONSchemaSpec schemaSpecification;

    public FormatMatcher(JSONSchemaSpec schemaVersion) {
        this.schemaSpecification = schemaVersion;
    }

    public String getFormatToMatch(String stringToEvaluate) {
        String matchingFormat = null;
        if (stringToEvaluate.matches(EMAIL_REGEX)) {
            matchingFormat = "email";
        } else if (stringToEvaluate.matches(DATE_TIME_REGEX)) {
            matchingFormat = "date-time";
        } else if (this.schemaSpecification.isAtLeast(JSONSchemaSpec.DRAFT_7) && stringToEvaluate.matches(DATE_REGEX)) {
            matchingFormat = "date";
        } else if (this.schemaSpecification.isAtLeast(JSONSchemaSpec.DRAFT_7) && stringToEvaluate.matches(TIME_REGEX)) {
            matchingFormat = "time";
        } else if (stringToEvaluate.matches(IPV4_REGEX)) {
            matchingFormat = "ipv4";
        } else if (stringToEvaluate.matches(IPV6_REGEX)) {
            matchingFormat = "ipv6";
        } else if (stringToEvaluate.matches(URI_REGEX)) {
            matchingFormat = "uri";
        } else if (this.schemaSpecification.isAtLeast(JSONSchemaSpec.DRAFT_2019_09) && stringToEvaluate.matches(DURATION_REGEX)) {
            matchingFormat = "duration";
        }
        return matchingFormat;
    }
}

