/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableCellsContentConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSTableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertColumnOperation
extends InsertColumnOperationBase
implements CALSConstants,
InsertTableCellsContentConstants {
    private ArgumentDescriptor[] arguments;
    protected String cellContent;

    public InsertColumnOperation() {
        this(new CALSDocumentTypeHelper());
    }

    public InsertColumnOperation(AuthorTableHelper tableHelper) {
        super(tableHelper);
        ArgumentDescriptor[] superArgs = super.getArguments();
        if (superArgs != null) {
            this.arguments = new ArgumentDescriptor[superArgs.length + 1];
            for (int i = 0; i < superArgs.length; ++i) {
                this.arguments[i] = superArgs[i];
            }
            this.arguments[superArgs.length] = CELL_FRAGMENT_ARGUMENT;
        } else {
            this.arguments = CELL_FRAGMENT_ARGUMENT_IN_ARRAY;
        }
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object cellFragmentObj = args.getArgumentValue("cellFragment");
        if (cellFragmentObj instanceof String) {
            this.cellContent = (String)cellFragmentObj;
        }
        if ("".equals(this.cellContent)) {
            this.cellContent = null;
        }
        super.doOperationInternal(authorAccess, args);
    }

    @Override
    protected void updateColumnCellsSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSupport, AuthorElement tgroup, int newColumnIndex, TableColumnSpecificationInformation columnSpecification, String namespace, int noOfColumnsToBeInserted) throws AuthorOperationException {
        Set<CALSColSpec> colSpecs = ((CALSTableCellInfoProvider)tableSupport).getColSpecs();
        int previousColspecIndex = -1;
        WidthRepresentation previousColWidth = null;
        boolean insertBefore = false;
        boolean addColwidth = colSpecs.isEmpty();
        boolean specifyColNum = colSpecs.isEmpty();
        boolean specifyColName = colSpecs.isEmpty();
        for (CALSColSpec colSpec : colSpecs) {
            if (colSpec.getColumnName() != null && !specifyColName) {
                specifyColName = true;
            }
            if (colSpec.isColNumberSpecified() && !specifyColNum) {
                specifyColNum = true;
            }
            if (colSpec.getColWidth() == null || addColwidth) continue;
            addColwidth = true;
        }
        for (CALSColSpec colSpec : colSpecs) {
            previousColspecIndex = colSpec.getIndexInDocument();
            if (colSpec.getColumnNumber() >= newColumnIndex + 1) {
                insertBefore = true;
                break;
            }
            previousColWidth = colSpec.getColWidth();
        }
        int insertOffset = -1;
        String preferredColspecElementName = "colspec";
        if (previousColspecIndex != -1) {
            List contentNodes = tgroup.getContentNodes();
            for (AuthorNode colspecNodeCandidate : contentNodes) {
                if (!this.tableHelper.isColspec(colspecNodeCandidate)) continue;
                preferredColspecElementName = ((AuthorElement)colspecNodeCandidate).getLocalName();
                AttrValue colSpecNumber = ((AuthorElement)colspecNodeCandidate).getAttribute("colnum");
                if (colSpecNumber == null) continue;
                try {
                    int colSpecNr = NumberParserUtil.parseInt((String)colSpecNumber.getValue());
                    if (colSpecNr < newColumnIndex + 1) continue;
                    authorAccess.getDocumentController().setAttribute("colnum", new AttrValue("" + (colSpecNr + noOfColumnsToBeInserted)), (AuthorElement)colspecNodeCandidate);
                }
                catch (NumberFormatException colSpecNr) {}
            }
            int i = 0;
            for (AuthorNode node : contentNodes) {
                if (!this.tableHelper.isColspec(node)) continue;
                preferredColspecElementName = ((AuthorElement)node).getLocalName();
                if (i == previousColspecIndex) {
                    insertOffset = insertBefore ? node.getStartOffset() : node.getEndOffset() + 1;
                    break;
                }
                ++i;
            }
        } else if (newColumnIndex == 0) {
            insertOffset = tgroup.getStartOffset() + 1;
        }
        HashSet<String> uniqueColumnNames = new HashSet<String>();
        for (CALSColSpec colSpec : colSpecs) {
            uniqueColumnNames.add(colSpec.getColumnName());
        }
        StringBuilder newColSpecFragment = new StringBuilder();
        for (int i = 0; i < noOfColumnsToBeInserted; ++i) {
            String newColSpecName;
            if (insertOffset != -1) {
                newColSpecFragment.append("<").append(preferredColspecElementName);
                if (namespace != null) {
                    newColSpecFragment.append(" xmlns=\"").append(namespace).append("\"");
                }
                if (specifyColNum) {
                    newColSpecFragment.append(" ").append("colnum");
                    newColSpecFragment.append("=\"").append(newColumnIndex + i + 1).append("\"");
                }
                newColSpecName = null;
                if (specifyColName) {
                    if (columnSpecification instanceof CALSTableColumnSpecificationInformation) {
                        newColSpecName = ((CALSTableColumnSpecificationInformation)columnSpecification).getColumnName();
                    }
                    if (newColSpecName == null) {
                        newColSpecName = InsertColumnOperation.getUniqueColSpecName(uniqueColumnNames, newColumnIndex + i + 1);
                        uniqueColumnNames.add(newColSpecName);
                    }
                    newColSpecFragment.append(" ").append("colname");
                    newColSpecFragment.append("=\"").append(newColSpecName).append("\"");
                }
                if (addColwidth) {
                    WidthRepresentation colWidthRepresentation;
                    String colWidth = this.getDefaultColWidthValue();
                    if (previousColWidth != null && previousColWidth.getWidthRepresentation() != null) {
                        colWidth = previousColWidth.getWidthRepresentation();
                    }
                    if (columnSpecification != null && (colWidthRepresentation = columnSpecification.getWidthRepresentation()) != null) {
                        colWidth = colWidthRepresentation.getWidthRepresentation();
                    }
                    if (colWidth != null) {
                        newColSpecFragment.append(" ").append("colwidth");
                        newColSpecFragment.append("=\"").append(colWidth).append("\"");
                    }
                }
            } else {
                throw new AuthorOperationException("Could not compute the index of the column to be inserted.");
            }
            newColSpecFragment.append("/>");
            uniqueColumnNames.add(newColSpecName);
        }
        authorAccess.getDocumentController().insertXMLFragment(newColSpecFragment.toString(), insertOffset);
    }

    protected String getDefaultColWidthValue() {
        return "1*";
    }

    private static String getUniqueColSpecName(Set<String> colSpecNames, int colSpecIndex) {
        String uniqueColSpecName = "newCol" + colSpecIndex;
        boolean isUnique = false;
        block0: while (!isUnique) {
            isUnique = true;
            for (String colSpec : colSpecNames) {
                if (!uniqueColSpecName.equals(colSpec)) continue;
                isUnique = false;
                uniqueColSpecName = "newCol" + ++colSpecIndex;
                continue block0;
            }
        }
        return uniqueColSpecName;
    }

    @Override
    protected String getCellElementName(AuthorElement row, int newColumnIndex) {
        return "entry";
    }

    @Override
    protected String getDefaultContentForEmptyCells() {
        return this.cellContent;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

