/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIAttribute;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.properties.TableHelper;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class TableOperationsUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)TableOperationsUtil.class.getName());

    private TableOperationsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String createCellXMLFragment(AuthorAccess authorAccess, AuthorDocumentFragment[] fragments, boolean cellsFragment, String cellElementName, int currentFragmentIndex, String namespace, AuthorTableHelper authorTableHelper, String ... imposedAttributesFragments) throws AuthorOperationException {
        StringBuilder additionalAttributes = new StringBuilder();
        StringBuilder cellContent = new StringBuilder();
        if (fragments.length > currentFragmentIndex) {
            String contentFromFragment;
            AuthorNode cellNode;
            List contentNodes;
            AuthorDocumentFragment currentFragmentContent = fragments[currentFragmentIndex];
            if (cellsFragment && (contentNodes = currentFragmentContent.getContentNodes()).size() == 1 && (cellNode = (AuthorNode)contentNodes.get(0)) instanceof AuthorElement) {
                AuthorElement element = (AuthorElement)cellNode;
                int attributesCount = element.getAttributesCount();
                for (int j = 0; j < attributesCount; ++j) {
                    AttrValue attrValue;
                    String attrName = element.getAttributeAtIndex(j);
                    if (attrName == null || attrName.startsWith("xmlns") || TableOperationsUtil.isIgnoredAttribute(attrName, authorTableHelper) || !(attrValue = element.getAttribute(attrName)).isSpecified()) continue;
                    String rawValue = attrValue.getRawValue();
                    additionalAttributes.append(" " + attrName + "=\"" + rawValue + "\"");
                }
            }
            if ((contentFromFragment = TableOperationsUtil.getContentFromFragment(authorAccess, cellsFragment, currentFragmentContent)) != null) {
                cellContent.append(contentFromFragment);
            }
        }
        StringBuilder cellXMLFragment = new StringBuilder("<");
        cellXMLFragment.append(cellElementName);
        if (namespace != null) {
            cellXMLFragment.append(" xmlns=\"" + namespace + "\"");
        }
        if (imposedAttributesFragments != null) {
            for (int i = 0; i < imposedAttributesFragments.length; ++i) {
                cellXMLFragment.append(" ").append(imposedAttributesFragments[i]);
            }
        }
        cellXMLFragment.append(additionalAttributes.toString());
        String content = cellContent.toString();
        if (content.length() == 0) {
            cellXMLFragment.append("/>");
        } else {
            cellXMLFragment.append(">");
            cellXMLFragment.append(content);
            cellXMLFragment.append("</").append(cellElementName).append(">");
        }
        return cellXMLFragment.toString();
    }

    public static boolean isIgnoredAttribute(String attrName, AuthorTableHelper tableHelper) {
        int i;
        boolean shouldBeIgnored = false;
        String[] ignoredAttributes = tableHelper.getIgnoredColumnAttributes();
        if (ignoredAttributes != null) {
            for (i = 0; i < ignoredAttributes.length; ++i) {
                if (!attrName.equals(ignoredAttributes[i])) continue;
                shouldBeIgnored = true;
                break;
            }
        }
        if (!shouldBeIgnored && (ignoredAttributes = tableHelper.getIgnoredRowAttributes()) != null) {
            for (i = 0; i < ignoredAttributes.length; ++i) {
                if (!attrName.equals(ignoredAttributes[i])) continue;
                shouldBeIgnored = true;
                break;
            }
        }
        return shouldBeIgnored;
    }

    public static String getContentFromFragment(AuthorAccess authorAccess, boolean cellsFragment, AuthorDocumentFragment fragment) {
        String contentFromFragment = null;
        try {
            if (cellsFragment) {
                AuthorDocumentFragment content = authorAccess.getDocumentController().unwrapDocumentFragment(fragment);
                if (content != null) {
                    contentFromFragment = authorAccess.getDocumentController().serializeFragmentToXML(content);
                }
            } else {
                contentFromFragment = authorAccess.getDocumentController().serializeFragmentToXML(fragment);
            }
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return contentFromFragment;
    }

    public static boolean nodeHasProperties(AuthorNode node, String name, String namespace) {
        boolean match = false;
        match = namespace == null || "".equals(namespace) ? node.getNamespace() == null || "".equals(node.getNamespace()) : namespace.equals(node.getNamespace());
        if (match) {
            String nodeName = node.getName();
            int separatorOffset = nodeName.indexOf(58);
            if (separatorOffset > 0) {
                nodeName = nodeName.substring(separatorOffset);
            }
            match = nodeName.equals(name);
        }
        return match;
    }

    public static AuthorElement getTableElementContainingOffset(int offset, AuthorAccess access, String ... tableClassValues) {
        AuthorElement tableNode;
        block4: {
            tableNode = null;
            try {
                AuthorNode currentNode;
                if (tableClassValues == null || tableClassValues.length <= 0) break block4;
                AuthorElement rootElement = access.getDocumentController().getAuthorDocumentNode().getRootElement();
                if (currentNode == null || currentNode.getStartOffset() <= rootElement.getStartOffset() || currentNode.getEndOffset() >= rootElement.getEndOffset()) break block4;
                for (currentNode = access.getDocumentController().getNodeAtOffset(offset); currentNode != rootElement; currentNode = currentNode.getParent()) {
                    String classValue;
                    AuthorElement currentElement;
                    AttrValue classAttribute;
                    if (!(currentNode instanceof AuthorElement) || (classAttribute = (currentElement = (AuthorElement)currentNode).getAttribute("class")) == null || (classValue = classAttribute.getRawValue()) == null) continue;
                    for (String tableClassValue : tableClassValues) {
                        if (!classValue.contains(tableClassValue)) continue;
                        tableNode = currentElement;
                        break block4;
                    }
                }
            }
            catch (BadLocationException e) {
                logger.warn((Object)e, (Throwable)e);
            }
        }
        return tableNode;
    }

    public static AuthorElement getTableElementContainingOffset(int offset, String namespace, AuthorAccess access, String ... tableElementNames) {
        AuthorElement tableElement;
        block4: {
            tableElement = null;
            try {
                AuthorNode currentNode;
                if (tableElementNames == null || tableElementNames.length <= 0) break block4;
                AuthorElement rootElement = access.getDocumentController().getAuthorDocumentNode().getRootElement();
                if (currentNode == null || currentNode.getStartOffset() <= rootElement.getStartOffset() || currentNode.getEndOffset() >= rootElement.getEndOffset()) break block4;
                for (currentNode = access.getDocumentController().getNodeAtOffset(offset); currentNode != rootElement; currentNode = currentNode.getParent()) {
                    if (!(currentNode instanceof AuthorElement)) continue;
                    for (String tableElementName : tableElementNames) {
                        if (!TableOperationsUtil.nodeHasProperties(currentNode, tableElementName, namespace)) continue;
                        tableElement = (AuthorElement)currentNode;
                        break block4;
                    }
                }
            }
            catch (BadLocationException e) {
                logger.warn((Object)e, (Throwable)e);
            }
        }
        return tableElement;
    }

    public static boolean isChoiceTableAllowed(AuthorAccess authorAccess) {
        boolean canInsertChoiceTable = false;
        try {
            AuthorElement currentElement;
            AttrValue classAttribute;
            AuthorNode currentNode;
            List childrenElements;
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
            WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(caretOffset);
            if (context != null && (childrenElements = authorSchemaManager.whatElementsCanGoHere(context)) != null) {
                block2: for (int i = 0; i < childrenElements.size(); ++i) {
                    CIElement currentElement2 = (CIElement)childrenElements.get(i);
                    List attributes = currentElement2.getAttributesWithDefaultValues();
                    if (attributes == null) continue;
                    for (int j = 0; j < attributes.size(); ++j) {
                        CIAttribute currentAttribute = (CIAttribute)attributes.get(j);
                        String attrDefaultValue = currentAttribute.getDefaultValue();
                        if (!"class".equals(currentAttribute.getName()) || attrDefaultValue == null || !attrDefaultValue.contains(" task/choicetable ")) continue;
                        canInsertChoiceTable = true;
                        break block2;
                    }
                }
            }
            if (!canInsertChoiceTable && (currentNode = authorAccess.getDocumentController().getNodeAtOffset(caretOffset)) instanceof AuthorElement && (classAttribute = (currentElement = (AuthorElement)currentNode).getAttribute("class")) != null && classAttribute.getValue() != null && (classAttribute.getValue().contains(" task/step ") || classAttribute.getValue().contains("task/cmd"))) {
                canInsertChoiceTable = true;
            }
        }
        catch (BadLocationException e) {
            logger.warn((Object)e, (Throwable)e);
        }
        return canInsertChoiceTable;
    }

    public static boolean areOtherTablesThanChoicetableAllowed(AuthorAccess authorAccess) {
        boolean toReturn;
        block4: {
            toReturn = false;
            try {
                List childrenElements;
                int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
                WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(caretOffset);
                if (context == null || (childrenElements = authorSchemaManager.whatElementsCanGoHere(context)) == null) break block4;
                for (int i = 0; i < childrenElements.size(); ++i) {
                    CIElement currentElement = (CIElement)childrenElements.get(i);
                    List attributes = currentElement.getAttributesWithDefaultValues();
                    if (attributes == null) continue;
                    for (int j = 0; j < attributes.size(); ++j) {
                        CIAttribute currentAttribute = (CIAttribute)attributes.get(j);
                        String attrDefaultValue = currentAttribute.getDefaultValue();
                        if (!"class".equals(currentAttribute.getName()) || attrDefaultValue == null || !attrDefaultValue.contains(" topic/table ") && (!attrDefaultValue.contains(" topic/simpletable ") || attrDefaultValue.contains(" task/choicetable "))) continue;
                        toReturn = true;
                        break block4;
                    }
                }
            }
            catch (BadLocationException e) {
                logger.warn((Object)e, (Throwable)e);
            }
        }
        return toReturn;
    }

    public static boolean isPropertiesTableGlobalElement(AuthorAccess authorAccess) {
        boolean toReturn = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        List globalElements = authorSchemaManager.getGlobalElements();
        if (globalElements != null) {
            block0: for (int i = 0; i < globalElements.size(); ++i) {
                CIElement currentElement = (CIElement)globalElements.get(i);
                List attributes = currentElement.getAttributesWithDefaultValues();
                if (attributes == null) continue;
                for (int j = 0; j < attributes.size(); ++j) {
                    CIAttribute currentAttribute = (CIAttribute)attributes.get(j);
                    String attrDefaultValue = currentAttribute.getDefaultValue();
                    if (!"class".equals(currentAttribute.getName()) || attrDefaultValue == null || !attrDefaultValue.contains(" reference/properties ")) continue;
                    toReturn = true;
                    break block0;
                }
            }
        }
        return toReturn;
    }

    public static List<AuthorElement> getTableElementsOfTypeFromSelection(AuthorAccess authorAccess, int type, TableHelper tableHelper, AuthorElement tableElement) {
        List selectionIntervals = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
        ArrayList<Integer[]> selections = new ArrayList<Integer[]>();
        if (selectionIntervals != null && !selectionIntervals.isEmpty()) {
            for (int i = 0; i < selectionIntervals.size(); ++i) {
                int startOffset = ((ContentInterval)selectionIntervals.get(i)).getStartOffset();
                int endOffset = ((ContentInterval)selectionIntervals.get(i)).getEndOffset();
                if ((tableElement.getStartOffset() > startOffset || startOffset > tableElement.getEndOffset()) && (tableElement.getStartOffset() > endOffset || endOffset > tableElement.getEndOffset())) continue;
                selections.add(new Integer[]{startOffset, endOffset});
            }
        }
        return TableOperationsUtil.getTableElementsOfType(authorAccess, selections, type, tableHelper);
    }

    public static List<AuthorElement> getTableElementsOfType(AuthorAccess authorAccess, List<Integer[]> selections, int type, TableHelper tableHelper) {
        ArrayList<AuthorElement> elements = new ArrayList<AuthorElement>();
        try {
            for (int i = 0; i < selections.size(); ++i) {
                Integer[] sel = selections.get(i);
                int startOffset = sel[0];
                int endOffset = sel[1];
                List nodesToSelect = null;
                if (startOffset != endOffset) {
                    nodesToSelect = authorAccess.getDocumentController().getNodesToSelect(startOffset, endOffset);
                } else {
                    nodesToSelect = new ArrayList<AuthorNode>();
                    nodesToSelect.add(authorAccess.getDocumentController().getNodeAtOffset(startOffset));
                }
                for (int j = 0; j < nodesToSelect.size(); ++j) {
                    AuthorNode node = (AuthorNode)nodesToSelect.get(j);
                    if (!(node instanceof AuthorElement)) continue;
                    TableOperationsUtil.computeElementsList(elements, (AuthorElement)node, startOffset, endOffset != -1 ? endOffset : startOffset, type, false, tableHelper);
                }
            }
        }
        catch (BadLocationException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return elements;
    }

    public static void computeElementsList(List<AuthorElement> elementsList, AuthorElement node, int startOffset, int endOffset, int type, boolean fullySelected, TableHelper tableHelper) {
        if (tableHelper.isNodeOfType(node, type) && !elementsList.contains(node)) {
            elementsList.add(node);
        } else if (TableOperationsUtil.getElementAncestor((AuthorNode)node, type, tableHelper) != null) {
            AuthorElement elementAncestor = TableOperationsUtil.getElementAncestor((AuthorNode)node, type, tableHelper);
            if (!elementsList.contains(elementAncestor)) {
                elementsList.add(elementAncestor);
            }
        } else if (type != 5) {
            ArrayList<AuthorElement> collectedElements = new ArrayList<AuthorElement>();
            TableOperationsUtil.getChildElements(node, type, collectedElements, tableHelper);
            for (int j = 0; j < collectedElements.size(); ++j) {
                boolean addElement;
                AuthorElement currentElement = (AuthorElement)collectedElements.get(j);
                int currentElementStartOffset = currentElement.getStartOffset();
                int currentElementEndOffset = currentElement.getEndOffset();
                boolean selectionContainsCurrentElement = startOffset >= currentElementStartOffset && startOffset <= currentElementEndOffset || endOffset > currentElementStartOffset && endOffset <= currentElementEndOffset || currentElementStartOffset >= startOffset && currentElementStartOffset < endOffset || currentElementEndOffset >= startOffset && currentElementEndOffset < endOffset;
                boolean bl = addElement = startOffset == endOffset || !fullySelected && selectionContainsCurrentElement || fullySelected && currentElementStartOffset >= startOffset && currentElementEndOffset <= endOffset;
                if (!addElement || elementsList.contains(currentElement)) continue;
                elementsList.add(currentElement);
            }
        }
        if (type == 5) {
            for (int i = 0; i < elementsList.size(); ++i) {
                AuthorElement authorElement = elementsList.get(i);
                AuthorNode parent = authorElement.getParent();
                if (parent instanceof AuthorElement && tableHelper.isTable((AuthorElement)parent) && !elementsList.contains(parent)) {
                    elementsList.add((AuthorElement)parent);
                }
                List children = node.getContentNodes();
                for (int j = 0; j < children.size(); ++j) {
                    AuthorNode child = (AuthorNode)children.get(j);
                    if (!(child instanceof AuthorElement) || !tableHelper.isTable((AuthorElement)child) || !tableHelper.isTableGroup((AuthorElement)child) || elementsList.contains(child)) continue;
                    elementsList.add((AuthorElement)child);
                }
            }
        }
    }

    public static AuthorElement getElementAncestor(AuthorNode node, int type, TableHelper tableHelper) {
        AuthorElement parentCell = null;
        while (node instanceof AuthorElement) {
            if (tableHelper.isNodeOfType((AuthorElement)node, type)) {
                parentCell = (AuthorElement)node;
                break;
            }
            node = node.getParent();
        }
        return parentCell;
    }

    public static void getChildElements(AuthorElement node, int type, List<AuthorElement> children, TableHelper tableHelper) {
        if (tableHelper.isNodeOfType(node, type)) {
            children.add(node);
        } else {
            List contentNodes = node.getContentNodes();
            for (int i = 0; i < contentNodes.size(); ++i) {
                AuthorNode authorNode = (AuthorNode)contentNodes.get(i);
                if (authorNode.getType() != 0) continue;
                TableOperationsUtil.getChildElements((AuthorElement)authorNode, type, children, tableHelper);
            }
        }
    }

    public static Map<AuthorElement, Set<Integer>> getCellIndexes(List<AuthorElement> cells, AuthorAccess authorAccess, TableHelper tableHelper, boolean isCals) {
        HashMap<AuthorElement, Set<Integer>> indexes = new HashMap<AuthorElement, Set<Integer>>();
        for (int i = 0; i < cells.size(); ++i) {
            AuthorElement tableElement = TableOperationsUtil.getElementAncestor((AuthorNode)cells.get(i), isCals ? 4 : 5, tableHelper);
            HashSet<Integer> set = (HashSet<Integer>)indexes.get(tableElement);
            if (set == null) {
                set = new HashSet<Integer>();
            }
            if (isCals) {
                int[] tableColSpanIndices = authorAccess.getTableAccess().getTableColSpanIndices(cells.get(i));
                for (int j = 0; tableColSpanIndices != null && j < tableColSpanIndices.length; ++j) {
                    set.add(tableColSpanIndices[j] + 1);
                }
            } else {
                set.add(authorAccess.getTableAccess().getTableCellIndex(cells.get(i))[1]);
            }
            indexes.put(tableElement, set);
        }
        return indexes;
    }

    public static TableHelper createTableHelper(final AuthorTableHelper authorTableHelper) {
        return new TableHelper(){

            @Override
            public boolean isTableGroup(AuthorElement node) {
                return false;
            }

            @Override
            public boolean isTable(AuthorElement node) {
                return authorTableHelper.isTable((AuthorNode)node);
            }

            @Override
            public boolean isNodeOfType(AuthorElement node, int type) {
                boolean toReturn = false;
                switch (type) {
                    case 0: {
                        toReturn = authorTableHelper.isTableRow((AuthorNode)node);
                        break;
                    }
                    case 5: {
                        toReturn = authorTableHelper.isTable((AuthorNode)node);
                        break;
                    }
                    case 6: {
                        toReturn = authorTableHelper.isTableCell((AuthorNode)node);
                    }
                }
                return toReturn;
            }
        };
    }

    public static void placeCaretInFirstCell(AuthorAccess authorAccess, TableInfo tableInfo, AuthorDocumentController controller, SchemaAwareHandlerResult result) {
        Integer offs;
        if (result != null && tableInfo.getTitle() == null && (offs = (Integer)result.getResult("result.id.handle.insert.fragment.offset")) != null) {
            try {
                AuthorElement firstCell;
                AuthorNode tableNode = controller.getNodeAtOffset(offs + 1);
                if (tableNode instanceof AuthorElement && (firstCell = TableOperationsUtil.getFirstCell((AuthorElement)tableNode, authorAccess.getEditorAccess())) != null) {
                    authorAccess.getEditorAccess().setCaretPosition(firstCell.getStartOffset() + 1);
                }
            }
            catch (BadLocationException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static AuthorElement getFirstCell(AuthorElement parentElement, AuthorEditorAccess authorEditorAccess) {
        AuthorElement toRet = null;
        List contentNodes = parentElement.getContentNodes();
        if (contentNodes != null) {
            for (int i = 0; i < contentNodes.size(); ++i) {
                AuthorNode child = (AuthorNode)contentNodes.get(i);
                if (child.getType() != 0) continue;
                AuthorElement childElement = (AuthorElement)child;
                Styles styles = authorEditorAccess.getStyles((AuthorNode)childElement);
                if ("table-cell".equals(styles.getDisplay())) {
                    toRet = childElement;
                } else {
                    AuthorElement firstCell = TableOperationsUtil.getFirstCell(childElement, authorEditorAccess);
                    if (firstCell != null) {
                        toRet = firstCell;
                    }
                }
                if (toRet != null) break;
            }
        }
        return toRet;
    }

    public static void removeInvalidColNamesFromCALSTableCells(AuthorAccess authorAccess, AuthorElement tableElement, List<AuthorElement> cells) {
        if (cells != null && !cells.isEmpty()) {
            CALSTableCellInfoProvider cellInfoProvider = new CALSTableCellInfoProvider(false);
            cellInfoProvider.init(tableElement);
            Set<CALSColSpec> colSpecs = cellInfoProvider.getColSpecs();
            for (int i = 0; i < cells.size(); ++i) {
                AuthorElement cell = cells.get(i);
                String[] attributesToCheck = new String[]{"colname", "namest", "nameend"};
                HashSet<String> definedColumnNamed = new HashSet<String>();
                Iterator<CALSColSpec> iter = colSpecs.iterator();
                while (iter.hasNext()) {
                    definedColumnNamed.add(iter.next().getColumnName());
                }
                for (int j = 0; j < attributesToCheck.length; ++j) {
                    boolean foundColname;
                    AttrValue colnameValue = cell.getAttribute(attributesToCheck[j]);
                    if (colnameValue == null || (foundColname = definedColumnNamed.contains(colnameValue.getValue()))) continue;
                    authorAccess.getDocumentController().removeAttribute(attributesToCheck[j], cell);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handleColumnSpecAttributeChange(AuthorAccess authorAccess, AuthorTableHelper helper, AuthorElement currentElement, String attributeName, AttrValue newValue) {
        boolean handled = false;
        AttrValue oldValue = currentElement.getAttribute(attributeName);
        if (oldValue != null && oldValue.isSpecified()) {
            String currentValue = oldValue.getValue();
            ArrayList<String> interestingAttrs = new ArrayList<String>();
            interestingAttrs.add("colname");
            interestingAttrs.add("namest");
            interestingAttrs.add("nameend");
            if (interestingAttrs.contains(attributeName)) {
                AuthorElement tableElement = null;
                for (AuthorElement node = currentElement; node != null; node = node.getParent()) {
                    if (!authorAccess.getEditorAccess().getStyles((AuthorNode)node).isTable()) continue;
                    if (node.getType() != 0) break;
                    tableElement = node;
                    break;
                }
                HashSet<String> existingColNames = new HashSet<String>();
                if (tableElement != null) {
                    int i;
                    ArrayList<AuthorElement> toChange = new ArrayList<AuthorElement>();
                    List nodes = tableElement.getContentNodes();
                    if (nodes != null && !nodes.isEmpty()) {
                        for (i = 0; i < nodes.size(); ++i) {
                            List rowNodes;
                            AuthorNode childNode = (AuthorNode)nodes.get(i);
                            if (childNode.getType() != 0) continue;
                            AuthorElement childElement = (AuthorElement)childNode;
                            if (helper.isColspec((AuthorNode)childElement)) {
                                toChange.add(childElement);
                                AttrValue attribute = childElement.getAttribute("colname");
                                if (attribute == null || !attribute.isSpecified()) continue;
                                existingColNames.add(attribute.getValue());
                                continue;
                            }
                            if (helper.isTableRow((AuthorNode)childElement)) {
                                TableOperationsUtil.iterateCells(helper, toChange, childElement);
                                continue;
                            }
                            Styles styles = authorAccess.getEditorAccess().getStyles((AuthorNode)childElement);
                            if (!styles.isTableHeaderGroup() && !styles.isTableRowGroup() || (rowNodes = childElement.getContentNodes()) == null) continue;
                            for (int j = 0; j < rowNodes.size(); ++j) {
                                AuthorNode rowNode = (AuthorNode)rowNodes.get(j);
                                if (!helper.isTableRow(rowNode) || rowNode.getType() != 0) continue;
                                TableOperationsUtil.iterateCells(helper, toChange, (AuthorElement)rowNode);
                            }
                        }
                    }
                    if (!toChange.isEmpty() && toChange.contains(currentElement) && !existingColNames.contains(newValue.getValue())) {
                        handled = true;
                        try {
                            authorAccess.getDocumentController().beginCompoundEdit();
                            for (i = 0; i < toChange.size(); ++i) {
                                AuthorElement elem = (AuthorElement)toChange.get(i);
                                for (int j = 0; j < interestingAttrs.size(); ++j) {
                                    String attr = (String)interestingAttrs.get(j);
                                    AttrValue currentAttr = elem.getAttribute(attr);
                                    if (currentAttr == null || !currentAttr.isSpecified() || !currentValue.equals(currentAttr.getValue())) continue;
                                    authorAccess.getDocumentController().setAttribute(attr, newValue, elem);
                                }
                            }
                        }
                        finally {
                            authorAccess.getDocumentController().endCompoundEdit();
                        }
                    }
                }
            }
        }
        return handled;
    }

    private static void iterateCells(AuthorTableHelper helper, List<AuthorElement> toChange, AuthorElement rowElement) {
        List cellNodes = rowElement.getContentNodes();
        if (cellNodes != null) {
            for (int j = 0; j < cellNodes.size(); ++j) {
                AuthorNode cellNode = (AuthorNode)cellNodes.get(j);
                if (!helper.isTableCell(cellNode) || cellNode.getType() != 0) continue;
                toChange.add((AuthorElement)cellNode);
            }
        }
    }
}

