/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.DeleteRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.SplitCellAboveBelowOperationBase;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class JoinCellAboveBelowOperationBase
extends AbstractTableOperation {
    public static final String JOIN_ABOVE = "Above";
    public static final String JOIN_BELOW = "Below";
    private static final String ARGUMENT_NAME = "Join direction";

    public JoinCellAboveBelowOperationBase(AuthorTableHelper tableHelper) {
        super(tableHelper);
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        block17: {
            try {
                AuthorNode selectedNode;
                int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
                AuthorElement cell = null;
                if (authorAccess.getEditorAccess().hasSelection() && (selectedNode = authorAccess.getEditorAccess().getFullySelectedNode()) != null && this.isTableElement(selectedNode, 0)) {
                    cell = (AuthorElement)selectedNode;
                }
                if (cell == null) {
                    cell = this.getElementAncestor(nodeAtCaret, 0);
                }
                if (cell != null) {
                    AuthorElement tableElem = this.getElementAncestor(nodeAtCaret, 2);
                    if (tableElem != null) {
                        DeleteRowOperationBase deleteRowOperation;
                        int colSpanCellBelow;
                        AuthorElement cellAbove = null;
                        AuthorElement cellBelow = null;
                        String joinDirection = (String)args.getArgumentValue(ARGUMENT_NAME);
                        if (JOIN_BELOW.equals(joinDirection)) {
                            cellAbove = cell;
                            cellBelow = authorAccess.getTableAccess().getTableCellBelow(cell);
                            if (cellBelow == null) {
                                AuthorOperationException ex = new AuthorOperationException("There is no cell below.");
                                ex.setOperationRejectedOnPurpose(true);
                                throw ex;
                            }
                        } else {
                            cellAbove = authorAccess.getTableAccess().getTableCellAbove(cell);
                            cellBelow = cell;
                            if (cellAbove == null) {
                                AuthorOperationException ex = new AuthorOperationException("There is no cell above.");
                                ex.setOperationRejectedOnPurpose(true);
                                throw ex;
                            }
                        }
                        AuthorTableCellSpanProvider tableSupport = this.tableHelper.getTableCellSpanProvider(tableElem);
                        Integer colSpanCellAboveInteger = tableSupport.getColSpan(cellAbove);
                        Integer colSpanCellBelowInteger = tableSupport.getColSpan(cellBelow);
                        int colSpanCellAbove = colSpanCellAboveInteger != null ? colSpanCellAboveInteger : 1;
                        int n = colSpanCellBelow = colSpanCellBelowInteger != null ? colSpanCellBelowInteger : 1;
                        if (colSpanCellAbove != colSpanCellBelow) {
                            AuthorOperationException ex = new AuthorOperationException("The column spans of the involved cells are different.");
                            ex.setOperationRejectedOnPurpose(true);
                            throw ex;
                        }
                        AuthorDocumentController controller = authorAccess.getDocumentController();
                        AuthorDocumentFragment joinFragment = null;
                        if (cellBelow.getStartOffset() + 1 < cellBelow.getEndOffset()) {
                            joinFragment = controller.createDocumentFragment(cellBelow.getStartOffset() + 1, cellBelow.getEndOffset() - 1);
                        }
                        AuthorElement tableRowToRemove = null;
                        int[] indexOfBelowTable = authorAccess.getTableAccess().getTableCellIndex(cellBelow);
                        if (indexOfBelowTable != null) {
                            int rowIndex = indexOfBelowTable[0];
                            AuthorElement tableRow = authorAccess.getTableAccess().getTableRow(rowIndex, tableElem);
                            if (tableRow != null && tableRow.getContentNodes().size() == 1) {
                                tableRowToRemove = tableRow;
                            }
                        }
                        boolean deletedCell = controller.deleteNode((AuthorNode)cellBelow);
                        if (joinFragment != null) {
                            controller.insertFragment(cellAbove.getEndOffset(), joinFragment);
                        }
                        Integer cellAboveRowSpanInteger = tableSupport.getRowSpan(cellAbove);
                        Integer cellBelowRowSpanInteger = tableSupport.getRowSpan(cellBelow);
                        int cellAboveRowSpan = cellAboveRowSpanInteger != null ? cellAboveRowSpanInteger : 1;
                        int cellBelowRowSpan = cellBelowRowSpanInteger != null ? cellBelowRowSpanInteger : 1;
                        this.tableHelper.updateTableRowSpan(authorAccess, cellAbove, cellAboveRowSpan + cellBelowRowSpan);
                        if (joinFragment == null) {
                            authorAccess.getEditorAccess().setCaretPosition(cellAbove.getEndOffset());
                        }
                        if (deletedCell && tableRowToRemove != null && (deleteRowOperation = this.createDeleteRowOperation()) != null) {
                            deleteRowOperation.performDeleteRows(authorAccess, tableRowToRemove.getStartOffset(), tableRowToRemove.getEndOffset() + 1);
                            authorAccess.getEditorAccess().setCaretPosition(cellAbove.getEndOffset());
                        }
                        break block17;
                    }
                    throw new AuthorOperationException("The table cell must be inside a table element.");
                }
                AuthorOperationException ex = new AuthorOperationException("The caret must be inside a table cell or a cell must be selected.");
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected DeleteRowOperationBase createDeleteRowOperation() {
        return new DeleteRowOperationBase(this.tableHelper){

            @Override
            protected SplitCellAboveBelowOperationBase createSplitCellOperation() {
                return null;
            }
        };
    }

    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor(ARGUMENT_NAME, 3, "The join direction relative to the source cell.", new String[]{JOIN_ABOVE, JOIN_BELOW}, JOIN_ABOVE)};
    }

    public String getDescription() {
        return "This operation joins the content of two cells from adjacent rows.";
    }
}

