/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.ECTableRowInsertionCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.SATableRowInsertionCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.TableRowsInfo;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class InsertRowOperationBase
extends AbstractTableOperation {
    private static final String XPATH_LOCATION_ARGUMENT = "insertLocation";
    private static final String RELATIVE_POSITION_ARGUMENT = "insertPosition";
    private static final String CUSTOM_ROW_INSERTION_ARGUMENT = "customRowInsertion";
    protected static final ArgumentDescriptor CUSTOM_INSERTION_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("customRowInsertion", 3, "A boolean specifying if the custom row insertion has been requested or not. A custom insertion allows the user to choose the number of rows to be inserted and the position of insertion (above or below the current row).", new String[]{"true", "false"}, "false");
    private ArgumentDescriptor[] arguments = this.getOperationArguments();

    protected ArgumentDescriptor[] getOperationArguments() {
        ArgumentDescriptor argumentDescriptor = new ArgumentDescriptor(XPATH_LOCATION_ARGUMENT, 2, "An XPath expression indicating the insert location for the new table row.\nNote: If it is not defined then the insert location will be at the caret.");
        argumentDescriptor = new ArgumentDescriptor(RELATIVE_POSITION_ARGUMENT, 3, "The insert position relative to the node determined by the XPath expression.\nCan be: Before, Inside as first child, Inside as last child or After.\nNote: If the XPath expression is not defined this argument is ignored.", new String[]{"Before", "Inside as first child", "Inside as last child", "After"}, "Inside as first child");
        argumentDescriptor = CUSTOM_INSERTION_ARGUMENT_DESCRIPTOR;
        ArgumentDescriptor[] args = new ArgumentDescriptor[]{argumentDescriptor, argumentDescriptor, NAMESPACE_ARGUMENT_DESCRIPTOR, argumentDescriptor};
        return args;
    }

    public InsertRowOperationBase(AuthorTableHelper documentTypeHelper) {
        super(documentTypeHelper, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        try {
            AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            AuthorElement tableElement = this.getElementAncestor(nodeAtCaret, 2);
            if (tableElement == null) return;
            int noOfRowsToBeInserted = 0;
            String relativePosition = "";
            TableRowsInfo tableRowInfo = null;
            if ("true".equals(args.getArgumentValue(CUSTOM_ROW_INSERTION_ARGUMENT))) {
                Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
                if (Platform.STANDALONE == platform) {
                    tableRowInfo = SATableRowInsertionCustomizerInvoker.getInstance().customizeTableRowInsertion(authorAccess);
                } else if (Platform.ECLIPSE == platform) {
                    tableRowInfo = ECTableRowInsertionCustomizerInvoker.getInstance().customizeTableRowInsertion(authorAccess);
                }
                if (tableRowInfo == null) throw new AuthorOperationStoppedByUserException("Cancelled by user");
                noOfRowsToBeInserted = tableRowInfo.getRowsNumber();
                relativePosition = tableRowInfo.isInsertBelow() ? "After" : "Before";
            } else {
                noOfRowsToBeInserted = 1;
                relativePosition = args.getArgumentValue(RELATIVE_POSITION_ARGUMENT).toString();
            }
            this.insertRows(authorAccess, (String)args.getArgumentValue(XPATH_LOCATION_ARGUMENT), (String)args.getArgumentValue("namespace"), nodeAtCaret, tableElement, noOfRowsToBeInserted, relativePosition);
            return;
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public void insertRows(AuthorAccess authorAccess, String xPathLocation, String namespace, AuthorNode nodeAtCaret, AuthorElement tableElement, int noOfRowsToBeInserted, String relativePosition) throws BadLocationException, AuthorOperationException {
        AuthorElement table;
        AuthorElement referenceRowElement = null;
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        referenceRowElement = this.getElementAncestor(nodeAtCaret, 1);
        if (referenceRowElement == null && (table = this.getElementAncestor(nodeAtCaret, 2)) != null) {
            if ("Before".equals(relativePosition)) {
                AuthorNode fullySelectedNode = authorAccess.getEditorAccess().getFullySelectedNode();
                if (fullySelectedNode != null && this.tableHelper.isTableRow(fullySelectedNode)) {
                    referenceRowElement = (AuthorElement)fullySelectedNode;
                    xPathLocation = documentController.getXPathExpression(referenceRowElement.getStartOffset() + 1);
                } else {
                    AuthorNode nodeBelowCurrentOffset = documentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() + 1);
                    referenceRowElement = this.getElementAncestor(nodeBelowCurrentOffset, 1);
                }
            } else if ("After".equals(relativePosition)) {
                AuthorNode nodeAboveCurrentOffset = documentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() - 1);
                referenceRowElement = this.getElementAncestor(nodeAboveCurrentOffset, 1);
            }
        }
        StringBuilder xmlFragmentBuilder = new StringBuilder();
        for (int i = 0; i < noOfRowsToBeInserted; ++i) {
            xmlFragmentBuilder.append(this.getRowXMLFragment(authorAccess, tableElement, referenceRowElement, this.useCurrentRowTemplateOnInsert(), namespace, "Before".equals(relativePosition)));
        }
        String xmlFragment = xmlFragmentBuilder.toString();
        if (!xmlFragment.isEmpty()) {
            documentController.insertXMLFragmentSchemaAware(xmlFragment, xPathLocation, relativePosition);
            if (referenceRowElement != null) {
                Object startUpdateRowSpansRow = referenceRowElement;
                if ("Before".equals(relativePosition)) {
                    AuthorNode prevRow = documentController.getNodeAtOffset(referenceRowElement.getStartOffset() - 1);
                    startUpdateRowSpansRow = prevRow.getType() == 0 && this.tableHelper.isTableRow(prevRow) ? (AuthorElement)prevRow : null;
                }
                if (startUpdateRowSpansRow != null) {
                    this.incrementRowSpans(tableElement, (AuthorElement)startUpdateRowSpansRow, authorAccess, 1, noOfRowsToBeInserted, relativePosition);
                }
            }
        }
    }

    public String getRowXMLFragment(AuthorAccess authorAccess, AuthorElement tableElement, String namespace, String newCellFragment, int newCellColumnIndex, int initialNumberOfColumns) throws BadLocationException {
        String rowName;
        StringBuilder newRowStructure = null;
        if (newCellFragment != null && newCellColumnIndex <= initialNumberOfColumns && (rowName = this.getRowElementName(tableElement)) != null) {
            newRowStructure = new StringBuilder("<").append(rowName);
            if (namespace != null) {
                int prefixDelimiter = rowName.indexOf(58);
                String prefix = null;
                if (prefixDelimiter > 0) {
                    prefix = rowName.substring(0, prefixDelimiter);
                }
                newRowStructure.append(" xmlns");
                if (prefix != null) {
                    newRowStructure.append(":").append(prefix);
                }
                newRowStructure.append("=\"").append(namespace).append("\"");
            }
            newRowStructure.append(">");
            for (int i = 0; i < initialNumberOfColumns; ++i) {
                String cellName = this.getCellElementName(tableElement, i);
                if (i == newCellColumnIndex) {
                    newRowStructure.append(newCellFragment);
                }
                if (cellName == null) continue;
                String defaultContentForEmptyCells = this.getDefaultContentForEmptyCells();
                if (defaultContentForEmptyCells != null) {
                    newRowStructure.append("<").append(cellName).append(">");
                    newRowStructure.append(defaultContentForEmptyCells);
                    newRowStructure.append("</").append(cellName).append(">");
                    continue;
                }
                newRowStructure.append("<").append(cellName).append("/>");
            }
            if (newCellColumnIndex == initialNumberOfColumns) {
                newRowStructure.append(newCellFragment);
            }
            newRowStructure.append("</").append(rowName).append(">");
        }
        return newRowStructure == null ? null : newRowStructure.toString();
    }

    private String getRowXMLFragment(AuthorAccess authorAccess, AuthorElement tableElement, AuthorElement referenceRowElement, boolean preferReferencedRow, String namespace, boolean before) throws BadLocationException {
        String defaultRowElementName;
        StringBuilder newRowStructure = null;
        String rowName = defaultRowElementName = this.getRowElementName(tableElement);
        if (defaultRowElementName == null) {
            if (referenceRowElement != null) {
                rowName = referenceRowElement.getName();
            }
        } else if (preferReferencedRow) {
            rowName = referenceRowElement != null ? referenceRowElement.getName() : defaultRowElementName;
        }
        String string = namespace = preferReferencedRow && referenceRowElement != null ? referenceRowElement.getNamespace() : namespace;
        if (rowName != null) {
            newRowStructure = new StringBuilder("<").append(rowName);
            if (namespace != null) {
                int prefixDelimiter = rowName.indexOf(58);
                String prefix = null;
                if (prefixDelimiter > 0) {
                    prefix = rowName.substring(0, prefixDelimiter);
                }
                newRowStructure.append(" xmlns");
                if (prefix != null) {
                    newRowStructure.append(":").append(prefix);
                }
                newRowStructure.append("=\"").append(namespace).append("\"");
            }
            newRowStructure.append(">");
            boolean useReferenceRowElement = preferReferencedRow;
            if (!useReferenceRowElement && this.getCellElementName(tableElement, 0) == null) {
                useReferenceRowElement = true;
            }
            if (referenceRowElement != null && useReferenceRowElement) {
                AuthorTableCellSpanProvider spanProvider = this.tableHelper.getTableCellSpanProvider(tableElement);
                List contentNodes = referenceRowElement.getContentNodes();
                String[] ignoredAttributes = InsertRowOperationBase.mergeArrays(this.tableHelper.getIgnoredRowAttributes(), this.tableHelper.getIgnoredCellIDAttributes());
                ArrayList<String> allIgnoredAttrs = new ArrayList<String>();
                allIgnoredAttrs.addAll(Arrays.asList(ignoredAttributes));
                String[] allowedAttributes = this.tableHelper instanceof AbstractDocumentTypeHelper ? ((AbstractDocumentTypeHelper)this.tableHelper).getAllowedCellAttributesToCopy() : null;
                for (AuthorNode cellNode : contentNodes) {
                    Integer rowSpan;
                    if (cellNode.getType() != 0 || (rowSpan = spanProvider.getRowSpan((AuthorElement)cellNode)) != null && rowSpan >= 2 && !before) continue;
                    String cellXMLFragment = this.createCellXMLFragment((AuthorElement)cellNode, ignoredAttributes, allowedAttributes, this.getDefaultContentForEmptyCells());
                    newRowStructure.append(cellXMLFragment);
                }
            } else {
                int colsNumber = authorAccess.getTableAccess().getTableNumberOfColumns(tableElement);
                if (colsNumber > 0) {
                    for (int i = 0; i < colsNumber; ++i) {
                        this.createCell(tableElement, newRowStructure, i);
                    }
                } else if (colsNumber <= 0) {
                    this.createCell(tableElement, newRowStructure, 0);
                }
            }
            newRowStructure.append("</").append(rowName).append(">");
        }
        return newRowStructure == null ? null : newRowStructure.toString();
    }

    private void createCell(AuthorElement tableElement, StringBuilder newRowStructure, int i) {
        String cellName = this.getCellElementName(tableElement, i);
        if (cellName != null) {
            String defaultContentForEmptyCells = this.getDefaultContentForEmptyCells();
            if (defaultContentForEmptyCells != null) {
                newRowStructure.append("<").append(cellName).append(">");
                newRowStructure.append(defaultContentForEmptyCells);
                newRowStructure.append("</").append(cellName).append(">");
            } else {
                newRowStructure.append("<").append(cellName).append("/>");
            }
        }
    }

    private static String[] mergeArrays(String[] array1, String[] array2) {
        String[] toRet;
        if (array1 == null) {
            toRet = array2;
        } else if (array2 == null) {
            toRet = array1;
        } else {
            String[] result = new String[array1.length + array2.length];
            System.arraycopy(array1, 0, result, 0, array1.length);
            System.arraycopy(array2, 0, result, array1.length, array2.length);
            toRet = result;
        }
        return toRet;
    }

    protected String createCellXMLFragment(AuthorElement cell, String[] skippedAttributes, String[] allowedAttributes, String cellContent) throws BadLocationException {
        StringBuilder cellXMLFragment = new StringBuilder();
        if (cell != null) {
            cellXMLFragment.append("<").append(cell.getName());
            int attributesCount = cell.getAttributesCount();
            for (int i = 0; i < attributesCount; ++i) {
                String attributeName = cell.getAttributeAtIndex(i);
                AttrValue attribute = cell.getAttribute(attributeName);
                if (!attribute.isSpecified()) continue;
                boolean skip = false;
                for (String skippedAttribute : skippedAttributes) {
                    if (!attributeName.equals(skippedAttribute)) continue;
                    skip = true;
                    break;
                }
                if (allowedAttributes != null) {
                    skip = true;
                    for (String allowedAttribute : allowedAttributes) {
                        if (!attributeName.equals(allowedAttribute)) continue;
                        skip = false;
                        break;
                    }
                }
                if (skip) continue;
                cellXMLFragment.append(" ").append(attributeName).append("=\"").append(attribute.getRawValue()).append("\"");
            }
            if (cellContent != null && cellContent.length() > 0) {
                cellXMLFragment.append(">");
                cellXMLFragment.append(cellContent);
                cellXMLFragment.append("</").append(cell.getName()).append(">");
            } else {
                cellXMLFragment.append("/>");
            }
        }
        return cellXMLFragment.toString();
    }

    private void incrementRowSpans(AuthorElement tableElement, AuthorElement referenceRowElement, AuthorAccess authorAccess, int minRowSpan, int numberOfInsertedRows, String relativePosition) throws BadLocationException {
        int tableNumberOfColumns = authorAccess.getTableAccess().getTableNumberOfColumns(tableElement);
        AuthorTableCellSpanProvider spanProvider = null;
        List cells = referenceRowElement.getContentNodes();
        int currentRowSize = cells.size();
        for (AuthorNode cellNode : cells) {
            Integer rowSpan;
            if (cellNode.getType() != 0 || !this.tableHelper.isTableCell(cellNode)) continue;
            AuthorElement cellElement = (AuthorElement)cellNode;
            if (spanProvider == null) {
                spanProvider = this.tableHelper.getTableCellSpanProvider(tableElement);
            }
            if ((rowSpan = spanProvider.getRowSpan(cellElement)) == null || rowSpan <= 1 || rowSpan < minRowSpan && (!"Before".equals(relativePosition) || rowSpan + numberOfInsertedRows <= minRowSpan)) continue;
            this.tableHelper.updateTableRowSpan(authorAccess, cellElement, rowSpan + numberOfInsertedRows);
        }
        if (tableNumberOfColumns != currentRowSize) {
            AuthorNode prevRow = authorAccess.getDocumentController().getNodeAtOffset(referenceRowElement.getStartOffset() - 1);
            ++minRowSpan;
            if (prevRow.getType() == 0 && this.tableHelper.isTableRow(prevRow)) {
                this.incrementRowSpans(tableElement, (AuthorElement)prevRow, authorAccess, minRowSpan, numberOfInsertedRows, relativePosition);
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Insert a table row.";
    }

    protected abstract String getCellElementName(AuthorElement var1, int var2);

    protected abstract String getRowElementName(AuthorElement var1);

    protected boolean useCurrentRowTemplateOnInsert() {
        return false;
    }

    protected String getDefaultContentForEmptyCells() {
        return null;
    }

    protected static ArgumentDescriptor[] removeCustomInsertionDescriptor(ArgumentDescriptor[] superArguments) {
        ArrayList arguments = new ArrayList(superArguments.length);
        Collections.addAll(arguments, superArguments);
        arguments.remove(CUSTOM_INSERTION_ARGUMENT_DESCRIPTOR);
        return arguments.toArray(new ArgumentDescriptor[0]);
    }
}

