/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class AbstractTableOperation
implements AuthorOperation {
    static final String CHANGE_TRACKING_BEHAVIOR = "changeTrackingBehavior";
    static final String CHANGE_TRACKING_BEHAVIOR_BLOCK = "Block";
    static final String CHANGE_TRACKING_BEHAVIOR_ALLOW = "Allow";
    static final String CHANGE_TRACKING_BEHAVIOR_ALLOW_WITHOUT = "Allow with change tracking disabled";
    static final String CHANGE_TRACKING_BEHAVIOR_AUTO = "Auto";
    public static final ArgumentDescriptor CHANGE_TRACKING_BEHAVIOR_ARGUMENT = new ArgumentDescriptor("changeTrackingBehavior", 3, "Configures the operation behavior when change tracking is activated. Can be one of:\n - Block: The operation is not performed when change tracking is activated.\n - Allow: The operation is performed when change tracking is activated. If complex\n     table operations are performed, the resulting table layout may become broken.\n - Allow with change tracking disabled: The operation is performed with change tracking disabled.\n - Auto: Let the application decide which strategy to use, possibly by asking the end user.", new String[]{"Allow", "Allow with change tracking disabled", "Block", "Auto"}, "Auto");
    public static final String TABLE_INFO_ARGUMENT_NAME = "table_info";
    public static final ArgumentDescriptor TABLE_INFO_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("table_info", 5, "Details of the table that will be inserted in the document. The value of the argument should be a Java Map<String, Object> with keys corresponding to TableInfo fields.If a null value is passed in, the table customized dialog will be shown.");
    protected AuthorTableHelper tableHelper;
    private boolean supportsChangeTracking = false;

    public AbstractTableOperation(AuthorTableHelper authorTableHelper) {
        this(authorTableHelper, false);
    }

    public AbstractTableOperation(AuthorTableHelper authorTableHelper, boolean markAsChange) {
        this.tableHelper = authorTableHelper;
        this.supportsChangeTracking = markAsChange;
    }

    protected AuthorElement getElementAncestor(AuthorNode node, int type) {
        AuthorElement parentCell = null;
        while (node instanceof AuthorElement) {
            if (this.isTableElement(node, type)) {
                parentCell = (AuthorElement)node;
                break;
            }
            node = node.getParent();
        }
        if (parentCell != null && parentCell.getParent() != null && parentCell.getParent().getType() == 7) {
            AuthorNode parentOfRef = parentCell.getParent().getParent();
            if (this.tableHelper instanceof AbstractDocumentTypeHelper && ((AbstractDocumentTypeHelper)this.tableHelper).isContentReference(parentOfRef)) {
                parentCell = this.getElementAncestor(parentCell.getParent(), type);
            }
        }
        return parentCell;
    }

    protected boolean isElement(AuthorNode node, String elemLocalName) {
        return node instanceof AuthorElement && elemLocalName.equals(((AuthorElement)node).getLocalName());
    }

    protected boolean isTableElement(AuthorNode node, int type) {
        boolean toReturn = false;
        switch (type) {
            case 0: {
                toReturn = this.tableHelper.isTableCell(node);
                break;
            }
            case 1: {
                toReturn = this.tableHelper.isTableRow(node);
                break;
            }
            case 2: {
                toReturn = this.tableHelper.isTable(node);
            }
        }
        return toReturn;
    }

    protected int findCellInsertionOffset(AuthorAccess authorAccess, AuthorElement tableElement, int row, int column) {
        int insertionOffset = -1;
        AuthorElement insertRow = authorAccess.getTableAccess().getTableRow(row, tableElement);
        if (insertRow != null) {
            AuthorElement previousCell;
            insertionOffset = column == 0 ? insertRow.getStartOffset() + 1 : ((previousCell = this.findPreviousCellInRow(authorAccess, column, insertRow)) != null ? previousCell.getEndOffset() + 1 : insertRow.getStartOffset() + 1);
        }
        return insertionOffset;
    }

    private AuthorElement findPreviousCellInRow(AuthorAccess authorAccess, int column, AuthorElement row) {
        AuthorElement previousCell = null;
        for (AuthorNode authorNode : row.getContentNodes()) {
            int[] cellIndex;
            if (!this.tableHelper.isTableCell(authorNode) || (cellIndex = authorAccess.getTableAccess().getTableCellIndex((AuthorElement)authorNode)) == null) continue;
            if (cellIndex[1] >= column) break;
            previousCell = (AuthorElement)authorNode;
        }
        return previousCell;
    }

    protected AuthorDocumentFragment createEmptyCell(AuthorAccess authorAccess, AuthorElement cell, String[] skippedAttributes) throws BadLocationException {
        AuthorDocumentFragment newCellFragment = null;
        AuthorDocumentController controller = authorAccess.getDocumentController();
        newCellFragment = controller.createDocumentFragment((AuthorNode)cell, false);
        CommonsOperationsUtil.removeUnwantedAttributes(skippedAttributes, newCellFragment, controller);
        return newCellFragment;
    }

    public final void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        if (!this.supportsChangeTracking && authorAccess.getReviewController().isTrackingChanges()) {
            String behavior = AbstractTableOperation.getChangeTrackingBehavior(authorAccess, args);
            if (CHANGE_TRACKING_BEHAVIOR_ALLOW.equals(behavior)) {
                this.doOperationInternal(authorAccess, args);
            } else if (CHANGE_TRACKING_BEHAVIOR_ALLOW_WITHOUT.equals(behavior)) {
                this.doOperationWithoutChangeTracking(authorAccess, args);
            } else if (CHANGE_TRACKING_BEHAVIOR_BLOCK.equals(behavior)) {
                authorAccess.getWorkspaceAccess().showErrorMessage(authorAccess.getAuthorResourceBundle().getMessage("Table_operation_when_tc_error_message"));
            }
        } else {
            this.doOperationInternal(authorAccess, args);
        }
    }

    private static String getChangeTrackingBehavior(AuthorAccess authorAccess, ArgumentsMap args) {
        String behavior = (String)args.getArgumentValue(CHANGE_TRACKING_BEHAVIOR);
        if (behavior == null) {
            behavior = CHANGE_TRACKING_BEHAVIOR_AUTO;
        }
        if (CHANGE_TRACKING_BEHAVIOR_AUTO.equals(behavior)) {
            int response;
            behavior = authorAccess.getWorkspaceAccess().getPlatform() == Platform.WEBAPP ? CHANGE_TRACKING_BEHAVIOR_BLOCK : ((response = authorAccess.getWorkspaceAccess().showConfirmDialog(authorAccess.getAuthorResourceBundle().getMessage("Track_changes"), authorAccess.getAuthorResourceBundle().getMessage("Action_not_marked_as_change"), new String[]{"OK", authorAccess.getAuthorResourceBundle().getMessage("cancel")}, new int[]{1, 0})) == 1 ? CHANGE_TRACKING_BEHAVIOR_ALLOW_WITHOUT : CHANGE_TRACKING_BEHAVIOR_BLOCK);
        }
        return behavior;
    }

    private void doOperationWithoutChangeTracking(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        authorAccess.getReviewController().toggleTrackChanges();
        try {
            this.doOperationInternal(authorAccess, args);
        }
        finally {
            if (!authorAccess.getReviewController().isTrackingChanges()) {
                authorAccess.getReviewController().toggleTrackChanges();
            }
        }
    }

    protected abstract void doOperationInternal(AuthorAccess var1, ArgumentsMap var2) throws AuthorOperationException;
}

