/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.KeysController;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class CriterionComposite {
    private boolean addCheckbox;
    private Button keyCheckbox;
    private Combo keyCombo;
    private ComboViewer typeCombo;
    private ComboViewer orderCombo;
    private final KeysController keysController;
    private final List<CriterionInformation> allCriteria;

    public CriterionComposite(Composite parent, final AuthorResourceBundle authorResourceBundle, List<CriterionInformation> criterionInformation, CriterionInformation selectedItem, boolean isFirstCriterion, KeysController keysController, List<CriterionInformation> allCriteria) {
        this.keysController = keysController;
        this.allCriteria = allCriteria;
        boolean bl = this.addCheckbox = allCriteria.size() > 1;
        if (this.addCheckbox) {
            new Label(parent, 16384).setText("");
        }
        Label label = new Label(parent, 16384);
        label.setText(authorResourceBundle.getMessage(isFirstCriterion ? "Sort_by" : "And_then_by") + ":");
        GridData gd = new GridData(4, 0, true, false);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        if (this.addCheckbox) {
            this.keyCheckbox = new Button(parent, 16416);
            this.keyCheckbox.setText("");
            this.keyCheckbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CriterionComposite.this.changeControlsState();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    CriterionComposite.this.changeControlsState();
                }
            });
        }
        this.keyCombo = new Combo(parent, 8);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = this.addCheckbox ? 1 : 2;
        this.keyCombo.setLayoutData((Object)gd);
        this.keyCombo.setToolTipText(authorResourceBundle.getMessage("Select_key_column_tooltip"));
        this.keyCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.selectionChanged();
            }

            private void selectionChanged() {
                String currentSel = CriterionComposite.this.keyCombo.getItem(CriterionComposite.this.keyCombo.getSelectionIndex());
                if (currentSel != null) {
                    CriterionComposite.this.keysController.selectionChanged(currentSel, null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.selectionChanged();
            }
        });
        String[] criterionInfo = new String[criterionInformation.size()];
        for (int i = 0; i < criterionInformation.size(); ++i) {
            criterionInfo[i] = criterionInformation.get(i).getDisplayName();
        }
        this.keyCombo.setItems(criterionInfo);
        if (selectedItem != null) {
            int index = 0;
            for (int i = 0; i < this.keyCombo.getItemCount(); ++i) {
                if (!this.keyCombo.getItem(i).equals(selectedItem.getDisplayName())) continue;
                index = i;
                break;
            }
            this.keyCombo.select(index);
        } else {
            this.keyCombo.select(0);
        }
        this.typeCombo = new ComboViewer(parent, 8);
        this.typeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return authorResourceBundle.getMessage((String)element);
            }
        });
        this.typeCombo.getCombo().setToolTipText(authorResourceBundle.getMessage("Select_type_combo_tooltip"));
        this.typeCombo.getCombo().setItems(new String[]{CriterionInformation.TYPE.TEXT.getName(), CriterionInformation.TYPE.NUMERIC.getName(), CriterionInformation.TYPE.DATE.getName()});
        this.typeCombo.getCombo().select(0);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 1;
        this.typeCombo.getCombo().setLayoutData((Object)gd);
        this.orderCombo = new ComboViewer(parent, 8);
        this.orderCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return authorResourceBundle.getMessage((String)element);
            }
        });
        this.orderCombo.getCombo().setToolTipText(authorResourceBundle.getMessage("Select_order_combo_tooltip"));
        this.orderCombo.getCombo().setItems(new String[]{CriterionInformation.ORDER.ASCENDING.getName(), CriterionInformation.ORDER.DESCENDING.getName()});
        this.orderCombo.getCombo().select(0);
        gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 1;
        this.orderCombo.getCombo().setLayoutData((Object)gd);
        this.changeControlsState();
    }

    public Combo getKeyCombo() {
        return this.keyCombo;
    }

    public CriterionInformation getInformation() {
        CriterionInformation info = null;
        if (!this.addCheckbox || this.keyCheckbox.getSelection()) {
            int index = 0;
            if (this.keyCombo != null) {
                for (int i = 0; i < this.allCriteria.size(); ++i) {
                    if (!this.allCriteria.get(i).getDisplayName().equals(this.keyCombo.getItem(this.keyCombo.getSelectionIndex()))) continue;
                    index = i;
                    break;
                }
            }
            info = new CriterionInformation(index, this.typeCombo.getCombo().getItem(this.typeCombo.getCombo().getSelectionIndex()), this.orderCombo.getCombo().getItem(this.orderCombo.getCombo().getSelectionIndex()), this.keyCombo != null ? this.keyCombo.getItem(this.keyCombo.getSelectionIndex()) : "Column 1");
        }
        return info;
    }

    public void enableSortcriterion() {
        this.keyCheckbox.setSelection(true);
        this.changeControlsState();
    }

    private void changeControlsState() {
        this.keyCombo.setEnabled(!this.addCheckbox || this.keyCheckbox.getSelection());
        this.typeCombo.getCombo().setEnabled(!this.addCheckbox || this.keyCheckbox.getSelection());
        this.orderCombo.getCombo().setEnabled(!this.addCheckbox || this.keyCheckbox.getSelection());
    }
}

