/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SelectedTextOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)SelectedTextOperation.class.getName());

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap arguments) throws AuthorOperationException {
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        documentController.beginCompoundEdit();
        try {
            if (authorEditorAccess.hasSelection()) {
                List selectionIntervals = authorEditorAccess.getAuthorSelectionModel().getSelectionIntervals();
                ArrayList<ContentInterval> updatedSelectionIntervals = new ArrayList<ContentInterval>(selectionIntervals.size());
                List<int[]> selectionIntervalsToMark = SelectedTextOperation.convertSelectionIntervals(selectionIntervals);
                int caretOffset = authorEditorAccess.getCaretOffset();
                SelectionInterpretationMode selectionInterpretationMode = authorEditorAccess.getAuthorSelectionModel().getSelectionInterpretationMode();
                documentController.markSelection(selectionIntervalsToMark, caretOffset, selectionInterpretationMode, selectionIntervalsToMark, caretOffset, selectionInterpretationMode);
                int diff = 0;
                for (int i = 0; i < selectionIntervals.size(); ++i) {
                    ContentInterval contentInterval = (ContentInterval)selectionIntervals.get(i);
                    try {
                        int startOffset = contentInterval.getStartOffset() + diff;
                        int endOffset = contentInterval.getEndOffset() + diff;
                        Position endPosition = documentController.createPositionInContent(endOffset);
                        this.processContentRange(documentController, startOffset, endOffset - 1);
                        ContentInterval e = new ContentInterval(startOffset, endPosition.getOffset());
                        updatedSelectionIntervals.add(e);
                        diff += endPosition.getOffset() - endOffset;
                        continue;
                    }
                    catch (BadLocationException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
                documentController.markSelection(SelectedTextOperation.convertSelectionIntervals(updatedSelectionIntervals), authorEditorAccess.getCaretOffset(), authorEditorAccess.getAuthorSelectionModel().getSelectionInterpretationMode(), null, -1, null);
            }
        }
        finally {
            documentController.endCompoundEdit();
        }
    }

    private static List<int[]> convertSelectionIntervals(List<ContentInterval> intervals) {
        ArrayList<int[]> toReturn = new ArrayList<int[]>(intervals.size());
        for (ContentInterval contentInterval : intervals) {
            toReturn.add(new int[]{contentInterval.getStartOffset(), contentInterval.getEndOffset()});
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContentRange(AuthorDocumentController controller, int selStart, int selEnd) {
        TextContentIterator iterator = controller.getTextContentIterator(selStart, selEnd);
        try {
            controller.beginCompoundEdit();
            while (iterator.hasNext()) {
                TextContext next = iterator.next();
                if (!next.inVisibleContent() || next.getEditableState() != 0 && next.getEditableState() != 1) continue;
                String content = next.getText().toString();
                content = this.processText(content);
                next.replaceText((CharSequence)content);
            }
        }
        finally {
            controller.endCompoundEdit();
        }
    }

    protected abstract String processText(String var1);
}

