/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class FormSelectedTextOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)FormSelectedTextOperation.class.getName());
    private static final char[] WORD_DELIMITERS_CHARS = new char[]{'.', ' ', ';', ':', '\"', '\'', ','};
    private AuthorAccess authorAccess;

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    protected abstract boolean isDelimiterBeforeTextNode(AuthorAccess var1, int var2) throws BadLocationException, AuthorOperationException;

    protected boolean isWordDelimiter(char ch) {
        boolean isDelimiter = false;
        for (int i = 0; i < WORD_DELIMITERS_CHARS.length; ++i) {
            if (WORD_DELIMITERS_CHARS[i] != ch) continue;
            isDelimiter = true;
            break;
        }
        return isDelimiter;
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap arguments) throws AuthorOperationException {
        this.authorAccess = authorAccess;
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        if (authorEditorAccess.hasSelection()) {
            AuthorDocumentController documentController = authorAccess.getDocumentController();
            int selectionStartOffset = authorEditorAccess.getSelectionStart();
            int selectionEndOffset = authorEditorAccess.getSelectionEnd();
            try {
                Position selEnd = documentController.createPositionInContent(selectionEndOffset);
                this.processContentRange(documentController, selectionStartOffset, selectionEndOffset - 1);
                authorEditorAccess.select(selectionStartOffset, selEnd.getOffset());
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContentRange(AuthorDocumentController documentController, int selStart, int selEnd) throws BadLocationException, AuthorOperationException {
        TextContentIterator iterator = documentController.getTextContentIterator(selStart, selEnd);
        try {
            documentController.beginCompoundEdit();
            while (iterator.hasNext()) {
                TextContext next = iterator.next();
                if (!next.inVisibleContent() || next.getEditableState() != 0 && next.getEditableState() != 1) continue;
                CharSequence text = next.getText();
                char[] charArray = text.toString().toCharArray();
                boolean isDelimiterBefore = this.isDelimiterBeforeTextNode(this.authorAccess, next.getTextStartOffset());
                charArray = this.processTextContent(charArray, isDelimiterBefore);
                text = String.copyValueOf(charArray);
                next.replaceText(text);
            }
        }
        finally {
            documentController.endCompoundEdit();
        }
    }

    protected abstract char[] processTextContent(char[] var1, boolean var2);
}

