/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.InsertFragmentOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class InsertOrReplaceFragmentOperation
extends InsertFragmentOperation {
    static final String POSITION_REPLACE = "Replace";
    private static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION = new ArgumentDescriptor("insertPosition", 3, "The insert position relative to the node determined by the XPath expression.\nCan be: Before, Inside as first child, Inside as last child, Replace or After.\nNote: If the XPath expression is not defined this argument is ignored", new String[]{"Before", "Inside as first child", "Inside as last child", "After", "Replace"}, "Inside as first child");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{ARGUMENT_DESCRIPTOR_FRAGMENT, ARGUMENT_DESCRIPTOR_XPATH_LOCATION, ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION, SCHEMA_AWARE_ARGUMENT_DESCRIPTOR, ARGUMENT_DESCRIPTOR_GO_TO_NEXT_EDITABLE_POSITION};

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        AuthorDocumentController controller = authorAccess.getDocumentController();
        controller.beginCompoundEdit();
        boolean deleteSelection = false;
        try {
            if (authorAccess.getEditorAccess().hasSelection()) {
                deleteSelection = true;
                authorAccess.getEditorAccess().deleteSelection();
            }
            Object xpathLocation = args.getArgumentValue("insertLocation");
            Object relativeLocation = args.getArgumentValue("insertPosition");
            if (POSITION_REPLACE.equals(relativeLocation)) {
                AuthorNode[] nodes;
                String xpathLocationStr;
                if (xpathLocation instanceof String && (xpathLocationStr = (String)xpathLocation).trim().length() > 0 && (nodes = authorAccess.getDocumentController().findNodesByXPath(xpathLocationStr, true, true, true)) != null && nodes.length > 0) {
                    authorAccess.getEditorAccess().select(nodes[0].getStartOffset(), nodes[0].getEndOffset() + 1);
                    authorAccess.getEditorAccess().deleteSelection();
                }
                xpathLocation = null;
            }
            Object fragment = args.getArgumentValue("fragment");
            Object argumentValue = args.getArgumentValue("goToNextEditablePosition");
            if (argumentValue == null) {
                argumentValue = "true";
            }
            boolean goToFirstEditablePosition = "true".equals(argumentValue);
            Object schemaAwareArgumentValue = args.getArgumentValue("schemaAware");
            Object insertEvenIfInvalid = args.getArgumentValue("insertEvenIfInvalid");
            if (insertEvenIfInvalid == null) {
                insertEvenIfInvalid = "true";
            }
            boolean isInsertEvenIfInvalid = "true".equals(insertEvenIfInvalid);
            this.doOperationInternal(authorAccess, fragment, xpathLocation, relativeLocation, goToFirstEditablePosition, schemaAwareArgumentValue, isInsertEvenIfInvalid);
        }
        catch (AuthorOperationException e) {
            if (deleteSelection) {
                controller.cancelCompoundEdit();
            }
            throw e;
        }
        finally {
            controller.endCompoundEdit();
        }
    }

    @Override
    public String getDescription() {
        return "Insert a document fragment. If selection is present, the selection will be replaced with the given fragment.";
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }
}

