/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import javax.xml.namespace.QName;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ChangeAttributeOperation
implements AuthorOperation {
    static final String ARGUMENT_ATTRIBUTE_NAME = "name";
    static final String ARGUMENT_ATTRIBUTE_NAMESPACE = "namespace";
    static final String ARGUMENT_ELEMENT_XPATH_LOCATION = "elementLocation";
    static final String ARGUMENT_VALUE = "value";
    private static final String ARGUMENT_EDIT_ATTRIBUTE = "editAttribute";
    private static final String ARGUMENT_REMOVE_IF_EMPTY_VALUE = "removeIfEmpty";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[6];

    public ChangeAttributeOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_XPATH_LOCATION, 2, "An XPath expression indicating the element whose attribute will be changed.\nNote: If it is not defined then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ATTRIBUTE_NAME, 0, "The attribute local name.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ATTRIBUTE_NAMESPACE, 0, "The attribute namespace. Leave it empty for no namespace.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_VALUE, 0, "The attribute value. Set it empty to remove the attribute.");
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_REMOVE_IF_EMPTY_VALUE, 3, "True means that the attribute should be removed if an empty value is provided. The default behavior is to remove it.", new String[]{"true", "false"}, "true");
        this.arguments[5] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_EDIT_ATTRIBUTE, 3, "If an in-place editor exists for this attribute, it will automatically activate the in-pace editor and it will start editing.", new String[]{"true", "false"}, "true");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object editAttribute;
        Object removeIfEmpty;
        AuthorElement targetElement;
        Object value = args.getArgumentValue(ARGUMENT_VALUE);
        Object xpathLocation = args.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATION);
        Object name = args.getArgumentValue(ARGUMENT_ATTRIBUTE_NAME);
        Object namespaceObj = args.getArgumentValue(ARGUMENT_ATTRIBUTE_NAMESPACE);
        if (!(name instanceof String)) throw new IllegalArgumentException("The argument \"name\" was not defined!");
        if (xpathLocation instanceof String && !((String)xpathLocation).isEmpty()) {
            AuthorNode[] results = authorAccess.getDocumentController().findNodesByXPath((String)xpathLocation, true, true, true);
            if (results.length <= 0 || !(results[0] instanceof AuthorElement)) throw new AuthorOperationException("The element XPath location does not identify an element: " + xpathLocation);
            targetElement = (AuthorElement)results[0];
        } else {
            AuthorNode node = null;
            try {
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException("Cannot identify the current element", (Throwable)e);
            }
            for (node = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); node != null && !(node instanceof AuthorElement); node = node.getParent()) {
            }
            if (!(node instanceof AuthorElement)) throw new AuthorOperationException("You need to have the carret inside an element.");
            targetElement = (AuthorElement)node;
        }
        String attributeName = ((String)name).trim();
        String namespace = null;
        if (namespaceObj instanceof String) {
            namespace = ((String)namespaceObj).trim();
        }
        if ((removeIfEmpty = args.getArgumentValue(ARGUMENT_REMOVE_IF_EMPTY_VALUE)) == null) {
            removeIfEmpty = "true";
        }
        if ((editAttribute = args.getArgumentValue(ARGUMENT_EDIT_ATTRIBUTE)) == null) {
            editAttribute = "true";
        }
        boolean editAttributeBoolean = "true".equals(editAttribute);
        String usedAttributeQName = CommonsOperationsUtil.setAttributeValue(authorAccess.getDocumentController(), targetElement, new QName(namespace, attributeName, ""), (String)value, "true".equals(removeIfEmpty));
        if (value == null || "".equals(value) && "true".equals(removeIfEmpty) || !editAttributeBoolean) return;
        authorAccess.getEditorAccess().editAttribute(targetElement, usedAttributeQName);
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Add/change/remove an attribute of an element.";
    }
}

