<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  exclude-result-prefixes="xs"
  xmlns:xr="http://www.oxygenxml.com/ns/xmlRefactoring"
  version="3.0"
  xmlns:saxon="http://saxon.sf.net/"
  xpath-default-namespace="http://www.oxygenxml.com/ns/samples/personal">
  
  <!-- The XPath identyfing the target elements -->        
  <xsl:param name="element_xpath" as="xs:string" required="yes"/>
  
  <!-- Identify the affected elements  -->
  <xsl:variable name="elements" as="element()*">
    <xsl:evaluate xpath="$element_xpath" as="element()*" context-item="/" namespace-context="/*"/>
  </xsl:variable>
  
  <xsl:variable name="element_ln" select="distinct-values($elements/local-name())"/>
  
  <xsl:template match="*[local-name() = $element_ln][. = $elements]">
    <xsl:apply-templates select="node()"/>
  </xsl:template>
  
  <xsl:template match="* | text() | comment() | processing-instruction() | @*">
    <xsl:copy>
      <xsl:apply-templates select="node() | @*"/>
    </xsl:copy>
  </xsl:template>
  
</xsl:stylesheet>