xquery version "3.0" encoding "utf-8";

(: 
    XQuery document used to implement 'Unwrap element' operation from XML Refactor tool.    
:)

declare namespace output = "http://www.w3.org/2010/xslt-xquery-serialization";
declare namespace saxon = "http://saxon.sf.net/";

declare option output:method   "xml";
declare option output:indent   "no";

(: The XPath that localize the element. :)
declare variable $element_xpath as xs:string external;

declare function local:eval($expression as xs:string, $context-item as item()?) as item()* {
  transform(
    map {
      'stylesheet-node' : <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="3.0" 
        xmlns:mf="http://example.com/mf"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="#all">
        <xsl:function name="mf:eval" as="item()*" visibility="public">
          <xsl:param name="expression" as="xs:string"/>
          <xsl:param name="context-item" as="item()?"/>
          <xsl:evaluate xpath="$expression" context-item="$context-item" namespace-context="$context-item"/>
        </xsl:function>
      </xsl:stylesheet>,
      'initial-function' : QName('http://example.com/mf', 'eval'),
      'function-params': [$expression, $context-item],
      'delivery-format': 'raw'
    }
  )?output
};


let $elements := local:eval($element_xpath, (./*)[1])
for $elem in $elements
    let $childrenNodes := $elem/node()
    let $parentNode := $elem/parent::node()
    where 
        $elem instance of element() and
        $parentNode instance of element()
	return 	  
	  (if (exists($childrenNodes)) 
	   then insert nodes $childrenNodes before $elem
	   else (),	 
	  delete node $elem)
	  