xquery version "3.0" encoding "utf-8";

(: 
    XQuery document used to implement 'Insert new element' operation from XML Refactor tool.    
:)

import module namespace xr = "http://www.oxygenxml.com/ns/xmlRefactoring" at "http://www.oxygenxml.com/ns/xmlRefactoring/resources/commons.xq";

declare namespace output = "http://www.w3.org/2010/xslt-xquery-serialization";
declare namespace saxon = "http://saxon.sf.net/";

declare option output:method   "xml";
declare option output:indent   "no";

(: The XPath that localize the anchor elements. The new element will be inserted relatively to these node. :)
declare variable $element_anchor_xpath as xs:string external;

(: The insert position relative to the node determined by the 'Element XPath' expression. :)
declare variable $insert_position as xs:string external;

(: The local name of the element to be inserted :)
declare variable $new_element_localname as xs:string external;

(: The namespace of the element to be inserted :)
declare variable $new_element_namespace as xs:string external;

declare function local:eval($expression as xs:string, $context-item as item()?) as item()* {
  transform(
    map {
      'stylesheet-node' : <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="3.0" 
        xmlns:mf="http://example.com/mf"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="#all">
        <xsl:function name="mf:eval" as="item()*" visibility="public">
          <xsl:param name="expression" as="xs:string"/>
          <xsl:param name="context-item" as="item()?"/>
          <xsl:evaluate xpath="$expression" context-item="$context-item" namespace-context="$context-item"/>
        </xsl:function>
      </xsl:stylesheet>,
      'initial-function' : QName('http://example.com/mf', 'eval'),
      'function-params': [$expression, $context-item],
      'delivery-format': 'raw'
    }
  )?output
};

(: Evaluate the XPath expression to get all anchor nodes :)
declare variable $anchorNodes := local:eval($element_anchor_xpath, (./*)[1]);

for $elem in $anchorNodes
  (: Compute the QName for the element to insert :)
  let $elementQName := xr:compute-qname($new_element_localname, $new_element_namespace, $elem)
    return
      switch ($insert_position) 
        case 'firstChild' 
            return insert nodes element {$elementQName} {} 
                as first into $elem
        case 'lastChild' 
            return insert nodes element {$elementQName} {} 
            as last into $elem
        case 'after'
        	return insert nodes element {$elementQName} {} 
            after $elem
        case 'before'
        	return insert nodes element {$elementQName} {} 
            before $elem
       default return ()