<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns="http://www.w3.org/1999/xhtml"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xr="http://www.oxygenxml.com/ns/xmlRefactoring"
    xmlns:whc="http://www.oxygenxml.com/webhelp/components"
    xmlns:saxon="http://saxon.sf.net/"
    exclude-result-prefixes="xs xr saxon"
    xpath-default-namespace="http://www.w3.org/1999/xhtml"
    version="3.0">

    <!-- Change whc:version attribute value -->
    <xsl:template match="@whc:version" mode="#default">
        <xsl:attribute name="whc:version">27.1</xsl:attribute>
    </xsl:template>

    <!-- Templates to remove the close publication and topic tocs within "wh_topic_body" -->
    <xsl:template match="div[@id = 'wh_topic_body']//button[@id = 'wh_close_publication_toc_button']" mode="#default"/>
    <xsl:template match="div[@id = 'wh_topic_body']//button[@id = 'wh_close_topic_toc_button']" mode="#default"/>

    <!-- Template to add the button that closes the publication toc inside the publication toc container -->
    <xsl:template match="div[@id = 'wh_publication_toc_content']" mode="#default">
        <xsl:copy>
            <xsl:apply-templates select="@*" mode="#current"/>
            <xsl:text>&#xa;</xsl:text>
            <button id="wh_close_publication_toc_button" class="close-toc-button d-none"
                aria-label="Toggle publishing table of content"
                aria-controls="wh_publication_toc" aria-expanded="true">
                <span class="close-toc-icon-container">
                    <span class="close-toc-icon"/>
                </span>
            </button>
            <xsl:text>&#xa;</xsl:text>
            <xsl:apply-templates select="node()" mode="#current"/>
        </xsl:copy>
    </xsl:template>

    <!-- Template to add the button that closes the topic toc inside the topic toc container -->
    <xsl:template match="div[@id = 'wh_topic_toc_content']" mode="#default">
        <xsl:copy>
            <xsl:apply-templates select="@*" mode="#current"/>
            <xsl:text>&#xa;</xsl:text>
            <button id="wh_close_topic_toc_button" class="close-toc-button d-none"
                aria-label="Toggle topic table of content"
                aria-controls="wh_topic_toc" aria-expanded="true">
                <span class="close-toc-icon-container">
                    <span class="close-toc-icon"/>
                </span>
            </button>
            <xsl:text>&#xa;</xsl:text>
            <xsl:apply-templates select="node()" mode="#current"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="header/div[@class = 'container-fluid']/@class" mode="#default">
        <xsl:attribute name="class">container-fluid navbar-expand-md</xsl:attribute>
    </xsl:template>

    <xsl:template match="header/div[@class = 'container-fluid']/div[contains(@class, 'wh_header_flex_container')]/@class" mode="#default">
        <xsl:attribute name="class">wh_header_flex_container navbar-nav navbar-dark</xsl:attribute>
    </xsl:template>

    <xsl:template match="a[@href = '#content' or @href = '#results' or @href = '#wh_topic_body']/@class" mode="#default">
        <xsl:attribute name="class">visually-hidden visually-hidden-focusable</xsl:attribute>
    </xsl:template>

    <xsl:template match="div[@id = 'wh_topic_container']/@class" mode="#default">
        <xsl:attribute name="class">container-fluid navbar-expand-md</xsl:attribute>
    </xsl:template>

    <xsl:template match="nav[contains(@class, 'wh_tools')]/@class" mode="#default">
        <xsl:attribute name="class">wh_tools d-print-none</xsl:attribute>
    </xsl:template>

    <xsl:template match="button[contains(@class, 'wh_toggle_button')]/@data-target" mode="#default">
        <xsl:attribute name="data-bs-target"><xsl:value-of select="."/></xsl:attribute>
    </xsl:template>

    <xsl:template match="button[contains(@class, 'wh_toggle_button')]/@data-toggle" mode="#default">
        <xsl:attribute name="data-bs-toggle"><xsl:value-of select="."/></xsl:attribute>
    </xsl:template>

    <xsl:template match="* | text() | processing-instruction() | comment() | @*" mode="#default">
        <xsl:copy>
            <xsl:apply-templates select="node() | @*"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
