<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:jatskit="https://github.com/wendellpiez/JATSKit/ns"
  exclude-result-prefixes="xs"
  version="2.0">
  
  <!-- delivers a sequence of BITS instances for a single BITS instance
         input. Each of the new instances is a single book with a single
         book-part, with the contents of a single book-part (or other element)
         marked for splitting.
         
         In place of descendant book-parts (or other elements) marked for splitting,
         it has (wrapped) xref elements pointing to them.
         
         (Marked with @specific-use flags to show they are generated by the split.)
         
         Note: having no ID on a book-part (or any element promoted to book-part) should be
         an error condition. Similarly, any duplicate ID anywhere should be an error condition
         due to cross-referencing complications - but these are prevented in the cleanup-IDs step -
         
         The results come wrapped in an ad hoc 'book-sequence' wrapper, in no namespace.
         
         When JATS is input, a BITS instance is returned with the JATS document
         presented as the single BITS book-part.
         (To do: map JATS metadata into BITS metadata for these purposes?)
         Note this is *not* guaranteed to be schema-valid to BITS!
         
         (Plus: can we use XLink to connect BITS sequences of JATS documents?)
         
         Note that xref[@rid] eventually needs to be rewritten as
         an external (not internal) link ... so it should be ornamented
         with an indicator of its closest ancestor book-part
         
         -->
  
  <!-- Mostly everything is copied. -->
  <xsl:template match="node() | @*">
    <xsl:copy>
      <xsl:apply-templates select="node() | @*"/>
    </xsl:copy>
  </xsl:template>
  
  <xsl:template match="/book">
    <jatskit:book-sequence>
      <xsl:copy-of select="/*/@jatskit:documentURI"/>
      <xsl:copy-of select="/*/namespace::*"/>
      <xsl:apply-templates select="//@jatskit:split/.." mode="split"/>
    </jatskit:book-sequence>
  </xsl:template>
  
  <!-- To split, we create a book, copy the top-level metadata,
       and go back up to the top to recurse back down to ourselves,
       copying the structure as we go. -->
  <!-- Note that each (split) book has metadata for the entire book. -->
  <xsl:template match="*[exists(@jatskit:split)]" mode="split">
    <xsl:variable name="splitting" select="."/>
    <book>
      <xsl:copy-of select="/book/@*"/>
      <xsl:copy-of select="/book/collection-meta"/>
      <xsl:copy-of select="/book/book-meta"/>
      <xsl:for-each select="ancestor::front-matter | ancestor::book-body | ancestor::book-back">
        <xsl:copy>
          <xsl:copy-of select="@*"/>
          <xsl:apply-templates select="$splitting" mode="make-book-part"/>
        </xsl:copy>
      </xsl:for-each>
    </book>
  </xsl:template>
  
  <!--<!-\- Template matches everything since it may be called recursively. -\->
  <xsl:template match="book" mode="copy-split">
    <!-\- $splitting is the element being split out.
      Inside a copy of the context node, we convert the $splitting to
      a book-part if it is a child, or continue descending if not. -\->
    <xsl:param tunnel="yes" name="splitting" as="element()" required="yes"/>
    <xsl:copy>
      <xsl:copy-of select="@* except @jatskit:split"/>
      <!-\- When at the book level, we copy the book-level metadata as well. -\->
      <xsl:copy-of select="book-meta"/>
      <xsl:apply-templates select="$splitting" mode="make-book-part"/>
      <!-\-<xsl:choose>
        <xsl:when test="exists(* intersect $splitting)">
          <xsl:apply-templates select="$splitting" mode="make-book-part"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="* intersect $splitting/ancestor::*" mode="#current"/>
        </xsl:otherwise>
      </xsl:choose>-\->
    </xsl:copy>
  </xsl:template>-->
  
  <!--<xsl:template match="book-part" mode="make-book-part">
    <xsl:copy>
      <xsl:apply-templates select="node() | @*"/>
    </xsl:copy>
  </xsl:template>
  
  <xsl:template match="*" mode="make-book-part">
    <xsl:apply-templates select="."/>
  </xsl:template>-->
  
  <xsl:template match="book-part" mode="make-book-part">
    <xsl:apply-templates select=".">
      <xsl:with-param name="splitting" tunnel="yes" select="."/>
    </xsl:apply-templates>
  </xsl:template>
  
  <xsl:template match="front-matter/*" mode="make-book-part">
    <xsl:apply-templates select=".">
      <xsl:with-param name="splitting" tunnel="yes" select="."/>
    </xsl:apply-templates>
  </xsl:template>
  
  <!-- Error trapping; if splitting is to happen on elements other than book-parts,
       they need (new) templates to make book-parts out of them. -->
  <xsl:template match="*" mode="make-book-part">
    <jatskit:error>
      <xsl:text>Unexpected match in mode 'make-book-part' on element </xsl:text>
      <xsl:value-of select="name()"/>
    </jatskit:error>
  </xsl:template>
  

  <xsl:template match="*[exists(@jatskit:split)]">
    <xsl:param name="splitting" tunnel="yes" required="yes"/>
    <xsl:choose>
      <!-- When at the element we are splitting out, we continue... -->
      <xsl:when test=". is $splitting">
        <xsl:next-match/>
      </xsl:when>
      <!-- When at any other element (marked for splitting) we insert a reference instead. --> 
      <xsl:otherwise>
        <jatskit:split to="{@id}"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
 
</xsl:stylesheet>