/* EditorVariablesParser.java */
/* Generated By:JavaCC: Do not edit this line. EditorVariablesParser.java */
package ro.sync.util.editorvars.parser;

import java.util.List;
import java.util.Stack;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.LinkedList;
import java.lang.Integer;
import java.io.StringReader;

import ro.sync.util.editorvars.parser.model.LexicalItem;
import ro.sync.util.editorvars.parser.model.PlainText;
import ro.sync.util.editorvars.parser.model.EditorVariable;
import ro.sync.util.editorvars.parser.model.CompoundLexicalItem;
import ro.sync.util.editorvars.parser.model.AskEditorVariable;
import ro.sync.util.editorvars.expander.ErrorListener;
import java.util.Map;
import java.util.LinkedHashMap;
import ro.sync.util.editorvars.expander.AskValueEnumParseException;

public class EditorVariablesParser implements EditorVariablesParserConstants {

        /**
	 * Logger for logging.
	 */
        private static final Logger logger = LoggerFactory.getLogger(EditorVariablesParser.class);

        /**
	 * Error listeners. Triggered when there is a parsing problem.
	 */
        private List<ErrorListener> errorListeners = new ArrayList<ErrorListener>();
        /**
	 * The parsed expression.
	 */
        private String parsedExpression;

        /**
	 * Add error listeners.
	 */
        public void addErrorListeners(List<ErrorListener> listeners) {
                errorListeners.addAll(listeners);
        }

        /**
	 * Notify error listeners.
	 */
        private void notifyErrorListeners(String edVarName, ParseException ex) {
                for (ErrorListener listener : errorListeners) {
                        listener.error(edVarName, ex);
                }
        }


        public EditorVariablesParser(String expression) {
                this(new StringReader(expression));

                this.parsedExpression = expression;
        }

        public List<LexicalItem> parseAskValueEnumerationPart() throws ParseException {
                // Set up the states.
            token_source.recordStateTransition(EditorVariablesParserConstants.ASK_PARAMS);
            token_source.SwitchTo(EditorVariablesParserConstants.ASK_PARAMS);

            try {
                return valueLabelEnumeration();
            } catch(ParseException ex) {
                ex.setParsedExpression(parsedExpression);

                AskValueEnumParseException newEx = new AskValueEnumParseException(ex.getMessage());
                newEx.initCause(ex);
                newEx.setParsedExpression(parsedExpression);

                notifyErrorListeners("ask", newEx);

                throw newEx;
            }

        }

/**
 * Inside a message token from within a $ask editor variable: 'message'
 */
  final public LexicalItem message() throws ParseException {List<LexicalItem> parts = new ArrayList<LexicalItem>();
  LexicalItem msg;
  Token token;
  LexicalItem toReturn = new PlainText("");
    jj_consume_token(ASK_MESS_START);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EDITOR_VAR_START:
      case ANSWER_VAR_PREFIX:
      case DATE_VAR_PREFIX:
      case XPATH_EVAL_VAR_PREFIX:
      case ASK_VAR_PREFIX:
      case MESSAGE_CHARS:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EDITOR_VAR_START:
      case ANSWER_VAR_PREFIX:
      case DATE_VAR_PREFIX:
      case XPATH_EVAL_VAR_PREFIX:
      case ASK_VAR_PREFIX:{
        msg = editorVariable();
parts.add(msg);
        break;
        }
      case MESSAGE_CHARS:{
        token = jj_consume_token(MESSAGE_CHARS);
String tokenTextVal = token.toString();
          if (tokenTextVal.equals("\\'")) {
            // EXM-44851: when escaping a quote, drop the backslash
            tokenTextVal = "'";
          }
          parts.add(new PlainText(tokenTextVal));
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(ASK_MESS_END);
parts = compact(parts);
    int size = parts.size();
    if (size == 1) {
        toReturn = parts.get(0);
    } else if (size > 1) {
        toReturn = new CompoundLexicalItem(parts);
    }
    {if ("" != null) return toReturn;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse the content.
 */
  final public List<LexicalItem> parse() throws ParseException {Token token;
  List<LexicalItem> lexicalItems = new ArrayList<LexicalItem>();
  LexicalItem editorVar;
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLAIN_TEXT:
      case EDITOR_VAR_START:
      case ANSWER_VAR_PREFIX:
      case DATE_VAR_PREFIX:
      case XPATH_EVAL_VAR_PREFIX:
      case ASK_VAR_PREFIX:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EDITOR_VAR_START:
      case ANSWER_VAR_PREFIX:
      case DATE_VAR_PREFIX:
      case XPATH_EVAL_VAR_PREFIX:
      case ASK_VAR_PREFIX:{
        editorVar = editorVariable();
lexicalItems.add(editorVar);
        break;
        }
      case PLAIN_TEXT:{
        token = jj_consume_token(PLAIN_TEXT);
lexicalItems.add(new PlainText(token.toString()));
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
{if ("" != null) return compact(lexicalItems);}
    throw new Error("Missing return statement in function");
  }

/**
 * I am inside the parameters section of the xpath_eval function. 
 * Eg: ${xpath_eval(....)}
 * 
 */
  final public List<LexicalItem> parseXPathParameters() throws ParseException {Token token;
  List<LexicalItem> lexicalItems = new ArrayList<LexicalItem>();
  LexicalItem editorVar;
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EDITOR_VAR_START:
      case ANSWER_VAR_PREFIX:
      case DATE_VAR_PREFIX:
      case XPATH_EVAL_VAR_PREFIX:
      case ASK_VAR_PREFIX:
      case XPATH_FUNCTION_PART:{
        ;
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      if (jj_2_1(2)) {
        editorVar = editorVariable();
lexicalItems.add(editorVar);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case XPATH_FUNCTION_PART:{
          token = jj_consume_token(XPATH_FUNCTION_PART);
lexicalItems.add(new PlainText(token.toString()));
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
List<LexicalItem> compactedParts = compact(lexicalItems);
          if (compactedParts.size() == 1) {
                  {if ("" != null) return compactedParts;}
          } else if(compactedParts.size() > 1) {
                  {if ("" != null) return Arrays.asList(new CompoundLexicalItem(compactedParts));}
          } else {
                  {if ("" != null) return compactedParts;}
          }
    throw new Error("Missing return statement in function");
  }

/**
 * A recognized editor variable.
 */
  final public LexicalItem editorVariable() throws ParseException {LexicalItem editorVar;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ANSWER_VAR_PREFIX:{
      editorVar = answer();
      break;
      }
    case XPATH_EVAL_VAR_PREFIX:{
      editorVar = xpath_eval();
      break;
      }
    case ASK_VAR_PREFIX:{
      editorVar = ask();
      break;
      }
    case DATE_VAR_PREFIX:{
      editorVar = date();
      break;
      }
    case EDITOR_VAR_START:{
      editorVar = genericEditorVariable();
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return editorVar;}
    throw new Error("Missing return statement in function");
  }

/**
 * A generic editor variable. ${name(param1, param2, ...)*}.
 */
  final public LexicalItem genericEditorVariable() throws ParseException {LexicalItem toReturn = null;
  Token editorVarStartToken = null;
  Token nameToken = null;
  Token unexpectedCharToken = null;
  List<LexicalItem> params = new ArrayList<LexicalItem>();
    editorVarStartToken = jj_consume_token(EDITOR_VAR_START);
    try {
      nameToken = jj_consume_token(NAME);
      parameters(params);
      jj_consume_token(EDITOR_VAR_END);
toReturn = new EditorVariable(nameToken.toString(), params);
    } catch (ParseException e) {
toReturn = handleParseException(e, nameToken != null ? nameToken.toString() : "", editorVarStartToken, EDITOR_VAR);
    }
{if ("" != null) return toReturn;}
    throw new Error("Missing return statement in function");
  }

/**
 * ${answer(@id)}
 */
  final public LexicalItem answer() throws ParseException {Token paramVal = null;
  Token varName = null;
  LexicalItem toReturn = null;
  Token editorVarStartToken = null;
  Token unexpectedCharToken = null;
  List<LexicalItem> params = new ArrayList<LexicalItem>();
    varName = jj_consume_token(ANSWER_VAR_PREFIX);
    jj_consume_token(PARAMS_START);
    try {
      paramVal = jj_consume_token(ANSWER_PARAM_VALUE);
      jj_consume_token(PARAMS_END);
      jj_consume_token(EDITOR_VAR_END);
params.add(new PlainText(paramVal.toString()));
        toReturn = new EditorVariable("answer", params);
    } catch (ParseException e) {
toReturn = handleParseException(e, "answer", varName, EDITOR_VAR);
    }
{if ("" != null) return toReturn;}
    throw new Error("Missing return statement in function");
  }

/**
 * ${date(dd-mm-yyyy)}
 */
  final public LexicalItem date() throws ParseException {Token paramVal = null;
  Token varName = null;
  LexicalItem toReturn = null;
  List<LexicalItem> params = new ArrayList<LexicalItem>();
    varName = jj_consume_token(DATE_VAR_PREFIX);
    try {
      paramVal = jj_consume_token(DATE_FORMAT);
      jj_consume_token(FUNCTION_SUFFIX);
params.add(new PlainText(paramVal.toString()));
        toReturn = new EditorVariable("date", params);
    } catch (ParseException e) {
toReturn = handleParseException(e, "date", varName, EDITOR_VAR);
    }
{if ("" != null) return toReturn;}
    throw new Error("Missing return statement in function");
  }

/**
 * ${xpath_eval(...)}.
 */
  final public LexicalItem xpath_eval() throws ParseException {Token paramVal;
  Token varName;
  LexicalItem toReturn;
  Token editorVarStartToken;
  Token unexpectedCharToken;
  List<LexicalItem> params = new ArrayList<LexicalItem>();
    varName = jj_consume_token(XPATH_EVAL_VAR_PREFIX);
    try {
      params = parseXPathParameters();
      jj_consume_token(FUNCTION_SUFFIX);
toReturn = new EditorVariable("xpath_eval", params);
    } catch (ParseException e) {
toReturn = handleParseException(e, "xpath_eval", varName, XPATH_EVAL_PARAMS);
    }
{if ("" != null) return toReturn;}
    throw new Error("Missing return statement in function");
  }

/**
 * ${ask(...)}. 
 */
  final public LexicalItem ask() throws ParseException {Token paramVal;
  Token varName;
  LexicalItem toReturn;
  LexicalItem askVar;
  Token editorVarStartToken;
  Token unexpectedCharToken;
  List<LexicalItem> params = new ArrayList<LexicalItem>();
    varName = jj_consume_token(ASK_VAR_PREFIX);
    try {
      askVar = parseAskParameters();
      jj_consume_token(FUNCTION_SUFFIX);
toReturn = askVar;
    } catch (ParseException e) {
toReturn = handleParseException(e, "ask", varName, ASK_PARAMS);
    }
{if ("" != null) return toReturn;}
    throw new Error("Missing return statement in function");
  }

/**
 * I am inside the parameters section of the "$ask" function. 
 * Eg: ${ask(..HERE..)}
 * 
 */
  final public EditorVariable parseAskParameters() throws ParseException {Token token;

  LexicalItem message = null;
  LexicalItem inputType = null;
  Token inputTypeToken = null;
  Iterable<LexicalItem> valueEnumeration = null;
  LexicalItem defaultValue = null;
  LexicalItem answerId = null;
  Token answerIdToken;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S:{
      jj_consume_token(S);
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    message = message();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S:{
      jj_consume_token(S);
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    if (jj_2_3(2)) {
      jj_consume_token(PARAM_SEP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_TYPE:{
        inputTypeToken = jj_consume_token(S_TYPE);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          ;
        }
        break;
        }
      case C_TYPE:{
        inputTypeToken = jj_consume_token(C_TYPE);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          ;
        }
        if (jj_2_2(2)) {
          jj_consume_token(PARAM_SEP);
          valueEnumeration = askValueEnum();
        } else {
          ;
        }
        break;
        }
      case UNKNOWN_TYPE_CHAR:{
        label_4:
        while (true) {
          jj_consume_token(UNKNOWN_TYPE_CHAR);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case UNKNOWN_TYPE_CHAR:{
            ;
            break;
            }
          default:
            jj_la1[11] = jj_gen;
            break label_4;
          }
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
inputType = new PlainText("generic");
                if (inputTypeToken != null) {
                        inputType = new PlainText(inputTypeToken.toString());
                }
    } else {
      ;
    }
    if (jj_2_4(2)) {
      jj_consume_token(PARAM_SEP);
      defaultValue = message();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        jj_consume_token(S);
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        ;
      }
    } else {
      ;
    }
    if (jj_2_5(2)) {
      jj_consume_token(PARAM_SEP);
      answerIdToken = jj_consume_token(ANSWER_ID);
answerId = new PlainText(answerIdToken.toString());
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PARAM_SEP:{
      jj_consume_token(PARAM_SEP);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
{if ("" != null) return new AskEditorVariable(
                  message,
                  inputType,
                  valueEnumeration,
                  defaultValue,
                  answerId);}
    throw new Error("Missing return statement in function");
  }

  final private List<LexicalItem> askValueEnum() throws ParseException {List<LexicalItem> valueEnumeration = new ArrayList<LexicalItem>();
    jj_consume_token(PARANTHESYS_START);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S:{
      jj_consume_token(S);
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    valueEnumeration = valueLabelEnumeration();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S:{
      jj_consume_token(S);
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    jj_consume_token(PARANTHESYS_END);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S:{
      jj_consume_token(S);
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
{if ("" != null) return valueEnumeration;}
    throw new Error("Missing return statement in function");
  }

  final private List<LexicalItem> valueLabelEnumeration() throws ParseException {LexicalItem label;
        LexicalItem value;
        List<LexicalItem> valueEnumeration = new ArrayList<LexicalItem>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case XPATH_EVAL_VAR_PREFIX:{
      value = xpath_eval();
valueEnumeration.add(value);
      break;
      }
    case ASK_MESS_START:{
      value = message();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        jj_consume_token(S);
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      jj_consume_token(COLON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        jj_consume_token(S);
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        ;
      }
      label = message();
valueEnumeration.add(value);
                  valueEnumeration.add(label);
      label_5:
      while (true) {
        if (jj_2_6(2)) {
          ;
        } else {
          break label_5;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
        if (jj_2_7(2)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            jj_consume_token(S);
            break;
            }
          default:
            jj_la1[22] = jj_gen;
            ;
          }
          value = message();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            jj_consume_token(S);
            break;
            }
          default:
            jj_la1[23] = jj_gen;
            ;
          }
          jj_consume_token(COLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            jj_consume_token(S);
            break;
            }
          default:
            jj_la1[24] = jj_gen;
            ;
          }
          label = message();
valueEnumeration.add(value);
                          valueEnumeration.add(label);
        } else {
          ;
        }
      }
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return valueEnumeration;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parameters list for a generic editor variable.
 */
  final public void parameters(List<LexicalItem> params) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PARAMS_START:{
      jj_consume_token(PARAMS_START);
      parameter(params);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PARAM_SEP:{
          ;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          break label_6;
        }
        jj_consume_token(PARAM_SEP);
        parameter(params);
      }
      jj_consume_token(PARAMS_END);
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      ;
    }
  }

/**
 * One parameter.
 */
  final public void parameter(List<LexicalItem> params) throws ParseException {LexicalItem editorVar = null;
  PlainText paramLiteral1 = null;
  PlainText paramLiteral2 = null;
  List<LexicalItem> parts = new ArrayList<LexicalItem>();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PARAM_VALUE:{
        paramLiteral1 = parameterLiteral();
parts.add(paramLiteral1);
        break;
        }
      case EDITOR_VAR_START:{
        editorVar = genericEditorVariable();
parts.add(editorVar);
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EDITOR_VAR_START:
      case PARAM_VALUE:{
        ;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_7;
      }
    }
if (parts.isEmpty()) {
         {if (true) throw new ParseException("Editor variable with missing parameters.");}
       }
       List<LexicalItem> compactedParts = compact(parts);
       if (compactedParts.size() == 1) {
           params.add(compactedParts.get(0));
       } else if (compactedParts.size() > 1) {
           params.add(new CompoundLexicalItem(compactedParts));
       }
  }

/**
 * One parameter literal.
 */
  final public PlainText parameterLiteral() throws ParseException {Token paramVal;
    paramVal = jj_consume_token(PARAM_VALUE);
{if ("" != null) return new PlainText(paramVal.toString().trim());}
    throw new Error("Missing return statement in function");
  }

  LexicalItem createPlainText(Token start, Token end) throws ParseException {StringBuilder sb = new StringBuilder();

  Token ct = start;
  do {
    sb.append(ct.image);
    ct = ct.next;
  } while (ct != end && ct != null);
  // Append the end token. The end token is the token
  // preceeding the one that triggered the parsing exception
  if (ct != null) {
    sb.append(ct.image);
    // Now also consume the offending token (that triggered the exception)
    ct = ct.next;
    sb.append(ct.image);
  }

  return new PlainText(sb.toString());
  }

  List<LexicalItem> compact(List<LexicalItem> lexicalItems) throws ParseException {LinkedList<LexicalItem> compacted = new LinkedList<LexicalItem>();

  LexicalItem previous = null;
  for (int i = 0; i < lexicalItems.size(); i++) {
    LexicalItem item = lexicalItems.get(i);
    if (previous != null
        && previous.getType() == LexicalItem.Type.PLAIN_TEXT
        && item.getType() == LexicalItem.Type.PLAIN_TEXT) {
      PlainText t1 = (PlainText) previous;
      PlainText t2 = (PlainText) item;
      // Merge.
      PlainText pt = new PlainText(t1.getText() + t2.getText());

      // Remove the previous from the list.
      compacted.removeLast();
      compacted.add(pt);
      previous = pt;
    } else {
      compacted.add(item);
      previous = item;
    }
  }

  return compacted;
  }

  LexicalItem handleParseException(ParseException e, String editorVariable, Token fallbackToken, int getOutOfState) throws ParseException {if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), e);
        }
        e.setParsedExpression(parsedExpression);
        notifyErrorListeners(editorVariable, e);
        LexicalItem toReturn = createPlainText(fallbackToken, e.currentToken);
    // The current token has been handled. Switch to the default state.
    token_source.getOutOfState(getOutOfState);
    // Prepare the next token.
    getNextToken();

    return toReturn;
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_24()
 {
    if (jj_scan_token(EDITOR_VAR_START)) return true;
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_21()
 {
    if (jj_scan_token(XPATH_EVAL_VAR_PREFIX)) return true;
    if (jj_3R_27()) return true;
    if (jj_scan_token(FUNCTION_SUFFIX)) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_29()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_7()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(17)) jj_scanpos = xsp;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_scan_token(MESSAGE_CHARS)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(PARAM_SEP)) return true;
    if (jj_scan_token(ANSWER_ID)) return true;
    return false;
  }

  private boolean jj_3R_25()
 {
    if (jj_3R_8()) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    }
    return false;
  }

  private boolean jj_3_6()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(17)) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_7()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(PARAM_SEP)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_20()
 {
    if (jj_scan_token(ANSWER_VAR_PREFIX)) return true;
    if (jj_scan_token(PARAMS_START)) return true;
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_17()
 {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_10()
 {
    if (jj_scan_token(S_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_12()
 {
    Token xsp;
    if (jj_scan_token(27)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(27)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_22()
 {
    if (jj_scan_token(ASK_VAR_PREFIX)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_13()
 {
    if (jj_scan_token(ASK_MESS_START)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_19()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ASK_MESS_END)) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_11()
 {
    if (jj_scan_token(C_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_15()
 {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_14()
 {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_8()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_14()) {
    jj_scanpos = xsp;
    if (jj_3R_15()) {
    jj_scanpos = xsp;
    if (jj_3R_16()) {
    jj_scanpos = xsp;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_9()
 {
    if (jj_scan_token(PARANTHESYS_START)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(PARAM_SEP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_10()) {
    jj_scanpos = xsp;
    if (jj_3R_11()) {
    jj_scanpos = xsp;
    if (jj_3R_12()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(PARAM_SEP)) return true;
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_23()
 {
    if (jj_scan_token(DATE_VAR_PREFIX)) return true;
    if (jj_scan_token(DATE_FORMAT)) return true;
    return false;
  }

  private boolean jj_3R_28()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(17)) jj_scanpos = xsp;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_scan_token(XPATH_FUNCTION_PART)) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) return true;
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_8()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public EditorVariablesParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[30];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x2000007c,0x2000007c,0x7e,0x7e,0x8000007c,0x80000000,0x7c,0x20000,0x20000,0x20000,0x20000,0x8000000,0x20000,0x9800000,0x20000,0x8000,0x20000,0x20000,0x20000,0x20000,0x20000,0x20000,0x20000,0x20000,0x20000,0x400020,0x8000,0x200,0x4004,0x4004,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public EditorVariablesParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public EditorVariablesParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new EditorVariablesParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 30; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 30; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public EditorVariablesParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new EditorVariablesParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 30; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new EditorVariablesParserTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 30; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public EditorVariablesParser(EditorVariablesParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 30; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(EditorVariablesParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 30; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[32];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 30; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 32; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
