<?xml version="1.0" encoding="UTF-8"?>
<!--
    
    This stylesheet copies the embedded SVG from the intermediate format to the output.
    
-->
<xsl:stylesheet version="2.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns:svg="http://www.w3.org/2000/svg"
  xmlns:fox="http://xmlgraphics.apache.org/fop/extensions"  
  exclude-result-prefixes="svg fox">
  
  <xsl:template match="svg:svg">
    <fo:instream-foreign-object>      
      <!-- Use as alternate text the first title or description. -->
      <xsl:variable name="alt-text" select="normalize-space(concat(svg:title, ' ', svg:desc))"/>
      <xsl:if test="string-length($alt-text) > 0">
        <xsl:attribute name="fox:alt-text" select="normalize-space($alt-text)"/>
      </xsl:if>
      
      <xsl:copy>
        <xsl:copy-of select="@*"/>
        
        <xsl:apply-templates mode="copy-svg"/>
      </xsl:copy>
    </fo:instream-foreign-object>
  </xsl:template>
  
  <xsl:template match="node() | @*" mode="copy-svg">
    <xsl:copy>
      <xsl:apply-templates select="node() | @*" mode="#current"/>
    </xsl:copy>
  </xsl:template>
  
  <!-- Add a base URI to referenced images. -->
  <xsl:template match="svg:image[not(@xml:base) and @*[local-name()='href']]" mode="copy-svg">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="xml:base" select="document-uri(/)"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  
</xsl:stylesheet>