<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns:chfox="http://www.oxygenxml.com/chemistry/extensions/fop"
  xmlns:css="http://www.w3.org/1998/CSS"
  xmlns:oxy="http://www.oxygenxml.com/css2fo"
  exclude-result-prefixes="xs chfox oxy"
  version="2.0">
  
  <!-- The default video cover. -->
  <xsl:param name="video-cover"/>
  <!-- The list of supported video extensions. -->
  <xsl:param name="extensions-list" select="tokenize('mov mp4 m4v 3gp 3g2', '\s')"/>
  
  <xsl:template match="css:uri[ancestor::css:before or ancestor::css:after or ancestor::css:content-on-element or ancestor::css:marker or ancestor::css:string-set]">
    <xsl:variable name="extension" select="tokenize(@uri, '\.|/')[last()]"/>
    <xsl:choose>
      <xsl:when test="not(@uri) or index-of($extensions-list, $extension)">
        <xsl:variable name="parent-element" select="../.."/>
        
        <xsl:variable name="src" select="@uri"/>
        
        <xsl:choose>
          <xsl:when test="$src">
            <fo:external-graphic chfox:video-src="{$src}">
              <xsl:variable name="cover" select="
                if ($parent-element/@css:oxy-video-cover) then
                $parent-element/@css:oxy-video-cover
                else
                $video-cover"/>
              <xsl:attribute name="src" select="$cover"/>
              
              <xsl:variable name="width" select="oxy:get-attr-from-static-or-parent($parent-element, .. , 'width')"/>
              <xsl:if test="$width">
                <xsl:attribute name="content-width" select="$width"/>
              </xsl:if>
              
              <xsl:variable name="height" select="oxy:get-attr-from-static-or-parent($parent-element, .. , 'height')"/>
              <xsl:if test="$height">
                <xsl:attribute name="content-height" select="$height"/>
              </xsl:if>
            </fo:external-graphic>
          </xsl:when>
          <xsl:otherwise>
            <xsl:message>WARNING No video source has been found.</xsl:message>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <!-- The css:uri is an image and will be processed in xmltofo-static-content-images.xsl. -->
        <xsl:next-match/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="@css:oxy-video-cover"/>
  
</xsl:stylesheet>
