<?xml version="1.0" encoding="UTF-8"?>
<!-- 
  Generates different FO elements based on the css:display attribute:
  
  css:display="inline" -> fo:inline
  etc..
-->
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:xs="http://www.w3.org/2001/XMLSchema" 
  xmlns:fo="http://www.w3.org/1999/XSL/Format" 
  xmlns:oxy="http://www.oxygenxml.com/css2fo" 
  xmlns:css="http://www.w3.org/1998/CSS" 
  exclude-result-prefixes="xs oxy css" 
  version="2.0">

  <!-- 
    Default template for all inlines.
  -->
  <xsl:template match="*[@css:display = 'inline']">
    <fo:inline>
      <xsl:apply-templates select="@*[local-name() != 'display'] except (@css:margin-left, @css:margin-right) | node()"/>
    </fo:inline>
  </xsl:template>

  <!-- 
   Transforms the CSS 'direction' and 'unicode-bidi' properties into a wrapping fo:bidi-override element. 
   -->
  <xsl:template match="*[@css:display = 'inline'][@css:unicode-bidi or @css:direction]" priority="5">
    <fo:bidi-override>
      <xsl:if test="@css:unicode-bidi">
        <xsl:attribute name="unicode-bidi" select="@css:unicode-bidi"/>
      </xsl:if>
      <xsl:if test="@css:direction">
        <xsl:attribute name="direction" select="@css:direction"/>
      </xsl:if>

      <xsl:next-match/>
    </fo:bidi-override>
  </xsl:template>

  <xsl:template match="@css:unicode-bidi" priority="5"/>

  <!-- 
    Deals with the inline margins. Since FOP does not 
    properly deals with space-start we need to create 
    additional inlines, acting as margins.
  -->
  <xsl:template match="*[@css:display = 'inline'][@css:margin-left != 'auto']" priority="4">
    <xsl:call-template name="generate-inline-margin-left">
      <xsl:with-param name="size" select="@css:margin-left"/>
    </xsl:call-template>

    <xsl:next-match/>
  </xsl:template>

  <xsl:template match="*[@css:display = 'inline'][@css:margin-right != 'auto']" priority="3">
    <xsl:next-match/>

    <xsl:call-template name="generate-inline-margin-right">
      <xsl:with-param name="size" select="@css:margin-right"/>
    </xsl:call-template>
  </xsl:template>

  <!--
    Generates a margin for an inline. Creates a synthetic inline, with a padding equal to the given size.
    
    @param size The size of the margin. If it is "null", no synthetic inline is created.
  -->
  <xsl:template name="generate-inline-margin-left">
    <xsl:param name="size"/>
    <xsl:if test="$size">
      <!-- We need this zero width space for FOP to apply the padding. -->
      <fo:inline padding-left="{$size}">&#x200b;</fo:inline>
    </xsl:if>
  </xsl:template>

  <!--
    Generates a margin for an inline. Creates a synthetic inline, with a padding equal to the given size.
    
    @param size The size of the margin. If it is "null", no synthetic inline is created.
  -->
  <xsl:template name="generate-inline-margin-right">
    <xsl:param name="size"/>
    <xsl:if test="$size">
      <!-- We need this zero width space for FOP to apply the padding. -->
      <fo:inline padding-right="{$size}">&#x200b;</fo:inline>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
