<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:css="http://www.w3.org/1998/CSS"
    exclude-result-prefixes="xs"
    version="2.0">


    <xsl:template match="*[@css:display = '-oxy-changebar-start']">
        <fo:change-bar-begin change-bar-class="change-bar">
            <!-- Select only the relevant styling attributes, to avoid invalid FO.  -->
            <xsl:apply-templates select="@css:oxy-changebar-width|
                                         @css:oxy-changebar-placement|
                                         @css:oxy-changebar-color|
                                         @css:oxy-changebar-offset|
                                         @css:oxy-changebar-style" />
                                         
        </fo:change-bar-begin>
    </xsl:template>
    
    <xsl:template match="*[@css:display = '-oxy-changebar-end']">
        <fo:change-bar-end change-bar-class="change-bar"/>
    </xsl:template>
        
    <!-- 
      The attributes for the fo:change-bar-begin element start with 'change-bar'.
      -->
    <xsl:template match="@css:*[starts-with(local-name(),'oxy-changebar-')]">
          <xsl:attribute name="{concat('change-bar-', substring-after(local-name(), 'oxy-changebar-'))}" select="."/>
    </xsl:template>
    
</xsl:stylesheet>