<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copies the styling attributes from the intermediate XML document to the FO elements.
    
    Example:
        <p  css:display="block" css:color="red" css:border-left="1mm" class="topic/p" />

        <fo:block color="red" border-left="1mm"/>
    
    Results in the copy of the 'p' node, if there are no other more 
    specific templates that match it,  and in the copy of the 
    of the css:attributes, buth without namespace. 
    
    The css:display is not copied, as it gives the type of FO element.
    The attributes from other namespaces are filtered out, because the FO becomes invalid.    
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:css="http://www.w3.org/1998/CSS"
    exclude-result-prefixes="css"
    version="2.0">
    
    <!-- Styling attributes -->
    <xsl:template match="@css:*" priority="1.5">        
        <xsl:attribute name="{local-name()}" select="."/>
    </xsl:template>
    
    <!-- Filter/Adapter that removes or translates from CSS properties names to XSL FO counterparts. -->
    <xsl:include href="xmltofo-copy-engine-property-filter.xsl"/>
    
    <!-- 
    	Do not copy attributes outside the CSS namespace.
    	We make an exception with the ID attribute, needed for page number citations,
    	and our extension attributes.
    -->
    <xsl:template match="@*[namespace-uri() != 'http://www.w3.org/1998/CSS' and namespace-uri() != 'http://www.oxygenxml.com/chemistry/extensions/fop' and local-name() != 'id']" priority="2"/>
    
    <xsl:template match="processing-instruction()" priority="2"/>

    <!-- Recursion. Useful for MathML or SVG. -->
    <xsl:template match="node() | @*">
        <xsl:copy>
            <xsl:apply-templates select="node() | @*"/>
        </xsl:copy>
    </xsl:template>
    
</xsl:stylesheet>