<?xml version="1.0" encoding="UTF-8"?>
<!-- 
   Filter/Adapter that removes or translates from CSS properties names to XSL FO counterparts.
    
    Example:
        css:text-decoration-style="solid" css:text-decoration-color="red" 

        css:text-decoration="solid"  

    Results in the removal of the text-decoration-color, because it is not supported in FO, and the rename of the first attribute.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:css="http://www.w3.org/1998/CSS"
    xmlns:chfox="http://www.oxygenxml.com/chemistry/extensions/fop"
    exclude-result-prefixes="css"
    version="2.0">

    <!-- Attributes that are not copied. -->
    <xsl:template match="@css:counter-reset" priority="2"/>        
    <xsl:template match="@css:display" priority="2"/>
    <xsl:template match="@css:link" priority="4"/>    
    <xsl:template match="@css:image-resolution" priority="4"/>
    <xsl:template match="@css:table-column" priority="4"/>
    <xsl:template match="@css:table-row" priority="4"/>
    <xsl:template match="@css:display-tags" priority="4"/>

    <xsl:template match="@css:empty-cells" priority="2"/>
    <xsl:template match="@css:placeholder-content" priority="2"/>
    <xsl:template match="*[@css:display='table-row']/@css:margin-top" priority="2"/>    
    <xsl:template match="*[@css:display='table-row']/@css:margin-right" priority="2"/>    
    <xsl:template match="*[@css:display='table-row']/@css:margin-bottom" priority="2"/>    
    <xsl:template match="*[@css:display='table-row']/@css:margin-left" priority="2"/>    
    
    <!-- Attributes that are translated. -->
    <xsl:template match="@css:column-span" priority="2">
        <xsl:attribute name="span" select='.'/>
    </xsl:template>    
    <xsl:template match="@xml:id" priority="4">
        <xsl:attribute name="id" select='.'/>
    </xsl:template>
    <xsl:template match="*:html//*:a/@name" priority="4">
        <xsl:attribute name="id" select='.'/>
    </xsl:template>
    
    <!-- Do not emit the same font settings on the children, if the parent has the same value. -->
    <xsl:template match="@css:font-family[../(ancestor::*[@css:font-family])[last()]/@css:font-family=current()]" priority="3"/>    
    <xsl:template match="@css:font-style[../(ancestor::*[@css:font-style])[last()]/@css:font-style=current()]" priority="3"/>    
    <xsl:template match="@css:font-size[../(ancestor::*[@css:font-size])[last()]/@css:font-size=current() and not(ends-with(current(), 'em'))]" priority="3"/>
    
    <!-- All fonts except the basic ones (that register both the oblique and italic to the same font key) register only the italic.
        We are changing from 'oblique' to 'italic', to avoid situations like:

            Font "Times New Roman,oblique,400" not found. Substituting with "Times New Roman,normal,400".        
    -->
    <xsl:template match="@css:font-style[lower-case(.) = 'oblique']" priority="2">
        <xsl:attribute name="font-style" select="'italic'"/>
    </xsl:template>    

    <!-- Vertical alignment for inlines, use the attribute as it is. -->
    <xsl:template match="@css:vertical-align[../@css:display='inline' or ../@css:display='inline-block']" priority="3">
        <xsl:attribute name="vertical-align" select="."/>
    </xsl:template>
        
    <!-- Vertical alignment for blocks or table cells. -->
    <xsl:template match="@css:vertical-align[.='middle']" priority="2">
        <xsl:attribute name="display-align" select="'center'"/>
    </xsl:template>
    <xsl:template match="@css:vertical-align[.='top']" priority="2">
        <xsl:attribute name="display-align" select="'before'"/>
    </xsl:template>
    <xsl:template match="@css:vertical-align[.='bottom']" priority="2">
        <xsl:attribute name="display-align" select="'after'"/>
    </xsl:template>
    <xsl:template match="@css:vertical-align[.='baseline']" priority="2">
        <xsl:attribute name="display-align" select="'auto'"/>
        <xsl:attribute name="relative-align" select="'baseline'"/>
    </xsl:template>
    
    <!-- Justified text alignment - the justify-all should be decomposed into two attributes. -->
    <xsl:template match="@css:text-align[.='justify-all']" priority="3">
        <xsl:attribute name="text-align" select="'justify'"/>
        <xsl:attribute name="text-align-last" select="'justify'"/>
    </xsl:template>

    <!-- Avoid ancestors text-align-last to be inherited. Reset it to the current text-align. -->
    <xsl:template match="@css:text-align[../ancestor::*[@css:text-align-last]]" priority="2">
      <xsl:attribute name="text-align" select="."/>
      <xsl:attribute name="text-align-last" select="."/>
    </xsl:template>
    
    <!-- Width fill value is not recognized by FOP, we pass it as a foreign attribute. -->
    <xsl:template match="@css:width[.='fill']" priority="3">
        <xsl:attribute name="chfox:fill" select="'yes'"/>
    </xsl:template>
    
    <!-- Column breaking is done by break-before/break-after and keep-with-previous/keep-with-next. -->
    <xsl:template match="@css:oxy-column-break-before[.='always']" priority="2">
        <xsl:attribute name="break-before" select="'column'"/>
    </xsl:template>
    <xsl:template match="@css:oxy-column-break-before[.='avoid']" priority="2">
        <xsl:attribute name="keep-with-previous.within-column" select="'always'"/>
    </xsl:template>
    <xsl:template match="@css:oxy-column-break-before[.='auto']" priority="2">
        <xsl:attribute name="break-before" select="'auto'"/>
        <xsl:attribute name="keep-with-previous.within-column" select="'auto'"/>
    </xsl:template>
    <xsl:template match="@css:oxy-column-break-after[.='always']" priority="2">
        <xsl:attribute name="break-after" select="'column'"/>
    </xsl:template>
    <xsl:template match="@css:oxy-column-break-after[.='avoid']" priority="2">
        <xsl:attribute name="keep-with-next.within-column" select="'always'"/>
    </xsl:template>
    <xsl:template match="@css:oxy-column-break-after[.='auto']" priority="2">
        <xsl:attribute name="break-after" select="'auto'"/>
        <xsl:attribute name="keep-with-next.within-column" select="'auto'"/>
    </xsl:template>
    <xsl:template match="@css:oxy-column-break-inside[.='avoid']" priority="3">
        <xsl:attribute name="keep-together.within-column" select="'always'"/>
    </xsl:template>
    <xsl:template match="@css:oxy-column-break-inside[.='auto']" priority="3">
        <xsl:attribute name="keep-together.within-column" select="'auto'"/>
    </xsl:template>
    
</xsl:stylesheet>