<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:css="http://www.w3.org/1998/CSS" 
  exclude-result-prefixes="xs"
  version="2.0">
  
  <!-- General template that transforms the CSS 'break-after' and 'break-before' properties
    into a XSL-FO 'break-after' and 'break-before' attributes.
  -->
  <xsl:template match="@css:break-after | @css:break-before">
    <xsl:choose>
      <xsl:when test=". = 'auto'">
        <xsl:attribute name="{local-name()}">auto</xsl:attribute>
      </xsl:when>
      <xsl:when test=". = 'page'">
        <xsl:attribute name="{local-name()}">page</xsl:attribute>
      </xsl:when>
      <xsl:when test=". = 'left'">
        <xsl:attribute name="{local-name()}">odd-page</xsl:attribute>
      </xsl:when>
      <xsl:when test=". = 'right'">
        <xsl:attribute name="{local-name()}">even-page</xsl:attribute>
      </xsl:when>
      <xsl:when test=". = 'column'">
        <xsl:attribute name="{local-name()}">column</xsl:attribute>
      </xsl:when>
      <xsl:when test=". = 'always' or . = 'all'">
        <xsl:attribute name="{concat('page-',local-name())}">always</xsl:attribute>
      </xsl:when>
      <xsl:when test=". = 'avoid' or . = 'avoid-page'">
        <xsl:attribute name="{concat('page-',local-name())}">avoid</xsl:attribute>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <!-- Specific template for 'break-after:avoid column' property -->
  <xsl:template match="@css:break-after[. =  'avoid-column']">
    <xsl:attribute name="keep-with-next.within-column" select="'always'"/>
  </xsl:template>
  
  <!-- Specific template for 'break-before:avoid column' property -->
  <xsl:template match="@css:break-before[. =  'avoid-column']">
    <xsl:attribute name="keep-with-previous.within-column" select="'always'"/>
  </xsl:template>

  <!-- General template that transforms the CSS 'break-inside' property
    into a XSL-FO 'break-inside' attribute. This property is created as
    an interface for page-break-inside
  -->
  <xsl:template match="@css:break-inside">
    <xsl:choose>
      <xsl:when test=". = 'auto'">
        <xsl:attribute name="page-break-inside">auto</xsl:attribute>
      </xsl:when>
      <xsl:when test=". = 'avoid'">
        <xsl:attribute name="page-break-inside">avoid</xsl:attribute>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
