<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xra="http://www.oxygenxml.com/ns/xmlRefactoring/additional_attributes"
    xmlns:f="http://www.oxygenxml.com/xsl/functions"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
    xmlns:xrf="http://www.oxygenxml.com/ns/xmlRefactoring/functions"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" version="3.0" exclude-result-prefixes="xra xrf xs xd f">
    
    <!-- DITA Composite output format -->
    <xsl:output name="dita" exclude-result-prefixes="#all" indent="yes" doctype-public="-//OASIS//DTD DITA Composite//EN" doctype-system="ditabase.dtd"/>
   
    <!-- true if we want to prefix the topics file name with the input file name. -->
    <xsl:param name="add.file.name.as.prefix" as="xs:boolean" select="true()"/>
   
    <!-- The DITA profiling attributes -->
    <xsl:param name="profilingAttributes" select="('audience', 'platform', 'product', 'otherprops', 'props', 'rev')"/>
   
    <xsl:param name="matchElement" select="('dita', 'topic', 'task', 'glossentry', 'concept', 'glossgroup', 'reference', 'troubleshooting')"/>
    <xsl:import href="topics-extraction-stylesheets/convert-nested-topics-to-new-topic.xsl"/>
    
    <xsl:template match="/*">
        <xsl:choose>
            <xsl:when test="count(.//*[f:match4extraction(.)]) > 0">
                <xsl:element name="map">
                    <title>
                        <xsl:choose>
                            <xsl:when test="title">
                                <xsl:value-of select="title"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:if test="'dita' = local-name(.)">
                                    <xsl:variable name="firstTopic" select="./*[1][f:match4extraction(.)]"/>
                                    <xsl:if test="$firstTopic and $firstTopic/title">
                                        <xsl:value-of select="$firstTopic/title"/>
                                    </xsl:if>
                                </xsl:if>
                            </xsl:otherwise>
                        </xsl:choose>
                    </title>
                    <xsl:choose>
                        <xsl:when test="'dita' = local-name(.) and count(./*[not(f:match4extraction(.))]) = 0">
                            <xsl:apply-templates  mode="topicRefEmit" select="./*"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates  mode="topicRefEmit" select="."/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="dita/*[1][f:match4extraction(.)]"  mode="topicRefEmit">
        <xsl:choose>
            <xsl:when test="f:isEmptyTopic(.)">
                <!-- EXM-49621: Ignore the first empty topic from a composite. Its title is used as map title  -->
            </xsl:when>
            <xsl:when test="f:isEmptyTopicWithNestedTopics(.) and count(following-sibling::*) = 0">
                <!-- EXM-49621: Ignore the first empty topic. Its title is used as map title  -->
                <xsl:apply-templates  mode="topicRefEmit" select="./*"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="processTopicref"></xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template> 
    
    <xsl:template match="/*[1][f:match4extraction(.)]"  mode="topicRefEmit">
        <xsl:choose>
            <xsl:when test="f:isEmptyTopicWithNestedTopics(.)">
                <!-- EXM-49621: Ignore the first empty topic. Its title is used as map title  -->
                <xsl:apply-templates  mode="topicRefEmit" select="./*"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="processTopicref"></xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="*"  mode="topicRefEmit">
        <xsl:choose>
            <xsl:when test="f:match4extraction(.)">
               <xsl:call-template name="processTopicref"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates mode="topicRefEmit" select="./*"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="processTopicref">
        <xsl:variable name="proposalName" select="f:generateOutputFileName(., base-uri())"/>
        <topicref>
            <xsl:attribute name="href"><xsl:value-of select="$proposalName"/></xsl:attribute>
             
            <!-- EXM-50515: Set chunk="to-content" on OAS Tag topics-->
            <xsl:if test="@outputclass[contains(., 'openapi-tag')]">
                <xsl:attribute name="chunk" select="'to-content'"/>
            </xsl:if>             
             
            <!-- Process profiling attributes -->
            <xsl:for-each select="./@*">
                <xsl:if test="local-name(.) = $profilingAttributes">
                    <xsl:copy-of select="."/>
                </xsl:if>
            </xsl:for-each>
            
            <xsl:apply-templates mode="emit" select="."/>
            <xsl:apply-templates mode="topicRefEmit" select="./*" />
        </topicref>
    </xsl:template>
    
    <xsl:template match="*[f:match4extraction(.)]/@*[local-name() = $profilingAttributes]" mode="write-sect">
       <!-- Ignore profiling attributes when creating topics because they were set on topicref elements. -->
    </xsl:template>
    
    <xd:doc>
        <xd:desc>Checks if the given topic is empty.</xd:desc>
        <xd:param name="topic">The topic to check.</xd:param>
        <xd:return>true if the given topic is empty.</xd:return>
    </xd:doc>
    <xsl:function name="f:isEmptyTopic" as="xs:boolean">
        <xsl:param name="topic" as="node()"/>
        <xsl:sequence select="count($topic/*) = 2 and $topic/title and $topic/body and count($topic/body/*) = 0"/>
    </xsl:function>
    
    <xd:doc>
        <xd:desc>Checks if the given topic is empty even if it contains nested topics.</xd:desc>
        <xd:param name="topic">The topic to check.</xd:param>
        <xd:return>true if the given topic is empty (even if it contains nested topics).</xd:return>
    </xd:doc>
    <xsl:function name="f:isEmptyTopicWithNestedTopics" as="xs:boolean">
        <xsl:param name="topic" as="node()"/>
        <xsl:sequence select="$topic/title and $topic/body and count($topic/body/*) = 0 
            and (count($topic/child::*[f:match4extraction(.)]) + 2 = count($topic/child::*))"/>
    </xsl:function>
</xsl:stylesheet>
