<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xhtml="http://www.w3.org/1999/xhtml"
    xmlns="http://www.w3.org/1999/xhtml"
    exclude-result-prefixes="xs xhtml"
    version="2.0">
    
    <xsl:output indent="yes"/>
    
    <xsl:template match="node() | @*" >
        <xsl:copy copy-namespaces="no">
            <xsl:apply-templates select="node() | @*"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="xhtml:div[@id = 'main']" >
        <xsl:apply-templates select="node()"/>
    </xsl:template>
    
    <xsl:template match="xhtml:div[@id = 'page']" >
        <xsl:apply-templates select="node()"/>
    </xsl:template>
    
    <xsl:template match="xhtml:div[@id = 'content']" >
        <xsl:apply-templates select="node()"/>
    </xsl:template>
 
    <!-- Keep only the h1 from the main-header div -->
    <xsl:template match="xhtml:div[@id = 'main-header']">
        <xsl:apply-templates select="./xhtml:div[@id = 'breadcrumb-section']"/>
        <xsl:apply-templates select="./xhtml:h1"/>
    </xsl:template>
    
    <!-- Keep only the text inside of the span -->
    <xsl:template match="xhtml:h1[@id = 'title-heading']" >
        <h1>
            <xsl:value-of select="normalize-space(substring-after(./xhtml:span,':'))"/>
        </h1>
    </xsl:template>
 
    <xsl:template match="xhtml:div[@id = 'breadcrumb-section']">
        <!-- Ignore breadcrumb section -->
    </xsl:template>
 
    <xsl:template match="xhtml:div[@id = 'footer']" >
        <!-- Ignore footnote -->
    </xsl:template>
    
    <!-- Make the divs for the prolog -->
    <xsl:template match="xhtml:div[@class='page-metadata']">
        <div id="oxy_prolog">
            <div id="oxy_prolog_author">
                <xsl:value-of select="normalize-space(./xhtml:span[@class='author'])" />
            </div>
            <div id="oxy_prolog_created">
                <xsl:value-of select="normalize-space(substring-after(.,'on'))"/>
            </div>
        </div>
    </xsl:template>
    
     <xsl:template match="xhtml:img/@src">
         <xsl:attribute name="src">
             <xsl:choose>
                 <xsl:when test="contains(., '?')">
                     <xsl:value-of select="substring-before(., '?')"/>
                 </xsl:when>
                 <xsl:otherwise>
                     <xsl:value-of select="."/>
                 </xsl:otherwise>
             </xsl:choose>
         </xsl:attribute>
     </xsl:template>
    
    <xsl:template match="xhtml:body/@class" >
       <!-- Ignore class attribute from body element -->
    </xsl:template>
</xsl:stylesheet>