/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors.spc;

import java.util.Map;

/**
 * Represents an element that has a parent element and whose parent element 
 * has no other element children. Same as :first-child:last-child or 
 * :nth-child(1):nth-last-child(1), but with a lower specificity. 
 * 
 * @author dan
 *
 * @see "http://www.w3.org/TR/css3-selectors/#only-child-pseudo"
 */
public class OnlyChildSPCCondition extends SPCCondition {

  /**
   * @see org.w3c.flute.parser.selectors.spc.SPCCondition#getType()
   */
  @Override
  public Type getType() {
    return Type.ONLY_CHILD;
  }


  /**
   * @see org.w3c.flute.parser.selectors.spc.NthChildSPCCondition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return ":only-child";
  }
}
