/*
 * (c) COPYRIGHT 1999 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 * $Id: NegativeCondition.java,v 1.2 1999/09/26 10:15:58 plehegar Exp $
 */
package org.w3c.flute.css.sac;

/**
 * The relational pseudo class.
 * 
 * https://drafts.csswg.org/selectors-4/#relational
 * 
 * @version $Revision: 1.2 $
 * @author  dan
 * @see Condition#SAC_HAS_CONDITION
 */
public interface HasCondition extends Condition {

    /**
     * Gets the selector.
     * 
     * :has(simple_selector)
     * 
     * @return The simple relative selector.
     */
    Selector getSelector();
    
    /**
     * The relative depth from the subject to the right end side of the selector. This 
     * is used only to implement old style subject selectors.
     * 
     * This is used when the given selector is a 
     * compatibility old style subject selector. For this selector
     * <pre>
     * A &gt; B &gt; C! &gt; D &gt;E
     * </pre>
     * the relative depth is 2, so the useful part of the selector will be <code>D &gt; E</code>. 
     * When using this constructor for the new :has() pseudo-class syntax:
     * <pre>
     * A &gt; B &gt; C:has( D &gt;E)
     * </pre>, the selector argument is <code>D &gt; E</code>, while the relative depth should be -1. 
     * 
     * @return Returns the relative depth.
     */
    int getRelativeDepth();
}
