<?xml version="1.0" encoding="UTF-8"?>
<!-- Stylesheet used for extracting text content. This is used to make sure that content was not lost after smart-paste.
It's used for smart-paste into DITA documents-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"
    xmlns:xhtml="http://www.w3.org/1999/xhtml" exclude-result-prefixes="#all"
    xpath-default-namespace="http://www.w3.org/1999/xhtml">
    <xsl:output omit-xml-declaration="yes"/>
    <xsl:template match="style"/>
    <xsl:template match="script"/>
    <xsl:template match="head"/>
    <xsl:template match="*">
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="node()"/>
        <xsl:text> </xsl:text>
    </xsl:template>
    <xsl:template match="xhtml:span[contains(@style, 'mso-list:Ignore') 
        or contains(@style, 'mso-list: Ignore')]"/>
    
    <!-- EXM-50679: Ignore comments from Word documents -->
    <xsl:template match="div[contains(@class, 'msocomtxt')]" priority="2.0">
        <!-- Ignore comment texts-->
    </xsl:template>
    <xsl:template match="div[@style = 'mso-element:comment']" priority="2.0">
        <!-- Ignore comments list -->
    </xsl:template>
    <xsl:template match="div[@style = 'mso-element:comment-list']" priority="2.0">
        <!-- Ignore comments list -->
    </xsl:template>  
    <xsl:template match="span[contains(@class, 'MsoCommentReference')]" priority="2.0">
        <!-- Ignore comment references-->
    </xsl:template>
    
    <!-- EXM-47802 -->
    <xsl:template match="xhtml:p[starts-with(@class, 'sdfootnote') or starts-with(@class, 'sdendnote')
            or starts-with(@class, 'MsoFootnoteText') or starts-with(@class, 'MsoEndnoteText')]"/>

    <xsl:template match="xhtml:a[starts-with(@href, '#')]">
        <xsl:variable name="currentId" select="normalize-space(substring(@href, 2))"/>
        <xsl:variable name="elementWithId"
            select="(//*[@id = $currentId] | //*[@name = $currentId])[1]"/>
        <xsl:variable name="isFootRef" select="
                starts-with($elementWithId/parent::node()/@class, 'sdfootnote')
                or starts-with($elementWithId/parent::node()/@class, 'sdendnote')
                or starts-with($elementWithId/parent::node()/@class, 'MsoFootnoteText')
                or starts-with($elementWithId/parent::node()/@class, 'MsoEndnoteText')"/>
        <xsl:choose>
            <xsl:when test="$isFootRef">
                <!-- don't copy footnote content-->
            </xsl:when>
            <xsl:otherwise>
                <xsl:text> </xsl:text>
                <xsl:apply-templates select="node()"/>
                <xsl:text> </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="fn"/>
    <xsl:template match="xref[@type = 'fn']"/>


    <!-- EXM-49066 -->
    <xsl:template match="p[starts-with(@class, 'MsoCommentText')]">
        <!-- Ignore the comments -->
    </xsl:template>
    <xsl:template match="a[starts-with(@class, 'msocomanchor')]">
        <!-- Ignore the comments -->
    </xsl:template>
    <!-- Ignore the text from a list with comments -->
    <xsl:template match="ul">
        <xsl:choose>
            <xsl:when
                test="(count(li) = count(li[a[starts-with(@class, 'msocomoff')]])) and (count(li[a[starts-with(@class, 'msocomoff')]]) > 0)">
                <!-- ignore comments when the ul has only li comments -->
            </xsl:when>
            <xsl:otherwise>
                <xsl:text> </xsl:text>
                <xsl:apply-templates select="node()"/>
                <xsl:text> </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Ignore comments -->
    <xsl:template match="li[a[starts-with(@class, 'msocomoff')]]"/>
    <xsl:template match="img[@alt]">
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="node()"/>
        <xsl:value-of select="@alt"/>
        <xsl:text> </xsl:text>
    </xsl:template>
</xsl:stylesheet>
