<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="2.0"
   xpath-default-namespace="http://www.oxygenxml.com/ns/report">
   <xsl:template match="/">
      <html>
         <head>
            <title> Results </title>
            
            <style type="text/css">
               table{
                   color: #333;
                   font-family: verdana, arial, sans-serif;
                   border-collapse: collapse;
                   border-spacing: 0;
               }
               
               td,
               th{
                   border: 2px solid #CCC;
                   padding: 5px;
                   text-align: left;
                   vertical-align: middle;
               }
               
               th{
                   background-color: #BCBCBC;
                   font-weight: bold;
               }
               
               td{
                   background: #FAFAFA;
               }
            </style>
         </head>

         <xsl:variable name="incidentNodes" select="//incident"/>
         <xsl:variable name="hasEngine" select="$incidentNodes/engine"/>
         <xsl:variable name="hasSeverity" select="$incidentNodes/severity"/>
         <xsl:variable name="hasType" select="$incidentNodes/type"/>
         <xsl:variable name="hasProblemID" select="$incidentNodes/problemID"/>
         <xsl:variable name="hasAdditionalInfo" select="$incidentNodes/additionalInfo"/>
         <xsl:variable name="hasScenario" select="$incidentNodes/operationDescription/scenario"/>
         <xsl:variable name="hasMainFile" select="$incidentNodes/operationDescription/mainValidationFile"/>
         <xsl:variable name="hasSchemas" select="$incidentNodes/operationDescription/schemas"/>
         <xsl:variable name="hasLocation" select="$incidentNodes/location"/>
         <xsl:variable name="hasXPathLocation" select="$incidentNodes/xpath_location"/>

         <body>
            <table>
               <thead>
                  <tr>
                     <th>Description</th>
                     <xsl:if test="$hasSeverity">
                        <th>Severity</th>
                     </xsl:if>
                     <xsl:if test="$hasProblemID">
                        <th>Problem ID</th>
                     </xsl:if>
                     <xsl:if test="$hasEngine">
                        <th>Engine Name</th>
                     </xsl:if>
                     <xsl:if test="$hasType">
                        <th>Type</th>
                     </xsl:if>
                     <th>System ID</th>
                     <xsl:if test="$hasScenario">
                        <th>Scenario Name</th>
                     </xsl:if>
                     <xsl:if test="$hasMainFile">
                        <th>Main Validation File</th>
                     </xsl:if>
                     <xsl:if test="$hasSchemas">
                        <th>Schema</th>
                     </xsl:if>
                     <xsl:if test="$hasXPathLocation">
                        <th>XPath Location</th>
                     </xsl:if>
                     <xsl:if test="$hasLocation">
                        <th>Location</th>
                     </xsl:if>
                     <xsl:if test="$hasAdditionalInfo">
                        <th>Additional Info</th>
                     </xsl:if>
                  </tr>
               </thead>
               <tbody>
                  <xsl:for-each select="$incidentNodes">
                     <tr>
                        <td>
                           <xsl:value-of select="description"/>
                        </td>
                        <xsl:if test="$hasSeverity">
                           <td>
                              <xsl:value-of select="severity"/>
                           </td>
                        </xsl:if>
                        <xsl:if test="$hasProblemID">
                           <td>
                              <xsl:value-of select="problemID"/>
                           </td>
                        </xsl:if>
                        <xsl:if test="$hasEngine">
                           <td>
                              <xsl:value-of select="engine"/>
                           </td>
                        </xsl:if>
                        <xsl:if test="$hasType">
                           <td>
                              <xsl:value-of select="type"/>
                           </td>
                        </xsl:if>
                        <td>
                           <xsl:value-of select="systemID"/>
                        </td>
                        <xsl:if test="$hasScenario">
                           <td>
                              <xsl:value-of select="operationDescription/scenario"/>
                           </td>
                        </xsl:if>
                        <xsl:if test="$hasMainFile">
                           <td>
                              <xsl:value-of select="operationDescription/mainValidationFile"/>
                           </td>
                        </xsl:if>
                        <xsl:if test="$hasSchemas">
                           <td>
                              <xsl:value-of select="operationDescription/schemas"/>
                           </td>
                        </xsl:if>
                        <xsl:if test="$hasXPathLocation">
                           <td>
                              <xsl:value-of select="xpath_location"/>
                           </td>
                        </xsl:if>   
                        <xsl:if test="$hasLocation">
                           <td>
                              <xsl:for-each select="location">
                                 <xsl:if test="start">
                                    <p>Start line <xsl:value-of select="start/line"/>:<xsl:value-of
                                          select="start/column"/>
                                    </p>
                                 </xsl:if>
                                 <xsl:if test="end">
                                    <p>End line <xsl:value-of select="start/line"/>:<xsl:value-of
                                          select="start/column"/>
                                    </p>
                                 </xsl:if>
                                 <xsl:if test="offset">
                                    <p>Offset: <xsl:value-of select="offset"/></p>
                                 </xsl:if>
                                 <xsl:if test="length">
                                    <p>Length: <xsl:value-of select="length"/></p>
                                 </xsl:if>
                              </xsl:for-each>
                           </td>
                        </xsl:if>
                        <xsl:if test="$hasAdditionalInfo">
                           <td>
                              <xsl:value-of select="additionalInfo"/>
                           </td>
                        </xsl:if> 
                     </tr>
                  </xsl:for-each>
               </tbody>
            </table>
         </body>
      </html>
   </xsl:template>
</xsl:stylesheet>
