/**
 * A numeric value that represents positive or negative infinity.
 */
var Infinity;
/**
 * A value that is "Not-a-Number". 
 */
var NaN;
/**
 * Specifies that a variable has not been assigned a value.
 */
var undefined;
/**
 * Decodes a URI.
 *
 * @param uri A complete, encoded Uniform Resource Identifier.
 *
 * @return    The decoded URI.
 */
function decodeURI(uri){};
/**
 * Decodes a URI component.
 *
 * @param uri An encoded component of a Uniform Resource Identifier.
 *
 * @return    The decoded URI component.
 */
function decodeURIComponent(uri){};
/**
 * Encodes a URI.
 *
 * @param uri A complete Uniform Resource Identifier.
 *
 * @return    The encoded URI.
 */
function encodeURI(uri){};
/**
 * Encodes a URI component.
 *
 * @param uri A component of a URI.
 *
 * @return    The encoded URI component.
 */
function encodeURIComponent(uri){};
/**
 * Encodes a string.
 *
 * @param string The string to be encoded.
 *
 * @return       The encoded string.
 */
function escape(string){};
/**
 * Evaluates the given string parameter and executes it as if it was script code.
 *
 * @param string  A string representing a JavaScript expression, statement, or sequence of statements. 
 *                The expression can include variables and properties of existing objects.
 */
function eval(string){};
/**
 * Determines whether a value is a finite, legal number.
 *
 * @param value The value to evaluate.
 *
 * @return      true if the given value is evaluated as a finite number, false otherwise.
 */
function isFinite(value){};
/**
 * Determines whether a value is an illegal number.
 *
 * @param value The value to be tested.
 *
 * @return      true if the given value is evaluated as being a NaN, false otherwise. 
 */
function isNaN(value){};
/**
 * Converts an object's value to a number.
 */
function Number(object){};
/**
 * Parses the given string parameter and returns a floating point number.
 *
 * @param string A string that represents the value you want to parse.
 *
 * @return       The floating point number corresponding to the given string parameter. 
 */
function parseFloat(string){};
/**
 * Parses the given string parameter and returns an integer.
 *
 * @param string The value to parse. If this value is not a string, then it is converted to one. 
 *               Leading whitespace in the string is ignored.
 *
 * @return       The integer number corresponding to the given string parameter. 
 */
function parseInt(string){};
/**
 * Converts an object's value to a string.
 */
function String(object){};
/**
 * Decodes an encoded string.
 */
function unescape(string){};


/**
 * Object prototype.
 */
Object.prototype = {
	/**
	 * Creates an object with the specified prototype and properties.
	 * 
	 * @param prototype   (Required) The prototype of the object. 
	 * @param descriptors (Optional) An object that contains one or more descriptor objects.
	 *
	 * @return            The newly created object. 
	 */
	create:function(prototype, descriptors) {},
	
    /**
	 * Determines if extending of an object is allowed.
	 *
	 * @param object The object which should be checked.
	 *
	 * @return       true or false depending upon the given object parameter is extensible or not.
	 */
	isExtensible:function(object) {},

	/**
	 * Prevents any extensions of an object.
	 * 
	 * @param object (Required) The object to make non-extensible. 
	 */
	preventExtensions:function(object) {},
	
	/**
	 * Builds a property descriptor for a named property on an object.
	 * 
	 * @param object       (Required) The object that contains the property. 
	 * @param propertyname (Required) A string containing the name of the property.
	 *
	 * @return             A property descriptor for an own property (that is, one directly present on an object, 
	 *                     not present by dint of being along an object's prototype chain) of a given object.
	 */
	getOwnPropertyDescriptor:function(obj,prop) {},
	
	/**
	 * Adds the named property described by a given descriptor to an object.
	 * 
	 * @param obj   (Required) The object on which to add or modify the property.  
	 * @param prop  (Required) A string with the property name to be defined or modified. 
	 * @param descr (Required) A JavaScript object that is a descriptor for 
	 *              the property being defined or modified. 
	 * 
	 */
	defineProperty:function(obj,prop,descr) {},
	
	/**
	 * Defines new or modifies existing properties directly on an object, returning the object.
	 * 
	 * @param obj   (Required) The object on which to add or modify the properties.
	 * @param props (Required) An object whose own enumerable properties constitute descriptors for 
	 *              the properties to be defined or modified.
	 *
	 * @return      The object affected.
	 */
	defineProperties:function(obj,props) {},
	
	/**
	 * Builds an array of all own enumerable properties found upon a given object.
	 *
	 * @param obj (Required) The object that contains the properties and methods.
	 *
	 * @return    An array containing the names of all of the given object's own enumerable props.
	 */
	keys:function(obj) {},
	
	/**
	 * Returns an array containing the names of all of the given object's own enumerable and 
	 * non-enumerable properties.
	 * 
	 * @param object (Required) The object whose enumerable and non-enumerable own properties are to be returned.
	 *
	 * @return       An array of all properties (enumerable or not) found upon a given object.
	 */
	getOwnPropertyNames:function(obj) {},
	
	/**
	 * Determines the prototype of the specified object.
	 * 
	 * @param obj  (Required) The object that references the prototype.
	 
	 * @return Returns the prototype of an object.
	 */
	getPrototypeOf:function(obj) {},
	
	/**
	 * Seals an object, preventing new properties from being added to it and marking all 
	 * existing properties as non-configurable. Values of present properties can still be changed 
	 * as long as they are writable.
	 
	 * @param obj (Required) The object which should be sealed. 
	 */
	seal:function(obj) {},
	
	/**
	 * Determines if an object is sealed. 
	 * 
	 * @param obj (Required) The object which should be checked. 
	 *
	 * @return    true if the object is sealed, otherwise false. 
	 */
	isSealed:function(obj) {},
	/**
	 * Freezes an object: other code can't delete or change any properties.
	 * 
	 * @param obj (Required) The object on which to freeze the attributes.
	 *
	 * @return    The object being frozen.
	 */
	freeze:function(obj) {},
	
	/**
	 * Determines if an object is frozen.
	 * 
	 * @param obj (Required) The object to test.
	 *
	 * @return    true if the given object parameter is frozen, false otherwise.
	 */
	isFrozen:function(obj) {},
	
    prototype:0   
}


  /**
   * Contains methods for converting values to JSON notation and for converting JSON notation to values.
   */
  JSON.prototype = {
    /**
     * Parses a string as JSON, optionally transforming the produced value and its properties.
     *
     * @param text     The string to parse as JSON.
     * @param reviver  If a function, prescribes how the value originally produced by parsing 
     *                 is transformed, before being returned.
     *
     * @return         The value obtained as a result of parsing the given string.
     */
    parse:function(text, reviver){},
    /**
     * Builds a JSON string corresponding to the specified value, optionally including only 
     * certain properties or replacing property values in a user-defined manner.
     *
     * @param value    The value to convert to a JSON string.
     * @param replacer If a function, transforms values and properties encountered while stringifying; 
     *                 if an array, specifies the set of properties included in objects in the final string.
     * @param space    Causes the resulting string to be pretty-printed.
     *
     * @return         The JSON string representation of the given value.
     */
    stringify:function(value, replacer, space){}
  }
    
  /**
   * An object wrapper for primitive numeric values.
   */
  Number.prototype = {   
    /**
	 * Returns the function that created the Number object's prototype.
	 */
    constructor:0,
    /**
     * The largest positive representable number in JavaScript.
     */
    MAX_VALUE:0,
    /**
     * The smallest positive representable number in JavaScript.
     */
    MIN_VALUE:0,
    /**
     * A special value for "Not-a-Number". 
     */
    NaN:0,
    /**
     * Special value representing negative infinity (returned on overflow).
     */
    NEGATIVE_INFINITY:0,
    /**
     * Special value representing infinity (returned on overflow).
     */
    POSITIVE_INFINITY:0,
    /**
     * Allows adding properties and methods to a Number object.
     */
    protoype:0,
    /**
	 * Builds a string representing the number in exponential notation.
	 *
	 * @param x An integer specifying the number of digits after the decimal point. 
	 *          Defaults to as many digits as necessary to specify the number. 
	 *
	 * @return  A string representing the number in exponential notation.
	 */
    toExponential:function(x){},
    /**
	 * Builds a string representing the number in fixed-point notation.
	 *
	 * @param x The number of digits to appear after the decimal point; this may be a value between 
	 *          0 and 20, inclusive, and implementations may optionally support a larger range of values. 
	 *          If this argument is omitted, it is treated as 0.
	 *
	 * @return  A string representing the given number that does not use exponential notation and 
	 *          has exactly x digits after the decimal place.
	 */
    toFixed:function(x){},
    /**
	 * Builds a human readable string representing the given number using the locale of the environment. 
	 * Overrides the Object.prototype.toLocaleString method.
     *
     * @return A human readable string representing the given number using the locale. 
	 */
    toLocaleString:function(){},
    /**
	 * Builds a string representing the number to a specified precision in fixed-point or exponential notation.
	 *
	 * @param x An integer specifying the number of significant digits.
	 *
	 * @return  A string representing the Number object to the specified precision. 
	 */
    toPrecision:function(x){},
    /** 
     * Builds an object literal representing the specified Number object; you can use this value 
     * to create a new object. Overrides the Object.prototype.toSource method.
     *
     * @return An object literal representing the specified Number object.
     */
    toSource:function(){},
    /** 
     * Builds a string representing the specified object. Overrides the Object.prototype.toString method. 
     *
     * @return A string representing the specified object.
     */
    toString:function(){},
    /** 
     * Determines the primitive value of the specified object. Overrides the Object.prototype.valueOf method.
     *
     * @return The primitive value of the specified object.
     */
    valueOf:function(){}
  }
 
 
  /**
   * Used to convert non-Boolean values to Boolean values (true or false).
   */
  Boolean.prototype = {
    /**
     * The initial value of the Boolean object.
     */
    value:0,  
    /**
     * Returns the function that created the Boolean object's prototype.
     */
    constructor:0,
    /**
     *  Allows adding properties and methods to a Boolean object.
     */
    prototype:0,
    /**
	 * Builds a string representing the source code. Overrides the Object.prototype.toSource method.
	 *
	 * @return A string containing the source of the Boolean object.
	 */
    toSource:function(){},
    /**
     * Builds a string of either "true" or "false" depending upon the value of the object. 
     * Overrides the Object.prototype.toString method.
     *
	 * @return A string of either "true" or "false", depending upon the value of the object.
	 */
    toString:function(){},
    /** 
     * Returns the primitive value of the Boolean object. Overrides the Object.prototype.valueOf method.
     *
     * @return A string of either "true" or "false" depending upon the value of the object.
     */
    valueOf:function(){}
    }
 
 
  /**
   * Used to handle with stored pieces of text.
   */
  String.prototype = {
    /**
     * Anything to be converted to a string.
     */
    thing:0,  
    /**
     * Returns the function that created the String object's prototype.
     */
    constructor:0,
    /**
     * Reflects the length of the string.
     */
    length:0,
    /**
     * Allows the addition of properties to a String object.
     */
    prototype:0,
    /** 
     * Determines the character at the specified index.
     *
     * @param index An integer between 0 and 1 less than the length of the string.
     *
     * @return The character at the specified index.
     */
    charAt:function(index){},
    /**
     * Determines the number indicating the Unicode value of the character at the given index.
     *
     * @param index An integer greater than 0 and less than the length of the string; 
     *              if it is not a number, it defaults to 0.
     *
	 * @return A number indicating the Unicode value of the character at the given index.
	 */
    charCodeAt:function(index){},
    /** 
     * Combines the text of two (or more) strings and returns the new string.
     *
     * @param string1   String to concatenate to this string. 
     * @param string2   String to concatenate to this string.
     *
     * @return The new string obtained by combining the given string arguments with this string.
     */
    concat:function(string1, string2){},
    /**
     * Converts one or more Unicode values to characters.
     *
     * @param uv1    Unicode value to be converted.
     *
     * @return       The character corresponding to the given Unicode value(s).
     */
    fromCharCode:function(uv1){},
    /**
     * Determines the index within the calling String object of the first occurence of
     * the specified value, or -1 if not found.
     *
     * @param substring    A string representing the value to search for.
	 * 
	 * @return             The index of the first occurence of the specified value.
	 */
    indexOf:function(substring){},
    /**
	 * Determines the index within the calling String object of the last occurrence of
	 * the specified value, or -1 if not found.
	 *
	 * @param substring    A string representing the value to search for.
	 *
	 * @return             The index of the last occurence of the specified value.
	 */
    lastIndexOf:function(substring){},
    /**
	 * Determines whether a reference string comes before or after or is the same as 
	 * the given string in sort order.
	 *
	 * @param compareString The string against which the referring string is comparing.
	 *
	 * @return A number indicating whether a reference string comes before or after or 
	 *         is the same as the given string in sort order.
	 */
    localeCompare:function(compareString){},
    /** 
     * Used to match a regular expression against a string.
     *
     * @param  regexp    The regular expression.
     *
     * @return           An Array containing all matches.
     */
    match:function(regexp){},
    /** 
     * A non-standard method for wrapping a string in double quotes.
     *
     * @return The quoted string.
     */
    quote:function(){},    
    /**
	 * Used to find a match between a regular expression and a string,
	 * and to replace the matched substring with a new substring. 
	 * Returns an array of matches, or null if no match found.
	 *
	 * @param matchSubstr  A String that is to be replaced by newSubstr. It can be a regular expression too.
	 * @param newSubstr    The String that replaces the substring received from parameter matchSubstr. 
	 *                     A number of special replacement patterns are also supported.
	 *
	 * @return             A new string with some or all matches of a pattern (matchSubstr) 
	 *                     replaced by a replacement (newSubstr).
	 */
    replace:function(matchSubstr, newSubstr){},
    /**
	 * Executes the search for a match between a regular expression and a string, 
	 * returning the position of the match, or -1 if no match found.
	 *
	 * @param regexp    A regular expression object. 
	 *
	 * @return          A boolean value depending whether the searching was successful or not.
	 */
    search:function(regexp){},
    /** 
     * Extracts a section of a string and returns a new string.
     *
     * @param begin The zero-based index at which to begin extraction.
     * @param end   The zero-based index at which to end extraction. 
     *              If omitted, slice extracts to the end of the string.
     * 
     * @return The new string resulted after extraction.
     */
    slice:function(begin, end){},
    /**
	 * Splits a String object into an array of strings; it uses a separator to split the string into substrings.
	 *
	 * @param separator Specifies the character to use for separating the string. 
	 *                  The separator is treated as a string or a regular expression. 
	 *                  If separator is omitted, the array returned contains one element consisting 
	 *                  of the entire string.
	 * @param limit     Integer specifying a limit on the number of splits to be found. 
	 *                  The split method still splits on every match of separator, but it truncates 
	 *                  the returned array to at most limit elements.         
	 *
	 * @return          The array consisting of all substrings obtained after the split operation.
	 */
    split:function(separator, limit){},
    /**
	 * Determines the characters in a string beginning at the specified location through 
	 * the specified number of characters.
	 *
	 * @param start  Location at which to begin extracting characters.
	 * @param length The number of characters to extract. 
	 *
	 * @return       The characters in the string beginning at the specified location through 
	 *               the specified number of characters.
	 */
    substr:function(start, length){},
    /**
	 * Determines the characters in a string between two indexes into the string.
	 * 
	 * @param from An integer between 0 and one less than the length of the string.
	 * @param to   An integer between 0 and the length of the string (optional).
	 *
	 * @return     Returns a subset of a string between one index and another, or through the end of the string. 
	 */
    substring:function(from, to){},
    /**
	 * The characters within a string are converted to lower case while respecting the current locale.
	 *
	 * @return The calling string value converted to lower case, according to any locale-specific case mappings.
	 */
    toLocaleLowerCase:function(){},
    /**
	 * The characters within a string are converted to upper case while respecting the current locale.
	 *
	 * @return The calling string value converted to upper case, according to any locale-specific case mappings.
	 */
    toLocaleUpperCase:function(){},
    /** 
     * Determines the calling string value converted to lower case.
     *
     * @return The calling string value converted to lowercase.
     */
    toLowerCase:function(){},
    /** 
     * Determines a string representing the source code of the object (non-standard).
     *
     * @return A string representing the source code of the object. 
     */
    toSource:function(){},    
    /** 
     * Determines a string representing the specified object.
     *
     * @return A string representing the specified object.
     */
    toString:function(){},
    /** 
     * Returns the calling string value converted to uppercase.
     *
     * @return The calling string value converted to uppercase.
     */
    toUpperCase:function(){},
    /** 
     * Trims whitespace from the beginning and end of the string.
     *
     * @return The string stripped of whitespace from both ends.
     */
    trim:function(){},
    /** 
     * Trims whitespace from the left side of the string.
     *
     * @return The string stripped of whitespace from its left end.
     */
    trimLeft:function(){},
    /** 
     * Trims whitespace from the right side of the string.
     *
     * @return The calling string value converted to uppercase.
     */
    trimRight:function(){},
    /** 
     * Determines the primitive value of a String object.
     *
     * @return The string stripped of whitespace from its right end.
     */
    valueOf:function(){},
    /** 
     * Creates an HTML anchor that is used as a hypertext target.
     *
     * @param  A string.
     *
     * @return The anchor created. 
     */
    anchor:function(nameAttribute){},
    /**
	 * Creates a string to be displayed in a big font as if it were in a &lt;big&gt; tag.
	 *
	 * @return The new formatted string.
	 */
    big:function(){},
    /** 
     * Creates a string to blink as if it were in a &lt;blink&gt; tag.
     *
     * @return The new formatted string.
     */
    blink:function(){},
    /**
  	 * Creates a string to be displayed as bold as if it were in a &lt;b&gt; tag.
  	 *
  	 * @return The new formatted string.
     */
    bold:function(){},
    /**
	 * Causes a string to be displayed in fixed-pitch font as if it were in a &lt;tt&gt; tag.
	 *
	 * @return The new formatted string.
	 */
    fixed:function(){},
    /**
	 * Causes a string to be displayed in the specified color as if it were 
	 * in a &lt;font color="color"&gt; tag.
	 *
	 * @param  A string expressing the color as a hexadecimal RGB triplet or as a string literal.
	 *
	 * @return The new formatted string.
	 */
    fontcolor:function(color){},
    /**
	 * Causes a string to be displayed in the specified font size as if it were
	 * in a &lt;font size="size"&gt; tag.
	 *
	 * @param  An integer between 1 and 7, a string representing a signed integer between 1 and 7.
	 *
	 * @return The new formatted string.
	 */
    fontsize:function(){},
    /** 
     * Causes a string to be italic, as if it were in an &lt;i&gt; tag.
     *
     * @return The new formatted string.
     */
    italics:function(){},
    /** 
     * Creates an HTML hypertext link that requests another URL.
     *
     * @return The HTML snippet for a hypertext link.
     */
    link:function(){},
    /**
	 * Causes a string to be displayed in a small font, as if it were in a &lt;small&gt; tag.
	 *
	 * @return The new formatted string.
	 */
    small:function(){},
    /**
	 * Causes a string to be displayed as struck-out text, as if it were in a &lt;strike&gt; tag.
	 *
	 * @return The new formatted string.
	 */
    strike:function(){},
    /**
	 * Causes a string to be displayed as a subscript, as if it were in a &lt;sub&gt; tag.
	 *
	 * @return The new formatted string.
	 */
    sub:function(){},
    /**
	 * Causes a string to be displayed as a superscript, as if it were in a &lt;sup&gt; tag.
	 *
	 * @return The new formatted string.
	 */
    sup:function(){}
    }

  /**
   * Used to store multiple values in a single variable.
   */
  Array.prototype = {
    /**
     * Returns the function that created the Array object's prototype.
     */
    constructor:0,
    /**
     * The number of elements in an array.
     */
    length:0,
    /**
     * Allows adding properties and methods to an object.
     */
    prototype:0,
    /**
	 * Builds a new array comprised of this array joined with other array(s) and/or value(s).
	 *
	 * @param array1 Array and/or value to concatenate to the resulting array.
	 * @param array2 Array and/or value to concatenate to the resulting array.
	 *
	 * @return The new array comprised of this array joined with other array(s) and/or value(s).
	 */
    concat:function(array1, array2){},
    /**
	 * Tests whether all elements in the array pass the test implemented by the provided function.
	 *
	 * @param func Function to test for each element. 
	 *
	 * @return     true if every element in this array satisfies the provided testing function.
	 */
    every:function(func){},
    /** 
     * Calls a function for each element in the array and builds an array with all elements that pass the test.
     *
     * @param func Function to test for each element.
     *
     * @return     The new array with all elements that pass the test implemented by the provided function.  
     */
    filter:function(func){},
    /** 
     * Executes a provided function once per array element.
     *
     * @param func Function to execute for each element.
     */
    forEach:function(func){},
    /**
  	 * Determines the first (least) index of an element within the array equal to 
  	 * the specified value, or -1 if none is found.
  	 *
  	 * @param val       Element to locate in the array.
  	 * @param fromIndex The index at which to begin the search. Defaults to 0, i.e. the whole array will be searched.
  	 *
  	 * @return          Returns the first index at which a given element can be found in the array, 
  	 *                  or -1 if it is not present.
  	 */
    indexOf:function(val, fromIndex){},
    /** 
     * Joins all elements of an array into a string; elements will be separated by a specified separator.
     *
     * @param separator Specifies a string to separate each element of the array. 
     *                  If omitted, the array elements are separated with a comma.
     *
     * @return          The string obtained by joining all array elements.
     */
    join:function(separator){},
    /**
	 * Determines the last (greatest) index of an element within the array equal to
	 * the specified value, or -1 if none is found.
	 *
  	 * @param val       Element to locate in the array.
  	 * @param fromIndex The index at which to start searching backwards. Defaults to the array's length, 
  	 *                  i.e. the whole array will be searched. 
  	 *
  	 * @return          Returns the last index at which a given element can be found in the array,  
  	 *                  or -1 if it is not present.	 
	 */
    lastIndexOf:function(val, fromIndex){},
    /**
	 * Creates a new array with the results of calling a provided function on every element in this array.
	 *
	 * @param func Function that produces an element of the new Array from an element of the current one.
	 *
	 * @return     A new array with the results of calling the provided function on every element in this array.
	 */
    map:function(func){},
    /** 
     * Removes the last element from an array and returns that element.
     *
     * @return The element/value removed.
     */
    pop:function(){},
    /**
	 * Adds one or more elements to the end of an array and returns the new length of the array.
	 *
	 * @param elem The element(s0 to add to the end of the array.
	 *
	 * @return     The new length property of the object upon which the method was called.
     */
    push:function(elem){},
    /**
	 * Applies a function against an accumulator and each value of the array (from left-to-right) 
	 * as to reduce it to a single value.
	 *
	 * @param func The function to execute on each value in the array.
	 */
    reduce:function(func){},   
    /**
	 * Applies a function simultaneously against two values of the array (from right-to-left)
	 * as to reduce it to a single value.
	 *
	 * @param func The function to execute on each value in the array.
	 */
    reduceRight:function(func){},
    /**
	 * Reverses the order of the elements of an array so the first becomes the last, 
	 * and the last becomes the first.
	 *
	 * @return A reference to the new array.
	 */
    reverse:function(){},
    /** 
     * Removes the first element from an array.
     *
     * @return The element removed.
     */
    shift:function(){},
    /** 
     * Extracts a section of an array.
     *
     * @param start  Zero-based index at which to begin extraction.
     * @param end    Zero-based index at which to end extraction. slice extracts up to but not including end.
     *
     * @return       An one-level deep copy of a portion of an array (not altering the original one).
     */
    slice:function(start, end){},
    /**
	 * Tests whether some element in the array passes the test implemented by the provided function.
	 *
	 * @param func Function to test for each element.
	 *
	 * @return     true, if some element in the array passes the test, false otherwise.
	 */
    some:function(func){},
    /** 
     * Represents the source code of an object (non-standard).
     *
     * @return A string representing the source code of the array.
     */
    toSource:function(){},
    /** 
     * Sorts the elements of an array.
     *
     * @param sortmode Specifies a function that defines the sort order.
     *
     * @return         The sorted array.
     */
    sort:function(sortmode){},
    /** 
     * Changes the content of an array, adding new elements while removing old ones.
     *
     * @param index   Index at which to start changing the array. If negative, will begin that many elements from the end. 
     * @param howmany An integer indicating the number of old array elements to remove. If howMany is 0, no elements are removed.
     * @param elem    The elements to add to the array. If you don't specify any elements, splice simply removes elements from the array.
     *
     * @return        An array containing the removed elements. If only one element is removed, an array of one element is returned.
     */
    splice:function(index, howmany, elem){},
    /** 
     * Builds a string representing the array and its elements.
     *
     * @return A string representing the specified array and its elements.
     */
    toString:function(){},
    /**
  	 * Adds one or more elements to the front of an array and returns the new length of the array.
  	 *
  	 * @return The new length property of the object upon which the method was called.
	 */
    unshift:function(elem){}
    }

  /**
   * Used to work with dates and times.
   */
  Date.prototype = {
    /**
     * Returns the function that created the Date object's prototype.
     */
    constructor:0,
    /**
     * Allows adding properties and methods to an object.
     */
    prototype:0,
    /**
     * Integer value representing the number of milliseconds since 1 January 1970 00:00:00 UTC (Unix Epoch).
     */
    milliseconds:0,
    /**
     * String value representing a date.
     */
    dateString:0,
    /**
     * Integer value representing the year.
     */
    year:0,
    /**
     * Integer value representing the month, beginning with 0 for January to 11 for December.
     */
    month:0,
    /**
     * Integer value representing the day of the month (1-31).
     */
    day:0,
    /**
     * Integer value representing the hour of the day (0-23).
     */
    hour:0,
    /**
     * Integer value representing the minute segment (0-59) of a time reading.
     */
    minute:0,
    /**
     * Integer value representing the second segment (0-59) of a time reading.
     */
    second:0,
    /**
     * Integer value representing the millisecond segment (0-999) of a time reading.
     */
    millisecond:0,
    /** 
     * Returns today's date and time.
     */
    Date:function(){},
    /**
	 * Determines the number of milliseconds elapsed since 1 January 1970 00:00:00 UTC.
	 *
	 * @return The number of milliseconds elapsed since 1 January 1970 00:00:00 UTC.
	 */
    now:function(){},
    /**
	 * Determines the day of the month for the specified date according to local time.
	 *
	 * @return Returns the day of the month (1-31) for the specified date according to local time.
	 */
    getDate:function(){},
    /**
	 * Determines the day of the week for the specified date according to local time.
	 *
	 * @return The day of the week (0-6) for the specified date according to local time.
	 */
    getDay:function(){},
    /** 
     * Determines the year of the specified date according to local time.
     *
     * @return The year (4 digits for 4-digit years) of the specified date according to local time.
     */
    getFullYear:function(){},
    /** 
     * Determines the hour in the specified date according to local time.
     *
     * @return The hour (0-23) in the specified date according to local time.
     */
    getHours:function(){},
    /**
	 * Determines the milliseconds in the specified date according to local time.
	 *
	 * @return The milliseconds (0-999) in the specified date according to local time.
	 */
    getMilliseconds:function(){},
    /** 
     * Determines the minutes in the specified date according to local time.
     *
     * @return The minutes (0-59) in the specified date according to local time.
     */
    getMinutes:function(){},
    /** 
     * Determines the month in the specified date according to local time.
     *
     * @return The month (0-11) in the specified date according to local time.
     */
    getMonth:function(){},
    /** 
     * Determines the seconds in the specified date according to local time.
     *
     * @return The seconds (0-59) in the specified date according to local time.
     */
    getSeconds:function(){},
    /**
	 * Determines the numeric value of the specified date as the number of milliseconds,
	 * since January 1, 1970, 00:00:00 UTC.
	 *
	 * @return The numeric value of the specified date as the number of milliseconds since 
	 *         January 1, 1970, 00:00:00 UTC (negative for prior times).
	 */
    getTime: function(){},
    /** 
     * Determines the time-zone offset in minutes for the current locale.
     *
     * @return The time-zone offset in minutes for the current locale.
     */
    getTimezoneOffset:function(){},
    /**
  	 * Determines the day (date) of the month in the specified date according to universal time.
  	 *
  	 * @return The day (date) of the month (1-31) in the specified date according to universal time.
	 */
    getUTCDate:function(){},
    /**
  	 * Determines the day of the week in the specified date according to universal time.
  	 *
  	 * @return The day of the week (0-6) in the specified date according to universal time.
	 */
    getUTCDay:function(){},
    /** 
     * Determines the year in the specified date according to universal time.
     *
     * @return The year (4 digits for 4-digit years) in the specified date according to universal time.
     */
    getUTCFullYear:function(){},
    /** 
     * Determines the hours in the specified date according to universal time.
     *
     * @return The hours (0-23) in the specified date according to universal time.
     */
    getUTCHours:function(){},
    /**
  	 * Determines the milliseconds in the specified date according to universal time.
  	 *
  	 * @return The milliseconds (0-999) in the specified date according to universal time.
	 */
    getUTCMilliseconds:function(){},
    /**
  	 * Determines the minutes in the specified date according to universal time.
  	 *
  	 * @return The minutes (0-59) in the specified date according to universal time.
	 */
    getUTCMinutes:function(){},
    /** 
     * Determines the month in the specified date according to universal time.
     *
     * @return The month (0-11) in the specified date according to universal time.
     */
    getUTCMonth:function(){},
    /**
	 * Determines the seconds in the specified date according to universal time.
	 *
	 * @return The seconds (0-59) in the specified date according to universal time.
	 */
    getUTCSeconds:function(){},
    /**
	 * Deprecated - Determines the year in the specified date according to local time. 
	 * Use getFullYear instead.
	 *
	 * @return The year (usually 2-3 digits) in the specified date according to local time.
	 */
    getYear:function(){},
    /**
     * Parses a string representation of a date and time and determines
     * the internal millisecond representation of that date.
     *
     * @param dateString     A string representing a date.
     *
     * @return               The number of milliseconds since January 1, 1970, 00:00:00 UTC.
     */
    parse:function(dateString){},
    /**
  	 * Sets the day of the month for a specified date according to local time.
  	 *
  	 * @param An integer from 1 to 31, representing the day of the month.
	 */
    setDate:function(day){},
    /** 
     * Sets the full year for a specified date according to local time.
     *
     * @param year  An integer specifying the numeric value of the year.
     * @param month An integer between 0 and 11 representing the months January through December (optional). 
     * @param day   An integer between 1 and 31 representing the day of the month (optional). 
     *              If you specify the day parameter, you must also specify the month value. 
     */
    setFullYear:function(year, month, day){},
    /** 
     * Sets the hours for a specified date according to local time.
     *
     * @param hour An integer between 0 and 23, representing the hour. 
     * @param min  An integer between 0 and 59, representing the minutes (optional).  
     * @param sec  An integer between 0 and 59, representing the seconds (optional).
     *             If you specify the secondsValue parameter, you must also specify the min value. 
     * @param msec A number between 0 and 999, representing the milliseconds (optional).
     *             If you specify the msec parameter, you must also specify the min and sec values. 
     */
    setHours:function(hour, min, sec, msec){},
    /** 
     * Sets the milliseconds for a specified date according to local time.
     *
     * @param millisec A number between 0 and 999, representing the milliseconds.
     */
    setMilliseconds:function(millisec){},
    /** 
     * Sets the minutes for a specified date according to local time.
     *
     * @param min  An integer between 0 and 59, representing the minutes.
     * @param sec  An integer between 0 and 59, representing the seconds (optional). 
     *             If you specify the sec parameter, you must also specify the min value.
     * @param msec A number between 0 and 999, representing the milliseconds. 
     *             If you specify the msec parameter, you must also specify the min and sec values. 
     */
    setMinutes:function(min, sec, msec){},
    /** 
     * Sets the month for a specified date according to local time.
     *
     * @param month An integer between 0 and 11 (representing the months January through December).
     * @param day   An integer from 1 to 31, representing the day of the month (optional). 
     */
    setMonth:function(month, day){},
    /** 
     * Sets the seconds for a specified date according to local time.
     *
     * @param sec  An integer between 0 and 59.
     * @param msec A number between 0 and 999, representing the milliseconds.     
     */
    setSeconds:function(sec, msec){},
    /**
	 * Sets the Date object to the time represented by a number of milliseconds,
	 * since January 1, 1970, 00:00:00 UTC.
	 *
	 * @param millisec An integer representing the number of milliseconds since 1 January 1970, 00:00:00 UTC.
	 */
    setTime:function(millisec){},
    /**
  	 * Sets the day of the month for a specified date according to universal time.
  	 *
  	 * @param day An integer from 1 to 31, representing the day of the month. 
	 */
    setUTCDate:function(day){},
    /** 
     * Sets the full year for a specified date according to universal time.
     *
     * @param year  An integer specifying the numeric value of the year.
     * @param month An integer between 0 and 11 representing the months January through December (optional).
     * @param day   An integer between 1 and 31 representing the day of the month (optional). 
     *              If you specify the day parameter, you must also specify the month value.    
     */
    setUTCFullYear:function(year, month, day){},
    /** 
     * Sets the hour for a specified date according to universal time.
     *
     * @param hour An integer between 0 and 23, representing the hour.
     * @param min  An integer between 0 and 59, representing the minutes (optional).
     * @param sec  An integer between 0 and 59, representing the seconds (optional). 
     *             If you specify the sec parameter, you must also specify the min value. 
     * @param msec A number between 0 and 999, representing the milliseconds (optional). 
     *             If you specify the msec parameter, you must also specify the min and sec values.    
     */
    setUTCHours:function(hour, min, sec, msec){},
    /**
	 * Sets the milliseconds for a specified date according to universal time.
	 *
	 * @param millis A number between 0 and 999, representing the milliseconds.
	 */
    setUTCMilliseconds:function(millisec){},
    /** 
     * Sets the minutes for a specified date according to universal time.
     *
     * @param min  An integer between 0 and 59, representing the minutes.
     * @param sec  An integer between 0 and 59, representing the seconds (optional). 
     *             If you specify the sec parameter, you must also specify the min value.  
     * @param msec A number between 0 and 999, representing the milliseconds (optional). 
     *             If you specify the msec parameter, you must also specify the min and sec values.     
     */
    setUTCMinutes:function(min, sec, msec){},
    /** 
     * Sets the month for a specified date according to universal time.
     *
     * @param month  An integer between 0 and 11, representing the months January through December. 
     * @param day    An integer from 1 to 31, representing the day of the month (optional).     
     */
    setUTCMonth:function(month, day){},
    /** 
     * Sets the seconds for a specified date according to universal time.
     *
     * @param sec   An integer between 0 and 59. 
     * @param msec  A number between 0 and 999, representing the milliseconds (optional).     
     */
    setUTCSeconds:function(sec, msec){},
    /**
	 * Deprecated - Sets the year for a specified date according to local time. Use setFullYear instead.
	 *
	 * @param year An integer representing the year to set.
     */
    setYear:function(year){},
    /** 
     * Determines the "date" portion of the Date as a human-readable string.
     *
     * @return The "date" portion of the Date as a human-readable string.
     */
    toDateString:function(){},
    /**
  	 * Provides a direct way to convert a date object into a string in ISO format.
  	 *
  	 * @return An ISO formatting string representing the Date object's value.
	 */
    toISOString:function(){},
    /**
  	 * Determines a JSON representation of the Date object.
  	 *
  	 * @return A JSON formatting string representing the Date object's value.
	 */
    toJSONString:function(){},
    /**
  	 * Deprecated - Converts a date to a string, using the Internet GMT conventions. Use toUTCString instead.
  	 *
  	 * @return A human readable date string.
	 */
    toGMTString:function(){},
    /**
	 * Determines the "date" portion of the Date as a string, using the current locale's conventions.
	 *
	 * @return The "date" portion of the Date as a string, using the current locale's conventions.
	 */
    toLocaleDateString:function(){},
    /** 
     * Converts a date to a string, using a format string.
     *
     * @param A format string for the date.
     *
     * @return A string date formatted as specified.
     */
    toLocaleFormat:function(formatString){},
    /** 
     * Converts a date to a string, using the current locale's conventions.
     *
     * @return A date string using the formatting convention of the operating system where the script is running.
     */
    toLocaleString:function(){},
    /**
	 * Converts a date to a string, returning the "date" portion using the operating system's locale's conventions. 
	 *
	 * @return The "time" portion of the Date as a string, using the current locale's conventions.
	 */
    toLocaleTimeString:function(){},
    /**
	 * Builds a string representing the source for an equivalent Date object; 
	 * you can use this value to create a new object (non-standard method).
	 *
	 * @return A string representing the source for an equivalent Date object.
	 */
    toSource:function(){},
    /** 
     * Builds a string representing the specified Date object.
     *
     * @return A string representing the specified Date object.
     */
    toString:function(){},
    /** 
     * Determines the "time" portion of the Date as a human-readable string.
     *
     * @return The time portion of a Date object in human readable form.
     */
    toTimeString:function(){},
    /** 
     * Converts a date to a string, using the universal time convention.
     *
     * @return A human-readable string for the Date object, using the universal time convention.
     */
    toUTCString:function(){},
    /**
     * Determines the number of milliseconds in a date string since midnight of January 1, 1970, 
     * according to universal time.
     *
     * @param year  A year after 1900. 
     * @param month An integer between 0 and 11 representing the month. 
     * @param day   An integer between 1 and 31 representing the day of the month. 
     * @param hours An integer between 0 and 23 representing the hours.
     * @param min   An integer between 0 and 59 representing the minutes.
     * @param sec   An integer between 0 and 59 representing the seconds.
     * @param ms    An integer between 0 and 999 representing the milliseconds. 
     *
     * @return      The number of milliseconds in a Date object since January 1, 1970, 00:00:00, universal time.
     */
    UTC:function(year, month, day, hours, min, sec, ms){},
    /** 
     * Determines the primitive value of a Date object.
     *
     * @return The primitive value of a Date object.
     */
    valueOf:function(){}
    }
 
 
  /**
   * Allows performing mathematical tasks. 
   */
  Math.prototype = {
    /**
     * Euler's number (approx. 2.718).
     */
    E:0,
    /**
     * The natural logarithm of 2 (approx. 0.693).
     */
    LN2:0,
    /**
     * The natural logarithm of 10 (approx. 2.302).
     */
    LN10:0,
    /**
     * The base-2 logarithm of E (approx. 1.442).
     */
    LOG2E:0,
    /**
     * The base-10 logarithm of E (approx. 0.434).
     */
    LOG10E:0,
    /**
     * PI (approx. 3.14159).
     */
    PI:0,
    /**
     * The square root of 1/2 (approx. 0.707).
     */
    SQRT1_2:0,
    /**
     * The square root of 2 (approx. 1.414).
     */
    SQRT2:0,
    /** 
     * The absolute value of a number.
     *
     * @param x A number.
     *
     * @return  The absolute value of a number.  
     */
    abs:function(x){},
    /** 
     * Determines the arccosine (in radians) of a number.
     *
     * @param x A number.
     *
     * @return  The arccosine (in radians) of a number.      
     */
    acos:function(x){},
    /** 
     * Determines the arcsine (in radians) of a number.
     *
     * @param x A number.
     *
     * @return  The arcsine (in radians) of a number.     
     */
    asin:function(x){},
    /** 
     * Determines the arctangent (in radians) of a number.
     *
     * @param x A number.
     *
     * @return  The arctangent (in radians) of a number.     
     */
    atan:function(x){},
    /** 
     * Determines the arctangent of the quotient of its arguments.
     *
     * @param y  A number.
     * @param x  A number.
     *
     * @return   The arctangent of the quotient of its arguments.
     */
    atan2:function(y, x){},
    /** 
     * Determines the smallest integer greater than or equal to a number.
     *
     * @param x  A number.
     *
     * @return   The smallest integer greater than or equal to a number.
     */
    ceil:function(x){},
    /** 
     * Determines the cosine of a number.
     *
     * @param x  A number given in unit of radians.
     *
     * @return   The cosine of a number.
     */
    cos:function(x){},
    /**
	 * Determines EN, where N is the argument, and E is Euler's constant, the base of the natural logarithm.
     *
     * @param x  A number.
     *
     * @return   E^x, where x is the argument, and E is Euler's constant.	 
	 */
    exp:function(x){},
    /** 
     * Determines the largest integer less than or equal to a number.
     *
     * @param x  A number.
     *
     * @return   The largest integer less than or equal to a number.     
     */
    floor:function(x){},
    /** 
     * Determines the natural logarithm (base E) of a number.
     *
     * @param x  A number.
     *
     * @return   The natural logarithm (base E) of a number.
     */
    log:function(x){},
    /** 
     * Determines the largest of zero or more numbers.
     *
     * @param x  A number.
     * @param y  A number.
     *
     * @return   The largest of zero or more numbers. If no arguments are given, the results is -Infinity.
     *           If at least one of arguments cannot be converted to a number, the result is NaN.    
     */
    max:function(x, y){},
    /** 
     * Determines the smallest of zero or more numbers.
     *
     * @param x  A number.
     * @param y  A number.
     *
     * @return   The smallest of zero or more numbers. If no arguments are given, the results is Infinity.
     *           If at least one of arguments cannot be converted to a number, the result is NaN.     
     */
    min:function(x, y){},
    /** 
     * Determines base to the exponent power.
     *
     * @param x  The base number.
     * @param y  The exponent to which to raise base.
     *
     * @return   The base to the exponent power.
     */
    pow:function(x, y){},
    /** 
     * Determines a pseudo-random number between 0 and 1.
     *
     * @return A pseudo-random number between 0 and 1.
     */
    random:function(){},
    /** 
     * Determines the value of a number rounded to the nearest integer.
     *
     * @param x  A number.
     *
     * @return   The value of a number rounded to the nearest integer.     
     */
    round:function(x){},
    /** 
     * Determines the sine of a number.
     *
     * @param x  A number (given in radians).
     *
     * @return   The sine of the given number.     
     */
    sin:function(x){},
    /** 
     * Determines the square root of a number.
     *
     * @param x  A number.
     *
     * @return   The square root of the given number.     
     */
    sqrt:function(x){},
    /** 
     * Determines the tangent of a number.
     *
     * @param x  A number representing an angle in radians.
     *
     * @return   The tangent of the given angle.     
     */
    tan:function(x){},
    /** 
     * Returns the string "Math" (non-standard method).
     *
     * @return The string "Math".
     */
    toSource:function(){}
    }
 
  
  /**
   * Describes a pattern of characters.
   */
  RegExp.prototype = {
    /**
     * Specifies the function that creates an object's prototype.
     */
    constructor:0,
    /**
     * Specifies if the "g" modifier is set.
     */
    global:0,
    /**
     * Specifies if the "i" modifier is set.
     */
    ignoreCase:0,
    /**
     * The index at which to start the next match.
     */
    lastIndex:0,
    /**
     * Specifies if the "m" modifier is set.
     */
    multiline:0,
    /**
     * The text of the RegExp pattern.
     */
    source:0,
    /**
     * Whether or not the search is sticky (non-standard parameter).
     */
    sticky:0,
    /** 
     * Compiles a regular expression during execution of a script. 
     * The modifier is used to specify the type of matching.
     * 
     * @param regexp   A regular expression.
     * @param modifier Specifies the type of matching. "g" for a global match, "i" for 
     *                 a case-insensitive match and "gi" for a global, case-insensitive match.
     */
    compile:function(regexp, modifier){},
    /** 
     * Executes a search for a match in its string parameter.
     *
     * @param  The string against which to match the regular expression.
     *
     * @return The matched text if it finds a match (as an array), otherwise it returns null.
     */
    exec:function(string){},
    /** 
     * Tests for a match in its string parameter. Returns true if it finds a match, false otherwise.
     *
     * @param  The string against which to match the regular expression.
     *
     * @return true if matching found, false otherwise.     
     */
    test:function(string){},
    /**
	 * Builds an object literal representing the specified object.
	 *
	 * @return An object literal representing the specified object.
	 */
    toSource:function(){},
    /** 
     * Builds a string representing the specified object (non standard method).
     *
     * @return A string representing the specified object.
     */
    toString:function(){}
  }



  /*
   * DOM HTML Specification.
   */
  /*http://www.w3.org/TR/2003/REC-DOM-Level-2-HTML-20030109/html.html*/

  /**
   * Represents a list of nodes. An individual node may be accessed 
   * by either ordinal index or the node's name or id attributes.
   */
  HTMLCollection.prototype = {
	/**
	 * Specifies the length or size of the list.
	 */ 
	length:0,
	/**
     * Retrieves a node specified by ordinal index. Nodes are numbered in tree order 
	 * (depth-first traversal order).
	 * 
	 * @param index  The index of the node to be fetched. The index origin is 0.
	 *
	 * @return       The Node at the corresponding position upon success. 
	 *               A value of null is returned if the index is out of range.
	 */
	item:function(index){},
	/**
	 * Retrieves a Node using a name. 
	 * 
	 * @param name The name of the Node to be fetched.
	 *
	 * @return     The Node with a name or id attribute whose value corresponds to the specified string. 
	 *             Upon failure, returns null.
	 */
	namedItem:function(name){}
  }
 
  /**
    * A list of nodes representing HTML option element. 
    * An individual node may be accessed by either ordinal index or the node's name or id attributes.
    */
  HTMLOptionsCollection.prototype = {
	 /**
	  * Specifies the length or size of the list.
	  */
	 length:0,
	 /**
	  * Retrieves a node specified by ordinal index. Nodes are numbered in tree order
	  * (depth-first traversal order). 
	  * 
	  * @param index  The index of the node to be fetched. The index origin is 0.
	  *
	  * @return       The Node at the corresponding position upon success. 
	  *               A value of null is returned if the index is out of range. 
	  */
	 item:function(index){},
	 /**
	  * Retrieves a Node using a name.
	  * 
	  * @param name The name of the Node to be fetched.
	  *
	  * @return     The Node with a name or id attribute whose value corresponds to the specified string. 
	  *             Upon failure, returns null.
	  */
	 namedItem:function(name){}
  }
 
  /**
   * An HTMLDocument is the root of the HTML hierarchy and holds the entire content.
   */
  HTMLDocument.prototype = {
	 /**
	  * A collection of all the anchor elements in a document with a value for the name attribute.
	  */
     anchors:0,
	 /**
	  * A collection of all the OBJECT elements that include applets and APPLET in a document.
	  */
     applets:0,
	 /**
	  * The element that contains the content for the document.
	  */
     body:0,
	 /**
	  * This mutable string attribute denotes persistent state information that: 
	  * (1) is associated with the current frame or document and 
	  * (2) is composed of information described by cookies.
	  */	 
     cookie:0,
     /**
      * Returns the mode used by the browser to render the document.
      */
     documentMode:0,
	 /**
	  * The domain name of the server that served the document, 
	  * or null if the server cannot be identified by a domain name.
	  */
     domain:0,
	 /**
	  * A collection of all the forms of a document.
	  */
     forms:0,
	 /**
	  * A collection of all the IMG elements in a document.  
	  */
	 images:0,
	 /**
      * Returns the date and time the document was last modified. 
      */
     lastModified:0,
	 /**
	  * A collection of all AREA elements and anchor elements in a document with a value for the href attribute. 
	  */
	 links:0,
     /**
      * Returns the (loading) status of the document.
      */
     readyState:0,
	 /**
	  * Returns the URI of the page that linked to this page.
	  */
	 referrer:0,
	 /**
	  * The title of a document as specified by the TITLE element in the head of the document.
	  */
	 title:0,
	 /**
      * The absolute URI of the document.
      */
     URL:0,
	 /**
	  * Closes a document stream opened by open() and forces rendering.
	  */
	 close:function(){},
	 /**
	  * With [HTML 4.01] documents, this method returns the (possibly empty) collection of elements 
	  * whose name value is given by elementName. In [XHTML 1.0] documents, this methods only return
	  * the (possibly empty) collection of form controls with matching name.
	  * 
	  * @param elementName  The name attribute value for an element.
	  *
	  * @return             The matching elements as a NodeList.
	  */
	 getElementsByName:function(elementName){},
	 /**
	  * Opens a document stream for writing. If a document exists in the target, this method clears it.
	  */
	 open:function(){},
	 /**
	  * Writes a string of text to a document stream opened by open(). 
	  * 
	  * @param text The string to be parsed into some structure in the document structure model.
	  */
	 write:function(text){},
	 /**
	  * Writes a string of text followed by a newline character to a document stream opened by open(). 
	  * 
	  * @param text The string to be parsed into some structure in the document structure model.
	  */
	 writeln:function(text){}
  }
 
 
  /**
   * All HTML element interfaces derive from this class. Elements that only expose 
   * the HTML core attributes are represented by the base HTMLElement interface.
   */
  HTMLElement.prototype = {
     /**
      * The accesskey for an element.
      */
     accessKey:0,
     /**
	  * The class attribute of the element.
	  */
	 className:0,
	 /**
      * The viewable height of the content on a page (not including borders, margins, or scrollbars).
      */
     clientHeight:0,
     /**
      * The viewable width of the content on a page (not including borders, margins, or scrollbars).
      */
     clientWidth:0,
	 /**
	  * The base direction of directionally neutral text and the directionality of tables.
	  */
	 dir:0,
	 /**
	  * The element's identifier.
	  */
	 id:0,
	 /**
      * The HTML contents (+text) of an element.
      */
     innerHTML:0,
	 /**
	  * The language code.
	  */
	 lang:0,
	 /**
      * The height of an element, including borders and padding if any, but not margins.
      */
	 offsetHeight:0,
     /**
      * The horizontal offset position of the current element relative to its offset container.
      */
	 offsetLeft:0,
     /**
      * The offset container of an element.
      */
	 offsetParent:0,
     /**
      * The vertical offset position of the current element relative to its offset container.
      */
	 offsetTop:0,
     /**
      * The width of an element, including borders and padding if any, but not margins.
      */
	 offsetWidth:0,
     /**
      * The entire height of an element (including areas hidden with scrollbars).
      */
	 scrollHeight:0,
     /**
      * The distance between the actual left edge of an element and its left edge currently in view.
      */
	 scrollLeft:0,
     /**
      * The distance between the actual top edge of an element and its top edge currently in view.
      */
	 scrollTop:0,
     /**
      * The entire width of an element (including areas hidden with scrollbars).
      */
	 scrollWidth:0,
     /**
      * The style attribute of an element.
      */
	 style:0,
	 /**
      * The tab order of an element.
      */
     tabIndex:0,
	 /**
	  * The element's advisory title.
	  */
	 title:0,
	 /**
      * Converts an element to a string.
      *
      * @return The string corresponding to the given element.
      */
     toString:function(){}
  }
 
 
  /**
   * Root of an HTML document.
   */
  HTMLHtmlElement.prototype = {
	/**
	 * The version information about the document's DTD.
	 */
    version:0
  }
 
 
  /**
   * Document head information.
   */
  HTMLHeadElement.prototype = {
	/**
	 * The URI designating a metadata profile.
	 */
	profile:0
  } 
 
 
  /**
   * Specifies a link to an external resource, 
   * and defines this document's relationship to that resource (or vice versa).
   */
  HTMLLinkElement.prototype = {
	/**
	 * The character encoding of the resource being linked to.
	 */
	charset:0,
	/**
	 * Enables/disables the link. This is currently only used for style sheet links, 
	 * and may be used to activate or deactivate style sheets.
	 */
	disabled:0,
	/**
	 * The URI of the linked resource.
	 */
	href:0,
	/**
	 * The language code of the linked resource.
	 */
	hreflang:0,
	/**
	 * Designed for use with one or more target media.
	 */
	media:0,
	/**
	 * The forward link type.
	 */
	rel:0,
	/**
	 * The reverse link type.
	 */
	rev:0,
	/**
	 * The frame to render the resource in.
	 */
	target:0,
	/**
	 * The advisory content type.
	 */
	type:0
  }
 
 
  /**
   * The document title.
   */
  HTMLTitleElement.prototype = {
	/**
	 * The specified title as a string. 
	 */
	text:0
  }
 
 
  /**
   * Contains generic meta-information about the document.
   */
  HTMLMetaElement.prototype = {
		 /**
		  * The associated information.
		  */
		 content:0,
		 /**
		  * The HTTP response header name.
		  */
		 httpEquiv:0,
		 /**
		  * The meta information name.
		  */
		 name:0,
		 /**
		  * Specifies the form of content.
		  */
		 scheme:0
  }
 
 
  /**
   * Document base URI.
   */
  HTMLBaseElement.prototype = {
		 /**
		  * The base URI.
		  */
		 href:0,
		 /**
		  * The default target frame.
		  */
		 target:0
  }
 
 
  /**
   * Used for single-line text input.
   */
  HTMLIsIndexElement.prototype = {
		 /**
		  * The FORM element containing this control. 
		  */
		 form:0,
		 /**
		  * The prompt message.
		  */
		 prompt:0
  }
 
 
  /**
   * Style information.
   */
  HTMLStyleElement.prototype = {
		 /**
		  * Enables/disables the style sheet.
		  */
		 disabled:0,
		 /**
		  * Designed for use with one or more target media.
		  */
		 media:0,
		 /**
		  *	The content type of the style sheet language.
		  */
		 type:0
  } 
 
 
  /**
   * The HTML document body. 
   */
  HTMLBodyElement.prototype = {
		 /**
		  * The color of active links (after mouse-button down, but before mouse-button up).
		  */
		 aLink:0,
		 /**
		  * The URI of the background texture tile image.
		  */
		 background:0,
		 /**
		  * The document background color.
		  */
		 bgColor:0,
		 /**
		  * Color of links that are not active and unvisited.
		  */
		 link:0,
		 /**
		  * The document text color.
		  */
		 text:0,
		 /**
		  * The color of links that have been visited by the user.
		  */
		 vLink:0
  }
 
 
  /**
   * Encompasses behavior similar to a collection and an element. 
   * It provides direct access to the contained form controls as well as the attributes of the form element.
   */
  HTMLFormElement.prototype = {
		 /**
		  * The list of character sets supported by the server.
		  */
		 acceptCharset:0,
		 /**
		  * The server-side form handler.
		  */
		 action:0,
		 /**
		  * Returns a collection of all form control elements in the form.
		  */
		 elements:0,
		 /**
		  * The content type of the submitted form, generally "application/x-www-form-urlencoded".
		  */
		 enctype:0,
		 /**
		  * The number of form controls in the form.
		  */
		 length:0,
		 /**
		  * The HTTP method used to submit form.
		  */
		 method:0,
		 /**
		  * Names the form.
		  */
		 name:0,
		 /**
		  * The frame to render the resource in. 
		  */
		 target:0,
		 /**
		  * Restores a form element's default values. It performs the same action as a reset button. 
		  */
		 reset:function(){},
		 /**
		  * Submits the form. It performs the same action as a submit button. 
		  */
		 submit:function(){}
  } 
 
  /**
   * Allows the selection of an option. The contained options can be directly accessed through 
   * the select element as a collection.
   */
  HTMLSelectElement.prototype = {
     /**
      * The control is unavailable in this context.
      */
     disabled:0,
     /**
      * The FORM element containing this control; null if this control is not within the context of a form.
      */
     form:0,
     /**
      * The number of options in this SELECT.
      */
     length:0,
     /**
      * If true, multiple OPTION elements may be selected in this SELECT.
      */
     multiple:0,
     /**
      * The form control or object name when submitted with a form.
      */
     name:0,
     /**
      * The collection of OPTION elements contained by this element.
      */
     options:0,
     /**
      * The ordinal index of the selected option, starting from 0. The value -1 is returned if no element is selected. 
      * If multiple options are selected, the index of the first selected option is returned.
      */
     selectedIndex:0,
     /**
      * The number of visible rows. 
      */
     size:0,
     /**
      * The Index representing the element's position in the tabbing order.
      */
     tabIndex:0,
     /**
      * The type of this form control. This is the string "select-multiple" when 
      * the multiple attribute is true and the string "select-one" when false.
      */
     type:0,
     /**
      * The current form control value (i.e. the value of the currently selected option), 
      * if multiple options are selected this is the value of the first selected option. 
      */
     value:0,
     /**
      * Adds a new element to the collection of OPTION elements for this SELECT. 
      * This method is the equivalent of the appendChild method of the Node interface if the before parameter is null. 
      * It is equivalent to the insertBefore method on the parent of before in all other cases. 
      * This method may have no effect if the new element is not an OPTION or an OPTGROUP.
      * 
      * @param element The element to add.
      * @param before  The element to insert before, or null for the tail of the list.
      */
     add:function(element, before){},
     /**
      * Removes keyboard focus from this element. 
      */
     blur:function(){},
     /**
      * Gives keyboard focus to this element. 
      */
     focus:function(){},
     /**
      * Removes an element from the collection of OPTION elements for this SELECT. 
      * Does nothing if no element has the given index.
      * 
      * @param index  The index of the item to remove, starting from 0.
      */
     remove:function(index){}
  }
 
 
  /**
   * Groups options together in logical subdivisions.
   */
  HTMLOptGroupElement.prototype = {
     /**
      * The control is unavailable in this context.
      */
     disabled:0,
     /**
      * Assigns a label to this option group.
      */
     label:0
  }
 
  /**
   * A selectable choice. 
   */
  HTMLOptionElement.prototype = {
     /**
      * Represents the value of the HTML selected attribute. 
      */
     defaultSelected:0,
     /**
      * The control is unavailable in this context.
      */
     disabled:0,
     /**
      * The FORM element containing this control; null if this control is not within the context of a form.
      */
     form:0,
     /**
      * The index of this OPTION in its parent SELECT, starting from 0.
      */
     index:0,
     /**
      * Option label for use in hierarchical menus.
      */
     label:0,
     /**
      * Represents the current state of the corresponding form control, in an interactive user agent. 
      */
     selected:0,
     /**
      * The text contained within the option element.
      */
     text:0,
     /**
      * The current form control value.
      */
     value:0
  }
 
 
  /**
   * Form control. 
   */
  HTMLInputElement.prototype = {
     /**
      * A comma-separated list of content types that a server processing this form will handle correctly.
      */
     accept:0,
     /**
      * A single character access key to give access to the form control.
      */
     accessKey:0,
     /**
      * Aligns this object (vertically or horizontally) with respect to its surrounding text.
      */
     align:0,
     /**
      * Alternate text for user agents not rendering the normal content of this element.
      */
     alt:0,
     /**
      * When the type attribute of the element has the value "radio" or "checkbox", 
      * this represents the current state of the form control, in an interactive user agent. 
      */
     checked:0,
     /**
      * When type has the value "radio" or "checkbox", 
      * this represents the HTML checked attribute of the element. 
      */
     defaultChecked:0,
     /**
      * When the type attribute of the element has the value "text", "file" or "password", 
      * this represents the HTML value attribute of the element. 
      */
     defaultValue:0,
     /**
      * The control is unavailable in this context. 
      */
     disabled:0,
     /**
      * The FORM element containing this control; null if this control is not within the context of a form.
      */
     form:0,
     /**
      * The maximum number of characters for text fields, when type has the value "text" or "password".
      */
     maxLength:0,
     /**
      * The form control or object name when submitted with a form.
      */
     name:0,
     /**
      * This control is read-only. Relevant only when type has the value "text" or "password".
      */
     readOnly:0,
     /**
      * Size information. The precise meaning is specific to each type of field.
      */
     size:0,
     /**
      * When the type attribute has the value "image", this attribute specifies 
      * the location of the image to be used to decorate the graphical submit button.
      */
     src:0,
     /**
      * Index that represents the element's position in the tabbing order. 
      */
     tabIndex:0,
     /**
      * The type of control created (all lower case).
      */
     type:0,
     /**
      * Use client-side image map.
      */
     useMap:0,
     /**
      * When the type attribute of the element has the value "text", "file" or "password", 
      * this represents the current contents of the corresponding form control, in an interactive user agent.
      * When the type attribute of the element has the value "button", "hidden", "submit", "reset",  
      * "image", "checkbox" or "radio", this represents the HTML value attribute of the element. 
      */
     value:0,
     /**
      * Removes keyboard focus from this element. 
      */
     blur:function(){},
     /**
      * Simulates a mouse-click. For INPUT elements whose type attribute has one of the following 
      * values: "button", "checkbox", "radio", "reset", or "submit".  
      */
     click:function(){},
     /**
      * Gives keyboard focus to this element. 
      */
     focus:function(){},
     /**
      * Selects the contents of the text area. For INPUT elements whose type attribute has one of 
      * the following values: "text", "file", or "password". 
      */
     select:function(){}
  }
  
  
  /**
   * Represents a checkbox in an HTML form.
   */
  HTMLCheckbox.prototype = {
     /**
      * The checked state of a checkbox.
      */
     checked:0,
     /**
      * The default value of the checked attribute.
      */
     defaultChecked:0,
     /**
      * Specifies whether or not a checkbox is disabled.
      */
     disabled:0,
     /**
      * A reference to the form that contains the checkbox.
      */
     form:0,
     /**
      * Sets or returns the value of the name attribute of a checkbox. 
      */
     name:0,
     /**
      * Indicates which type of form element the checkbox is. 
      */
     type:0,
     /**
      * Specifies the value of the value attribute of a checkbox. 
      */
     value:0
  }
  
 
  /**
   * Represents a checkbox in an HTML form.
   */
  HTMLFileUpload.prototype = {
     /**
      * A comma-separated list of accepted content types.
      */
     accept:0,
     /**
      * Indicates whether or not the fileUpload button is disabled.
      */
     disabled:0,
     /**
      * A reference to the form that contains the FileUpload object.
      */
     form:0,
     /**
      * The value of the name attribute of the FileUpload object. 
      */
     name:0,
     /**
      * Specifies which type of form element the FileUpload object is. 
      */
     type:0,
     /**
      * The path or the name of the selected file. 
      */
     value:0
  }
  
  
  /**
   * Represents a checkbox in an HTML form.
   */
  HTMLHidden.prototype = {
     /**
      * A reference to the form that contains the hidden input field.
      */
     form:0,
     /**
      * The value of the name attribute of the hidden input field. 
      */
     name:0,
     /**
      * Indicates which type of form element a hidden input field is. 
      */
     type:0,
     /**
      * Specifies the value of the value attribute of the hidden input field. 
      */
     value:0
  }
  
  
  /**
   * Multi-line text field.
   */
  HTMLRadio.prototype = {
     /**
      * The checked state of a radio button.
      */
     checked:0,
     /**
      * The default value of the checked attribute.
      */
     defaultChecked:0,
     /**
      * Specifies whether the radio button is disabled, or not.
      */
     disabled:0,
     /**
      * A reference to the form that contains the radio button.
      */
     form:0,
     /**
      * The value of the name attribute of a radio button. 
      */
     name:0,
     /**
      * The type of form element the radio button is. 
      */
     type:0,
     /**
      * The value of the value attribute of the radio button. 
      */
     value:0
  }
  
  
  /**
   * Multi-line text field.
   */
  HTMLReset.prototype = {
     /**
      * Specifies whether the reset button is disabled, or not.
      */
     disabled:0,
     /**
      * A reference to the form that contains the reset button.
      */
     form:0,
     /**
      * The value of the name attribute of a reset button. 
      */
     name:0,
     /**
      * The type of form element the reset button is. 
      */
     type:0,
     /**
      * The value of the value attribute of the reset button. 
      */
     value:0
  }
  
  
  /**
   * Multi-line text field.
   */
  HTMLSubmit.prototype = {
     /**
      * Specifies whether the submit button is disabled, or not.
      */
     disabled:0,
     /**
      * A reference to the form that contains the submit button.
      */
     form:0,
     /**
      * The value of the name attribute of a submit button. 
      */
     name:0,
     /**
      * The type of form element the submit button is. 
      */
     type:0,
     /**
      * The value of the value attribute of the submit button. 
      */
     value:0
  }
  
  
  /**
   * Represents a password field in a HTML form.
   */
  HTMLPassword.prototype = {
     /**
      * The default value of a text field.
      */
     defaultValue:0,
     /**
      * Specifies whether the text field is disabled, or not.
      */
     disabled:0,
     /**
      * A reference to the form that contains the text field.
      */
     form:0,
     /**
      * The maximum number of characters allowed in a text field. 
      */
     maxLength:0,
     /**
      * The value of the name attribute of a text field. 
      */
     name:0,
     /**
      * Specifies whether a text field is read-only, or not. 
      */
     readOnly:0,
     /**
      * The width of a text field (in number of characters). 
      */
     size:0,
     /**
      * The type of form element a text field is. 
      */
     type:0,
     /**
      * The value of the value attribute of the text field. 
      */
     value:0,
     /**
      * Selects the content of a text field. 
      */
     select:function(){}
  }
  
 
  /**
   * Multi-line text field.
   */
  HTMLStyle.prototype = {
     /**
      * The background properties in one declaration.
      */
     background:0,
     /**
      * Specifies whether a background-image is fixed or scrolls with the page.
      */
     backgroundAttachment:0,
     /**
      * The background-color of an element.
      */
     backgroundColor:0,
     /**
      * The background-image for an element.
      */
     backgroundImage:0,
     /**
      * The starting position of a background-image.
      */
     backgroundPosition:0,
     /**
      * Specifies how to repeat (tile) a background-image.
      */
     backgroundRepeat:0,
     /**
      * Specifies the border-width, border-style, and border-color in one declaration.
      */
     border:0,
     /**
      * Specifies all the borderBottom properties in one declaration.
      */
     borderBottom:0,
     /**
      * The color of the bottom border.
      */
     borderBottomColor:0,
     /**
      * The style of the bottom border.
      */
     borderBottomStyle:0,
     /**
      * The width of the bottom border.
      */
     borderBottomWidth:0,
     /**
      * The color of an element's border (can have up to four values).
      */
     borderColor:0,
     /**
      * All the borderLeft properties in one declaration.
      */
     borderLeft:0,
     /**
      * The color of the left border.
      */
     borderLeftColor:0,
     /**
      * The style of the left border.
      */
     borderLeftStyle:0,
     /**
      * The width of the left border.
      */
     borderLeftWidth:0,
     /**
      * All the borderRight properties in one declaration.
      */
     borderRight:0,
     /**
      * The color of the right border.
      */
     borderRightColor:0,
     /**
      * The style of the right border.
      */
     borderRightStyle:0,
     /**
      * The width of the right border.
      */
     borderRightWidth:0,
     /**
      * The style of an element's border (can have up to four values).
      */
     borderStyle:0,
     /**
      * All the borderTop properties in one declaration.
      */
     borderTop:0,
     /**
      * The color of the top border.
      */
     borderTopColor:0,
     /**
      * The style of the top border.
      */
     borderTopStyle:0,
     /**
      * The width of the top border.
      */
     borderTopWidth:0,
     /**
      * The width of an element's border (can have up to four values).
      */
     borderWidth:0,
     /**
      * All the outline properties in one declaration.
      */
     outline:0,
     /**
      * The color of the outline around a element.
      */
     outlineColor:0,
     /**
      * The style of the outline around an element.
      */
     outlineStyle:0,
     /**
      * The width of the outline around an element.
      */
     outlineWidth:0,
     /**
      * The list-style-image, list-style-position, and list-style-type in one declaration.
      */
     listStyle:0,
     /**
      * An image as the list-item marker.
      */
     listStyleImage:0,
     /**
      * The position of the list-item marker.
      */
     listStylePosition:0,
     /**
      * The list-item marker type.
      */
     listStyleType:0,
     /**
      * The margins of an element (can have up to four values).
      */
     margin:0,
     /**
      * The bottom margin of an element.
      */
     marginBottom:0,
     /**
      * The left margin of an element.
      */
     marginLeft:0,
     /**
      * The right margin of an element.
      */
     marginRight:0,
     /**
      * The top margin of an element.
      */
     marginTop:0,
     /**
      * The padding of an element (can have up to four values).
      */
     padding:0,
     /**
      * The bottom padding of an element.
      */
     paddingBottom:0,
     /**
      * The left padding of an element.
      */
     paddingLeft:0,
     /**
      * The right padding of an element.
      */
     paddingRight:0,
     /**
      * The top padding of an element.
      */
     paddingTop:0,
     /**
      * The contents of a style declaration as a string.
      */
     cssText:0,
     /**
      * The bottom position of a positioned element.
      */
     bottom:0,
     /**
      * The position of the element relative to floating objects.
      */
     clear:0,
     /**
      * Specifies which part of a positioned element is visible.
      */
     clip:0,
     /**
      * The horizontal alignment of an object.
      */
     cssFloat:0,
     /**
      * The type of cursor to display for the mouse pointer.
      */
     cursor:0,
     /**
      * An element's display type.
      */
     display:0,
     /**
      * The height of an element.
      */
     height:0,
     /**
      * The left position of a positioned element.
      */
     left:0,
     /**
      * The maximum height of an element.
      */
     maxHeight:0,
     /**
      * The maximum width of an element.
      */
     maxWidth:0,
     /**
      * The minimum height of an element.
      */
     minHeight:0,
     /**
      * The minimum width of an element.
      */
     minWidth:0,
     /**
      * Specifies what to do with content that renders outside the element box.
      */
     overflow:0,
     /**
      * The type of positioning method used for an element (static, relative, absolute or fixed).
      */
     position:0,
     /**
      * The right position of a positioned element.
      */
     right:0,
     /**
      * The bottom padding of an element.
      */
     top:0,
     /**
      * The vertical alignment of the content in an element.
      */
     verticalAlign:0,
     /**
      * Specifies whether an element should be visible, or not.
      */
     visibility:0,
     /**
      * The width of an element.
      */
     width:0,
     /**
      * The stack order of a positioned element.
      */
     zIndex:0,
     /**
      * The minimum number of lines for an element that must be visible at the bottom of a page.
      */
     orphans:0,
     /**
      * The page-break behavior after an element.
      */
     pageBreakAfter:0,
     /**
      * The page-break behavior before an element.
      */
     pageBreakBefore:0,
     /**
      * The page-break behavior inside an element.
      */
     pageBreakInside:0,
     /**
      * The minimum number of lines for an element that must be visible at the top of a page.
      */
     widows:0,
     /**
      * Specifies whether the table border should be collapsed into a single border, or not.
      */
     borderCollapse:0,
     /**
      * The space between cells in a table.
      */
     borderSpacing:0,
     /**
      * The position of the table caption.
      */
     captionSide:0,
     /**
      * Specifies whether to show the border and background of empty cells, or not.
      */
     emptyCells:0,
     /**
      * The way to lay out table cells, rows, and columns.
      */
     tableLayout:0,
     /**
      * The color of the text.
      */
     color:0,
     /**
      * The text direction.
      */
     direction:0,
     /**
      * The font-style, font-variant, font-weight, font-size, line-height, 
      * and font-family in one declaration.
      */
     font:0,
     /**
      * The font face for text.
      */
     fontFamily:0,
     /**
      * The font size of the text.
      */
     fontSize:0,
     /**
      * The font aspect value.
      */
     fontSizeAdjust:0,
     /**
      * Specifies whether the style of the font is normal, italic or oblique.
      */
     fontStyle:0,
     /**
      * Specifies whether the font should be displayed in small capital letters.
      */
     fontVariant:0,
     /**
      * The boldness of the font.
      */
     fontWeight:0,
     /**
      * The space between characters in a text.
      */
     letterSpacing:0,
     /**
      * The distance between lines in a text.
      */
     lineHeight:0,
     /**
      * The type of quotation marks for embedded quotations.
      */
     quotes:0,
     /**
      * The horizontal alignment of text.
      */
     textAlign:0,
     /**
      * The decoration of a text.
      */
     textDecoration:0,
     /**
      * The indentation of the first line of text.
      */
     textIndent:0,
     /**
      * The shadow effect of a text.
      */
     textShadow:0,
     /**
      * The case of a text.
      */
     textTransform:0,
     /**
      * Specifies whether the text should be overridden to support 
      * multiple languages in the same document, or not.
      */
     unicodeBidi:0,
     /**
      * Specifies how to handle tabs, line breaks and whitespace in a text.
      */
     whiteSpace:0,
     /**
      * The spacing between words in a text.
      */
     wordSpacing:0
  }
 
 
  /**
   * Multi-line text field.
   */
  HTMLTextAreaElement.prototype = {
     /**
      * A single character access key to give access to the form control.
      */
     accessKey:0,
     /**
      * Width of control (in characters).
      */
     cols:0,
     /**
      * Represents the contents of the element.
      */
     defaultValue:0,
     /**
      * The control is unavailable in this context. 
      */
     disabled:0,
     /**
      * Returns the FORM element containing this control. 
      * Returns null if this control is not within the context of a form.
      */
     form:0,
     /**
      * Form control or object name when submitted with a form.
      */
     name:0,
     /**
      * This control is read-only.
      */
     readOnly:0,
     /**
      * Number of text rows.
      */
     rows:0,
     /**
      * Index that represents the element's position in the tabbing order.  
      */
     tabIndex:0,
     /**
      * The type of this form control. This the string "textarea".
      */
     type:0,
     /**
      * Represents the current contents of the corresponding form control, in an interactive user agent.  
      */
     value:0,
     /**
      * Removes keyboard focus from this element. 
      */
     blur:function(){},
     /**
      * Gives keyboard focus to this element. 
      */
     focus:function(){},
     /**
      * Select the contents of the TEXTAREA. 
      */
     select:function(){}
  }
 
  /**
   * Push button.
   */
  HTMLButtonElement.prototype = {
     /**
      * A single character access key to give access to the form control.
      */
     accessKey:0,
     /**
      * The control is unavailable in this context. 
      */
     disabled:0,
     /**
      * Returns the FORM element containing this control. 
      * Returns null if this control is not within the context of a form.
      */
     form:0,
     /**
      * Form control or object name when submitted with a form.
      */
     name:0,
     /**
      * Index that represents the element's position in the tabbing order.  
      */
     tabIndex:0,
     /**
      * The type of button (all lower case).
      */
     type:0,
     /**
      * The current form control value.  
      */
     value:0
  }
 
  /**
   * Form field label text.
   */
  HTMLLabelElement.prototype = {
     /**
      * A single character access key to give access to the form control.
      */
     accessKey:0,
     /**
      * Returns the FORM element containing this control.  
      * Returns null if this control is not within the context of a form.
      */
     form:0,
     /**
      * This attribute links this label with another form control by id attribute.  
      */
     htmlFor:0
  }
  
  /**
   * Organizes form controls into logical groups.
   */
  HTMLFieldSetElement.prototype = {
    /**
     * Returns the FORM element containing this control. 
     * Returns null if this control is not within the context of a form.
     */
    form:0
  }
  
  /**
   * Provides a caption for a FIELDSET grouping.
   */
  HTMLLegendElement.prototype = {
     /**
      * A single character access key to give access to the form control.
      */
     accessKey:0,
     /**
      * Text alignment relative to FIELDSET.  
      */
     align:0,
     /**
      * Returns the FORM element containing this control. 
      * Returns null if this control is not within the context of a form.  
      */
     form:0
  }
  
  /**
   * Unordered list.
   */
  HTMLUListElement.prototype = {
     /**
      * Reduces spacing between list items.
      */
     compact:0,
     /**
      * Bullet style.  
      */
     type:0
  }
  
  /**
   * Ordered list.
   */
  HTMLOListElement.prototype = {
     /**
      * Reduces spacing between list items.
      */
     compact:0,
     /**
      * Starting sequence number.  
      */
     start:0,
     /**
      * Numbering style.  
      */
     type:0
  }
  
  /**
   * Definition list.
   */
  HTMLDListElement.prototype = {
     /**
      * Reduce spacing between list items.  
      */
     compact:0
  }
  
  /**
   * Directory list.
   */
  HTMLDirectoryElement.prototype = {
     /**
      * Reduces spacing between list items.  
      */
     compact:0
  }
  
  /**
   * Menu list.
   */
  HTMLMenuElement.prototype = {
     /**
      * Reduces spacing between list items.  
      */
     compact:0
  }
  
  /**
   * List item.
   */
  HTMLLIElement.prototype = {
     /**
      * Lists item bullet style.  
      */
     type:0,
     /**
      * Resets sequence number when used in OL.  
      */
     value:0
  }
  
  /**
   * Generic block container.
   */
  HTMLDivElement.prototype = {
     /**
      * Horizontal text alignment.  
      */
     align:0
  }
  
  /**
   * Paragraph.
   */
  HTMLParagraphElement.prototype = {
     /**
      * Horizontal text alignment.  
      */
     align:0
  }
  
  /**
   * For the H1 to H6 elements.
   */
  HTMLHeadingElement.prototype = {
     /**
      * Horizontal text alignment.  
      */
     align:0
  }
  
  /**
   * For the Q and BLOCKQUOTE elements.
   */
  HTMLQuoteElement.prototype = {
     /**
      * A URI designating a source document or message.  
      */
     cite:0
  }
  
  /**
   * Preformatted text.
   */
  HTMLPreElement.prototype = {
     /**
      * Fixed width for content.  
      */
     width:0
  }
  
  /**
   * Forces a line break.
   */
  HTMLBRElement.prototype = {
     /**
      * Controls flow of text around floats.  
      */
     align:0
  }
  
  /**
   * Base font.
   */
  HTMLBaseFontElement.prototype = {
     /**
      * Font color.  
      */
     color:0,
     /**
      * Font face identifier.  
      */
     face:0,
     /**
      * Computed font size.  
      */
     size:0
  }
  
  /**
   * Local change to font.
   */
  HTMLFontElement.prototype = {
     /**
      * Font color.  
      */
     color:0,
     /**
      * Font face identifier.  
      */
     face:0,
     /**
      * Font size.  
      */
     size:0
  }
 
  /**
   * Create a horizontal rule.
   */
  HTMLHRElement.prototype = {
     /**
      * Aligns the rule on the page.  
      */
     align:0,
     /**
      * Indicates to the user agent that there should be no shading in the rendering of this element.  
      */
     noShade:0,
     /**
      * The height of the rule.  
      */
     size:0,
     /**
      * The width of the rule.  
      */
     width:0
  }
  
  /**
   * Notices of modification to part of a document.
   */
  HTMLModElement.prototype = {
     /**
      * A URI designating a document that describes the reason for the change.  
      */
     cite:0,
     /**
      * The date and time of the change.  
      */
     dateTime:0
  }
 
  /**
   * Multi-line text field.
   */
  HTMLAnchorElement.prototype = {
    /**
     * A single character access key to give access to the form control.
     */
    accessKey:0,
    /**
     * The character encoding of the linked resource.
     */
    charset:0,
    /**
     * Comma-separated list of lengths, defining an active region geometry. 
     * See also shape for the shape of the region. 
     */
    coords:0,
    /**
     * The absolute URI of the linked resource. 
     */
    href:0,
    /**
     * Language code of the linked resource. 
     */
    hreflang:0,
    /**
     * Anchor name.
     */
    name:0,
    /**
     * Forward link type.
     */
    rel:0,
    /**
     * Reverse link type.
     */
    rev:0,
    /**
     * The shape of the active area. The coordinates are given by coords.  
     */
    shape:0,
    /**
     * Index that represents the element's position in the tabbing order.
     */
    tabIndex:0,
    /**
     * Frame to render the resource in.  
     */
    target:0,
    /**
     * Advisory content type.  
     */
    type:0,
    /**
     * Removes keyboard focus from this element.  
     */
    blur:function(){},
    /**
     * Gives keyboard focus to this element. 
     */
    focus:function(){}
  }
 
  /**
   * Embedded image.
   */
  HTMLImageElement.prototype = {
    /**
     * Aligns this object (vertically or horizontally) with respect to its surrounding text.
     */
    align:0,
    /**
     * Alternate text for user agents not rendering the normal content of this element.
     */
    alt:0,
    /**
     * Width of border around image. 
     */
    border:0,
    /**
     * Returns whether or not the browser is finished loading an image. 
     */
    complete:0,
    /**
     * Height of the image in pixels. 
     */
    height:0,
    /**
     * Horizontal space to the left and right of this image in pixels. 
     */
    hspace:0,
    /**
     * Use server-side image map.
     */
    isMap:0,
    /**
     * URI designating a long description of this image or frame.
     */
    longDesc:0,
    /**
     * Sets or returns a URL to a low-resolution version of an image.
     */
    lowsrc:0,
    /**
     * The name of the element (for backwards compatibility).
     */
    name:0,
    /**
     * URI designating the source of this image.  
     */
    src:0,
    /**
     * Use client-side image map.
     */
    useMap:0,
    /**
     * Vertical space above and below this image in pixels.  
     */
    vspace:0,
    /**
     * The width of the image in pixels.  
     */
    width:0
  } 
 
 
  /**
   * Generic embedded object.
   */
  HTMLObjectElement.prototype = {
     /**
      * Aligns this object (vertically or horizontally) with respect to its surrounding text.
      */
     align:0,
     /**
      * Space-separated list of archives.
      */
     archive:0,
     /**
      * Width of border around the object. 
      */
     border:0,
     /**
      * Applet class file. 
      */
     code:0,
     /**
      * Base URI for classid, data, and archive attributes.  
      */
     codeBase:0,
     /**
      * Content type for data downloaded via classid attribute.
      */
     codeType:0,
     /**
      * The document this object contains, if there is any and it is available, or null otherwise.
      */
     contentDocument:0,
     /**
      * A URI specifying the location of the object's data. 
      */
     data:0,
     /**
      * Declare (for future reference), but do not instantiate, this object.
      */
     declare:0,
     /**
      * Returns the FORM element containing this control. 
      * Returns null if this control is not within the context of a form. 
      */
     form:0,
     /**
      * Override height.
      */
     height:0,
     /**
      * Horizontal space, in pixels, to the left and right of this image, applet, or object.
      */
     hspace:0,
     /**
      * Form control or object name when submitted with a form.
      */
     name:0,
     /**
      * Message to render while loading the object.
      */
     standby:0,
     /**
      * Index that represents the element's position in the tabbing order.
      */
     tabIndex:0,
     /**
      * Content type for data downloaded via data attribute.  
      */
     type:0,
     /**
      * Use client-side image map.
      */
     useMap:0,
     /**
      * Vertical space, in pixels, above and below this image, applet, or object.  
      */
     vspace:0,
     /**
      * Override width.  
      */
     width:0
  } 
 
  /**
   * Parameters fed to the OBJECT element.
   */
  HTMLParamElement.prototype = {
     /**
      * The name of a run-time parameter.  
      */
     name:0,
     /**
      * Content type for the value attribute when valuetype has the value "ref".  
      */
     type:0,
     /**
      * The value of a run-time parameter.  
      */
     value:0,
     /**
      * Information about the meaning of the value attribute value.  
      */
     valueType:0
  } 
 
  /**
   * An embedded Java applet.
   */
  HTMLAppletElement.prototype = {
     /**
      * Aligns this object (vertically or horizontally) with respect to its surrounding text.  
      */
     align:0,
     /**
      * Alternate text for user agents not rendering the normal content of this element.  
      */
     alt:0,
     /**
      * Comma-separated archive list.  
      */
     archive:0,
     /**
      * Applet class file.  
      */
     code:0,
     /**
      * Optional base URI for applet.  
      */
     codeBase:0,
     /**
      * Override height.  
      */
     height:0,
     /**
      * Horizontal space, in pixels, to the left and right of this image, applet, or object.  
      */
     hspace:0,
     /**
      * The name of the applet.  
      */
     name:0,
     /**
      * The value of the "object" attribute.  
      */
     object:0,
     /**
      * Vertical space, in pixels, above and below this image, applet, or object.  
      */
     vspace:0,
     /**
      * Override width.  
      */
     width:0
  }
 
  /**
   * Client-side image map. 
   */
  HTMLMapElement.prototype = {
     /**
      * The list of areas defined for the image map.  
      */
     areas:0,
     /**
      * Names the map (for use with usemap).  
      */
     name:0
  }
 
  /**
   * Client-side image map area definition.
   */
  HTMLAreaElement.prototype = {
     /**
      * A single character access key to give access to the form control.  
      */
     accessKey:0,
     /**
      * Alternate text for user agents not rendering the normal content of this element.  
      */
     alt:0,
     /**
      * Comma-separated list of lengths, defining an active region geometry.
      * See also shape for the shape of the region.
      */
     coords:0,
     /**
      * Sets or returns the anchor part of the href attribute value. 
      */
     hash:0,
     /**
      * Sets or returns the hostname:port part of the href attribute value. 
      */
     host:0,
     /**
      * Sets or returns the hostname part of the href attribute value. 
      */
     hostname:0,
     /**
      * The URI of the linked resource. 
      */
     href:0,
     /**
      * Specifies that this area is inactive, i.e., has no associated action.  
      */
     noHref:0,
     /**
      * Sets or returns the pathname part of the href attribute value. 
      */
     pathname:0,
     /**
      * Sets or returns the port part of the href attribute value. 
      */
     port:0,
     /**
      * Sets or returns the protocol part of the href attribute value. 
      */
     protocol:0,
     /**
      * Sets or returns the querystring part of the href attribute value. 
      */
     search:0,
     /**
      * The shape of the active area. The coordinates are given by coords.
      */
     shape:0,
     /**
      * Index that represents the element's position in the tabbing order.  
      */
     tabIndex:0,
     /**
      * Frame to render the resource in.  
      */
     target:0
  } 
 
  /**
   * Script statements.
   */
  HTMLScriptElement.prototype = {
     /**
      * The character encoding of the linked resource.  
      */
     charset:0,
     /**
      * Indicates that the user agent can defer processing of the script.  
      */
     defer:0,
     /**
      * Reserved for future use.  
      */
     event:0,
     /**
      * Reserved for future use.  
      */
     htmlFor:0,
     /**
      * URI designating an external script.  
      */
     src:0,
     /**
      * The script content of the element.  
      */
     text:0,
     /**
      * The content type of the script language.  
      */
     type:0
  }
 
 
  /**
   * Allows authors to construct and modify tables.
   */
  HTMLTableElement.prototype = {
     /**
      * Specifies the table's position with respect to the rest of the document.
      */
     align:0,
     /**
      * Table background image.
      */
     background:0,
     /**
      * Cell background color.
      */
     bgColor:0,
     /**
      * The width of the border around the table. 
      */
     border:0,
     /**
      * Returns the table's CAPTION, or void if none exists. 
      */
     caption:0,
     /**
      * Specifies the horizontal and vertical space between cell content and cell borders. 
      */
     cellPadding:0,
     /**
      * Specifies the horizontal and vertical separation between cells.
      */
     cellSpacing:0,
     /**
      * Returns a collection of all <td> or <th> elements in a table.
      */
     cells:0,
     /**
      * Specifies which external table borders to render.
      */
     frame:0,
     /**
      * The height of the table.
      */
     height:0,
     /**
      * Returns a collection of all the rows in the table, including all in THEAD, TFOOT, all TBODY elements.
      */
     rows:0,
     /**
      * Specifies which internal table borders to render.  
      */
     rules:0,
     /**
      * Description about the purpose or structure of a table.
      */
     summary:0,
     /**
      * Returns a collection of the table bodies (including implicit ones).  
      */
     tBodies:0,
     /**
      * Returns the table's TFOOT, or null if none exists.  
      */
     tFoot:0,
     /**
      * Returns the table's THEAD, or null if none exists.  
      */
     tHead:0,
     /**
      * Specifies the desired table width.  
      */
     width:0,
     /**
      * Create a new table caption object or return an existing one.
      *
      * @return A caption element (HTMLElement, CAPTION).
      */
     createCaption:function(){},
     /**
      * Create a table footer row or return an existing one.
      *
      * @return A footer element (HTMLElement, TFOOT).
      */
     createTFoot:function(){},
     /**
      * Create a table header row or return an existing one.
      *
      * @return A new table header element (HTMLElement, THEAD).
      */
     createTHead:function(){},
     /**
      * Delete the table caption, if one exists. 
      */
     deleteCaption:function(){},
     /**
      * Delete a table row.
      *
      * @param index The index of the row to be deleted. This index starts from 0 and is relative to 
      *              the logical order (not document order) of all the rows contained inside the table.
      */
     deleteRow:function(index){},
     /**
      * Delete the footer from the table, if one exists. 
      */
     deleteTFoot:function(){},
     /**
      * Delete the header from the table, if one exists.  
      */
     deleteTHead:function(){},
     /**
      * Insert a new empty row in the table.
      * 
      * @param index  The row number where to insert a new row. This index starts from 0 and is 
      *               relative to the logical order (not document order) of all the rows 
      *               contained inside the table.
      *
      * @return       The newly created row.
      */
     insertRow:function(index){}
  } 
 
 
  /**
   * Table caption.
   */
  HTMLTableCaptionElement.prototype = {
     /**
      * Caption alignment with respect to the table.  
      */
     align:0
  }
 
  /**
   * Regroups the COL and COLGROUP elements.
   */
  HTMLTableColElement.prototype = {
     /**
      * Horizontal alignment of cell data in column.  
      */
     align:0,
     /**
      * Alignment character for cells in a column.  
      */
     ch:0,
     /**
      * Offset of alignment character.  
      */
     chOff:0,
     /**
      * Indicates the number of columns in a group or affected by a grouping.  
      */
     span:0,
     /**
      * Vertical alignment of cell data in column.  
      */
     vAlign:0,
     /**
      * Default column width.  
      */
     width:0
  }
 
  /**
   * Used to represent the THEAD, TFOOT, and TBODY elements.
   */
  HTMLTableSectionElement.prototype = {
     /**
      * Horizontal alignment of data in cells.
      */
     align:0,
     /**
      * Alignment character for cells in a column.
      */
     ch:0,
     /**
      * Offset of alignment character. 
      */
     chOff:0,
     /**
      * The collection of rows in this table section. 
      */
     rows:0,
     /**
      * Vertical alignment of data in cells. 
      */
     vAlign:0,
     /**
      * Delete a row from this section.
      * 
      * @param index The index of the row to be deleted, or -1 to delete the last row. 
      *              This index starts from 0 and is relative only to the rows contained inside 
      *              this section, not all the rows in the table. 
      */
     deleteRow:function(index){},
     /**
      * Insert a row into this section.
      * 
      * @param index The row number where to insert a new row. This index starts from 0 and is 
      *              relative only to the rows contained inside this section, not all the rows in the table.
      *
      * @return      The newly created row as an HTMLElement.
      */
     insertRow:function(index){}
  }
 
 
  /**
   * Used to represent a row in a table.
   */
  HTMLTableRowElement.prototype = {
     /**
      * Horizontal alignment of data within cells of this row. 
      */
     align:0,
     /**
      * Background color for rows.
      */
     bgColor:0,
     /**
      * The collection of cells in this row. 
      */
     cells:0,
     /**
      * Alignment character for cells in a column. 
      */
     ch:0,
     /**
      * Offset of alignment character. 
      */
     chOff:0,
     /**
      * The height of a table row. 
      */
     height:0,
     /**
      * This is in logical order and not in document order. The rowIndex does take into account 
      * sections (THEAD, TFOOT, or TBODY) within the table, placing THEAD rows first in the index, 
      * followed by TBODY rows, followed by TFOOT rows. 
      */
     rowIndex:0,
     /**
      * The index of this row, relative to the current section (THEAD, TFOOT, or TBODY), starting from 0. 
      */
     sectionRowIndex:0,
     /**
      * Vertical alignment of data within cells of this row. 
      */
     vAlign:0,
     /**
      * Delete a cell from the current row.
      * 
      * @param index  The index of the cell to delete, starting from 0. 
      *               If the index is -1 the last cell in the row is deleted.
      */
     deleteCell:function(index){},
     /**
      * Insert an empty TD cell into this row. If index is -1 or equal to the number of cells, 
      * the new cell is appended.
      * 
      * @param index  The place to insert the cell, starting from 0.
      *
      * @return       The newly created cell as an HTMLElement.
      */
     insertCell:function(index){}
  }
 
 
  /**
   * Used to represent the TH and TD elements.
   */
  HTMLTableCellElement.prototype = {
     /**
      * Abbreviation for header cells.  
      */
     abbr:0,
     /**
      * Horizontal alignment of data in cell.  
      */
     align:0,
     /**
      * Names group of related headers.  
      */
     axis:0,
     /**
      * Cell background image.  
      */
     background:0,
     /**
      * Cell background color.  
      */
     bgColor:0,
     /**
      * The index of this cell in the row, starting from 0. 
      * This index is in document tree order and not display order.  
      */
     cellIndex:0,
     /**
      * Alignment character for cells in a column.   
      */
     ch:0,
     /**
      * Offset of alignment character.  
      */
     chOff:0,
     /**
      * Number of columns spanned by cell.  
      */
     colSpan:0,
     /**
      * List of id attribute values for header cells.  
      */
     headers:0,
     /**
      * Cell height.  
      */
     height:0,
     /**
      * Suppresses word wrapping.  
      */
     noWrap:0,
     /**
      * Number of rows spanned by cell.  
      */
     rowSpan:0,
     /**
      * Scope covered by header cells.  
      */
     scope:0,
     /**
      * Vertical alignment of data in cell.  
      */
     vAlign:0,
     /**
      * Cell width.  
      */
     width:0
  }
 
 
  /**
   * Creates a grid of frames.
   */
  HTMLFrameSetElement.prototype = {
     /**
      * The number of columns of frames in the frameset.  
      */
     cols:0,
     /**
      * The number of rows of frames in the frameset.  
      */
     rows:0
  }
 
 
  /**
   * Creates a frame.
   */
  HTMLFrameElement.prototype = {
    /**
     * The document this frame contains, if there is any and it is available, or null otherwise.  
     */
    contentDocument:0,
    /**
     * 	Returns the window object generated by a frame.  
     */
    contentWindow:0,    
    /**
     * Request frame borders.  
     */
    frameBorder:0,
    /**
     * URI designating a long description of this image or frame.  
     */
    longDesc:0,
    /**
     * Frame margin height, in pixels.  
     */
    marginHeight:0,
    /**
     * Frame margin width, in pixels.  
     */
    marginWidth:0,
    /**
     * The frame name (object of the target attribute).  
     */
    name:0,
    /**
     * When true, forbid user from resizing frame.  
     */
    noResize:0,
    /**
     * Specify whether or not the frame should have scrollbars.  
     */
    scrolling:0,
    /**
     * A URI designating the initial frame contents.  
     */
    src:0
  }
 
 
  /**
   * Inline subwindows.
   */
  HTMLIFrameElement.prototype = {
     /**
      * Aligns this object (vertically or horizontally) with respect to its surrounding text.  
      */
     align:0,
     /**
      * The document this frame contains, if there is any and it is available, or null otherwise.  
      */
     contentDocument:0,
     /**
      * Returns the window object generated by a iframe.  
      */
     contentWindow:0,     
     /**
      * Request frame borders.  
      */
     frameBorder:0,
     /**
      * Frame height.  
      */
     height:0,
     /**
      * URI designating a long description of this image or frame.  
      */
     longDesc:0,
     /**
      * Frame margin height, in pixels.  
      */
     marginHeight:0,
     /**
      * Frame margin width, in pixels.  
      */
     marginWidth:0,
     /**
      * The frame name (object of the target attribute).  
      */
     name:0,
     /**
      * Specify whether or not the frame should have scrollbars.  
      */
     scrolling:0,
     /**
      * A URI designating the initial frame contents.  
      */
     src:0,
     /**
      * Frame width.  
      */
     width:0
  }
 

  /*
   * DOM Events Specification
   */
  /*http://www.w3.org/TR/DOM-Level-2-Events/events.html*/
  
  /**
   * Implemented by all Nodes in an implementation which supports the DOM Event Model.
   */
  EventTarget.prototype = {
     /**
      * Allows the registration of event listeners on the event target.
      * 
      * @param tp The event type for which the user is registering.
      * @param ls The listener parameter takes an interface implemented by the user 
      *           which contains the methods to be called when the event occurs.
      * @param cp If true, it indicates that the user wishes to initiate capture.  
      */
     addEventListener:function(tp, ls, cp){},
     /**
      * Allows the dispatch of events into the implementations event model.
      * 
      * @param evt  Specifies the event type, behavior, and contextual information 
      *             to be used in processing the event.
      *
      * @return     The return value of dispatchEvent indicates whether any of the listeners which handled 
      *             the event called preventDefault. If preventDefault was called the value is false, 
      *             else the value is true.
      */
     dispatchEvent:function(evt){},
     /**
      * Allows the removal of event listeners from the event target. 
      * 
      * @param tp    Specifies the event type of the EventListener being removed.
      * @param ls    Indicates the EventListener to be removed.
      * @param cp    Specifies whether the EventListener being removed was registered as \
      *              a capturing listener or not.
      */
     removeEventListener:function(tp, ls, cp){}
  }
 
  /**
   * It is the primary method for handling events. Users implement the EventListener interface and 
   * register their listener on an EventTarget using the addEventListener method.
   */
  EventListener.prototype = {
     /**
      * Called whenever an event occurs of the type for which the EventListener was registered.
      * 
      *  @param evt Contains contextual information about the event. 
      */
     handleEvent:function(evt){}
  }
 
  /**
   * Used to provide contextual information about an event to the handler processing the event. 
   */
  Event.prototype = {
     /**
      * The event is currently being evaluated at the target EventTarget. 
      */
     AT_TARGET:0,
     /**
      * The current event phase is the bubbling phase. 
      */
     BUBBLING_PHASE:0,
     /**
      * The current event phase is the capturing phase. 
      */
     CAPTURING_PHASE:0,
     /**
      * Specifies whether or not an event is a bubbling event. 
      * If the event can bubble the value is true, else the value is false.  
      */
     bubbles:0,
     /**
      * Specifies whether or not an event can have its default action prevented. 
      * If the default action can be prevented the value is true, else the value is false.  
      */
     cancelable:0,
     /**
      * Indicates the EventTarget whose EventListeners are currently being processed. 
      * This is particularly useful during capturing and bubbling.  
      */
     currentTarget:0,
     /**
      * Indicates which phase of event flow is currently being evaluated.  
      */
     eventPhase:0,
     /**
      * Specifies the EventTarget to which the event was originally dispatched.  
      */
     target:0,
     /**
      * The time (in milliseconds relative to the epoch) at which the event was created.  
      */
     timeStamp:0,
     /**
      * The name of the event (case-insensitive).  
      */
     type:0,
     /**
      * Used to initialize the value of an Event created through the DocumentEvent interface. 
      * 
      * @param et    Specifies the event type. 
      * @param cb    Specifies whether or not the event can bubble.
      * @param cc    Specifies whether or not the event's default action can be prevented.
      */
     initEvent:function(et, cb, cc){},
     /**
      * If an event is cancelable, the method is used to signify that the event is to be canceled. 
      */
     preventDefault:function(){},
     /**
      * Used to prevent further propagation of an event during event flow. 
      */
     stopPropagation:function(){}
  }
 
  /**
   * Provides a mechanism by which the user can create an Event of a type supported by the implementation. 
   */
  DocumentEvent.prototype = {
     /**
      * Used to initialize the value of an Event created through the DocumentEvent interface. 
      * 
      * @param eventType  Specifies the type of Event to be created.
      *
      * @return           The newly created Event.
      */
     createEvent:function(eventType){}
  }
 
  /**
   * Provides specific contextual information associated with User Interface (UI) events. 
   */
  UIEvent.prototype = {
     /**
      * Specifies some detail information about the Event, depending on the type of event. 
      */
     detail:0,
     /**
      * Identifies the AbstractView from which the event was generated.  
      */
     view:0,
     /**
      * Used to initialize the value of a UIEvent created through the DocumentEvent. 
      * 
      * @param tp    Specifies the event type.
      * @param cb    Specifies whether or not the event can bubble.
      * @param cc    Specifies whether or not the event's default action can be prevented.
      * @param vw    Specifies the Event's AbstractView.
      * @param dt    Specifies the Event's detail. 
      */
     initUIEvent:function(tp, cb, cc, vw, dt){}
  }
 
  /**
   * Provides specific contextual information associated with Mouse events. 
   */
  MouseEvent.prototype = {
     /**
      * Used to indicate whether the 'alt' key was depressed during the firing of the event. 
      */
     altKey:0,
     /**
      * Used to indicate which mouse button changed state, during mouse events caused by 
      * the depression or release of a mouse button.   
      */
     button:0,
     /**
      * The horizontal coordinate at which the event occurred relative to the DOM implementation's client area. 
      */
     clientX:0,
     /**
      * The vertical coordinate at which the event occurred relative to the DOM implementation's client area.  
      */
     clientY:0,
     /**
      * Used to indicate whether the 'ctrl' key was depressed during the firing of the event. 
      */
     ctrlKey:0,
     /**
      * Used to indicate whether the 'meta' key was depressed during the firing of the event.  
      */
     metaKey:0,
     /**
      * Used to identify a secondary EventTarget related to a UI event. 
      */
     relatedTarget:0,
     /**
      * The horizontal coordinate at which the event occurred relative to 
      * the origin of the screen coordinate system.  
      */
     screenX:0,
     /**
      * The vertical coordinate at which the event occurred relative to 
      * the origin of the screen coordinate system. 
      */
     screenY:0,
     /**
      * Used to indicate whether the 'shift' key was depressed during the firing of the event.  
      */
     shiftKey:0,
     /**
      * Used to initialize the value of a MouseEvent created through the DocumentEvent interface. 
      * 
      * @param t    Specifies the event type.
      * @param b    Specifies whether or not the event can bubble.
      * @param c    Specifies whether or not the event's default action can be prevented.
      * @param v    Specifies the Event's AbstractView.
      * @param d    Specifies the Event's mouse click count.
      * @param x    Specifies the Event's screen x coordinate.
      * @param y    Specifies the Event's screen y coordinate.
      * @param p    Specifies the Event's client x coordinate.
      * @param q    Specifies the Event's client y coordinate. 
      * @param k    Specifies whether or not control key was depressed during the Event.
      * @param a    Specifies whether or not alt key was depressed during the Event.
      * @param s    Specifies whether or not shift key was depressed during the Event.
      * @param m    Specifies whether or not meta key was depressed during the Event.
      * @param n    Specifies the Event's mouse button. 
      * @param e    Specifies the Event's related EventTarget.
      */
     initMouseEvent:function(t,b,c,v,d,x,y,p,q,k,a,s,m,n,e){},
                             
     /**
      * Used to initialize the value of a KeyboardEvent object.
      */
     initKeyboardEvent:function(params){} 
  }
 
  /**
   * Provides specific contextual information associated with Mutation events. 
   */
  MutationEvent.prototype = {
     /**
      * The Attr was just added. 
      */
     ADDITION:0,
     /**
      * The Attr was modified in place. 
      */
     MODIFICATION:0,
     /**
      * The Attr was just removed. 
      */
     REMOVAL:0,
     /**
      * Indicates the type of change which triggered the DOMAttrModified event.  
      * The values can be MODIFICATION, ADDITION, or REMOVAL.  
      */
     attrChange:0,
     /**
      * Indicates the name of the changed Attr node in a DOMAttrModified event. 
      */
     attrName:0,
     /**
      * Indicates the new value of the Attr node in DOMAttrModified events,  
      * and of the CharacterData node in DOMCharDataModified events.  
      */
     newValue:0,
     /**
      * Indicates the previous value of the Attr node in DOMAttrModified events, 
      * and of the CharacterData node in DOMCharDataModified events.  
      */
     prevValue:0,
     /**
      * Used to identify a secondary node related to a mutation event.  
      */
     relatedNode:0,
     /**
      * Used to initialize the value of a MutationEvent created through a DocumentEvent. 
      * 
      * @param t    Specifies the event type. 
      * @param b    Specifies whether or not the event can bubble.
      * @param d    Specifies whether or not the event's default action can be prevented.
      * @param r    Specifies the Event's related Node. 
      * @param p    Specifies the Event's prevValue attribute. This value may be null.
      * @param n    Specifies the Event's newValue attribute. This value may be null.
      * @param a    Specifies the Event's attrName attribute. This value may be null. 
      * @param c    Specifies the Event's attrChange attribute.
      */
     initMutationEvent:function(t,b,d,r,p,n,a,c){}
  } 
 
 
 
  /*
   * DOM Elements Traversal Specification
   */
  /*http://www.w3.org/TR/ElementTraversal/*/
 
  /**
   * Allows restrictive navigation to Element nodes. It permits navigation from an element to its 
   * first element child, its last element child, and to its next or previous element siblings. 
   */
  ElementTraversal.prototype = {
     /**
      * Returns the first child element node of this element; null if this element has no child elements. 
      */
     firstElementChild:0,
     /**
      * Returns the last child element node of this element; null if this element has no child elements. 
      */
     lastElementChild:0,
     /**
      * Returns the previous sibling element node of this element; null if this element has
      * no element sibling nodes that come before this one in the document tree. 
      */
     previousElementSibling:0,
     /**
      * Returns the next sibling element node of this element; null if this element has 
      * no element sibling nodes that come after this one in the document tree.  
      */
     nextElementSibling:0,
     /**
      * Returns the current number of element nodes that are children of this element. 
      */
     childElementCount:0
  }
 
 
  /**
   * Allows JavaScript to register different event handlers on elements in an HTML document.
   * Events are normally used in combination with functions not being executed before 
   * the event occurs (such as when clicking a button).
   */
  Events.prototype = {
    /**
     * Occurs when clicking on an element.
     */
    onclick:0,
    /**
     * Occurs when double-clicking on an element.
     */
    ondblclick:0,
    /**
     * Occurs when pressing a mouse button over an element.
     */
    onmousedown:0,
    /**
     * Occurs when moving the mouse pointer over an element.
     */
    onmousemove:0,
    /**
     * Occurs when a user mouse over an element.
     */
    onmouseover:0,
    /**
     * Occurs when moving the mouse pointer out of an element.
     */
    onmouseout:0,
    /**
     * Occurs when releasing a mouse button over an element.
     */
    onmouseup:0,
    /**
     * Occurs when pressing or holding down a key.
     */
    onkeydown:0,
    /**
     * Occurs when pressing or holding down a key.
     */
    onkeypress:0,
    /**
     * Occurs when releasing a keyboard key.
     */
    onkeyup:0,
     /**
     * Occurs when an image is stopped from loading before completely loaded (for <object>).
     */
    onabort:0,
    /**
     * Occurs when an image does not load properly (for <object>, <body> and <frameset>).
     */
    onerror:0,
    /**
     * Occurs when a document, frameset, or <object> has been loaded.
     */
    onload:0,
    /**
     * Occurs when a document view is resized.
     */
    onresize:0,
    /**
     * Occurs when a document view is scrolled.
     */
    onscroll:0,
    /**
     * Occurs when a document is removed from a window or frame (for <body> and <frameset>).
     */
    onunload:0,
     /**
     * Occurs when a form element loses focus.
     */
    onblur:0,
    /**
     * Occurs when the content of a form element, the selection, or the checked state have changed 
     * (for <input>, <select>, and <textarea>).
     */
    onchange:0,
    /**
     * Occurs when an element gets focus (for <label>, <input>, <select>, textarea>, and <button>).
     */
    onfocus:0,
    /**
     * Occurs when a form is reset.
     */
    onreset:0,
    /**
     * Occurs when a user selects some text (for <input> and <textarea>).
     */
    onselect:0,
    /**
     * Occurs when a form is submitted.
     */
    onsubmit:0
  }
 