<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs s util"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    version="2.0">
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>The backbone copy templates.</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Generic copy templates.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="node() | @*" mode="copy-target copy-generic normalize-separators copy-pristine">
        <xsl:copy>
            <xsl:apply-templates select="node() | @*" mode="#current"/>
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>We replace framework related variables from the base framework with ones that
            use the name of the base framework.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="String/text()" mode="copy-target copy-generic copy-menu copy-toolbar">
        <xsl:variable name="step1" select="replace(., '\$\{framework\}', concat('\${framework(', $script/@base, ')}'))"/>
        <xsl:variable name="step2" select="replace($step1, '\$\{frameworkDir\}', concat('\${frameworkDir(', $script/@base, ')}'))"/>
        
        <xsl:value-of select="$step2"/>
    </xsl:template>

    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Entry point into the base framework context.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template 
        match="documentTypeDescriptor[field[@name='name']/String/text()=$baseFrameworkName]"
        priority="100"
        mode="copy-generic">
        <xsl:copy>
            <xsl:apply-templates mode="copy-target"/>
            
            <!-- If a framework does not have a webResources defined we default to it's web folder.  -->
            <xsl:if test="empty(field[@name='webResources'])">
                
                <!-- Not present. Generate a default. -->
                <field name="webResources">
                    <xsl:variable name="temp"><String-array>
                        <xsl:if test="$script/@base and string-length($script/@base)">
                            <String><xsl:value-of select="concat('${frameworkDir(',$script/@base, ')}/web')"/></String>
                        </xsl:if>
                    </String-array></xsl:variable>
                    <xsl:for-each select="($temp/*)">
                        <xsl:call-template name="updateStringPathArray">
                            <xsl:with-param name="container" select="$script/s:webResources"/>
                            <xsl:with-param name="relativePathRewritePolicy">url</xsl:with-param>
                        </xsl:call-template>
                    </xsl:for-each>
                </field>
            </xsl:if>
            
        </xsl:copy>
        
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Author specific setup for the target document type.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template 
        match="field[@name='authorExtensionDescriptor']/authorExtension"
        priority="100"
        mode="copy-target">
        
        <!-- The base framework's action that should not be copied over to the 
        new framework. -->
        <xsl:variable 
            name="skippedActions" 
            select="$script/s:author/s:authorActions/s:removeAction/@id"/>
        <!-- The actions defined in the extension script own actions container folder. -->
        <xsl:variable name="externalAuthorActionIds" as="xs:string*">
            <xsl:sequence
                xmlns:actions="http://www.oxygenxml.com/ns/framework/extend/actions"
                select="actions:getExternalActionsIDs()" 
                use-when="function-available('actions:getExternalActionsIDs')">
            </xsl:sequence>
        </xsl:variable>
        <!-- An action comming from the base framework, if skipped, it will also
        be removed from GUI elements (menus, toolbars, CC) except the case 
        when another action with the same name is defined in the new framework. -->
        <xsl:variable name="actionsToRemoveFromGUI" as="xs:string*">
            
            <xsl:for-each select="$skippedActions">
                <xsl:if test="empty(index-of($externalAuthorActionIds, .))"><xsl:value-of select="."/></xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:copy>
            <xsl:apply-templates mode="copy-target">
                <xsl:with-param name="skippedAuthorActions" select="$actionsToRemoveFromGUI" tunnel="yes"/>
                <!-- Pass it as a tunnel to avoid recomputing it later on in author-actions.xsl -->
                <xsl:with-param name="frameworkOwnActions" select="$externalAuthorActionIds" tunnel="yes"/>
            </xsl:apply-templates>
        </xsl:copy>
        
        <!-- Copies the base framework's external author actions into a location
        specific to the newly generated framework. Oxygen will load these actions 
        automatically fro the new framework.-->
        <xsl:sequence 
            xmlns:actions="http://www.oxygenxml.com/ns/framework/extend/actions"
            use-when="function-available('actions:copyExternalActions')"  
            select="actions:copyExternalActions(($skippedActions , $externalAuthorActionIds))"/>
        
    </xsl:template>
    
    
    
</xsl:stylesheet>