<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs util s"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    version="2.0">
    
    <xd:doc scope="stylesheet" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates framework associations.</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates associated CSSs.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="field[@name='doctypeRules']/documentTypeRule-array" mode="copy-target">
        
        <xsl:variable name="container" select="$script/s:associationRules"/>
        
        <xsl:copy>
            
            <!-- Test if we should keep all existing associations. -->
            <xsl:variable name="skip" select="$container/@inherit = 'none'"/>
            <xsl:if test="not($skip)">
                <xsl:apply-templates mode="copy-target" select="node()"/>
            </xsl:if>
            
            <!-- Add new rules -->
            <xsl:for-each select="$container/s:addRule">
                <xsl:sequence select="util:createAssociationRule(.)"></xsl:sequence>
            </xsl:for-each>
            
        </xsl:copy>
    </xsl:template>
    
   
</xsl:stylesheet>