/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.external.ant.element;

import java.util.ArrayList;
import java.util.List;
import ro.sync.contentcompletion.external.ant.element.AntAttribute;
import ro.sync.contentcompletion.external.ant.element.AntElement;
import ro.sync.contentcompletion.external.ant.element.AntElementType;
import ro.sync.contentcompletion.external.ant.element.ElementsRepository;
import ro.sync.contentcompletion.external.ant.element.ExtensionPointElement;
import ro.sync.contentcompletion.external.ant.element.IAntAttribute;
import ro.sync.contentcompletion.external.ant.element.IAntElement;
import ro.sync.contentcompletion.external.ant.element.TargetElement;

public class ProjectElement
extends AntElement {
    public ProjectElement(ElementsRepository projectElementsRepository) {
        super("project", projectElementsRepository);
        this.setDescription("<html><body><p>Defines an Ant project with all of its targets, tasks and various other properties.</p><p><a href=\"http://ant.apache.org/manual/using.html#projects\">Read more</a></p></body></html>");
    }

    @Override
    public AntElementType getType() {
        return AntElementType.PROJECT;
    }

    @Override
    protected List<IAntAttribute> collectAttributes() {
        ArrayList<IAntAttribute> attrs = new ArrayList<IAntAttribute>(3);
        AntAttribute nameAttr = new AntAttribute("name");
        nameAttr.setDescription("The name of the project.");
        attrs.add(nameAttr);
        AntAttribute defaultAttr = new AntAttribute("default");
        defaultAttr.setDescription("The default target to use when no target is supplied.");
        attrs.add(defaultAttr);
        AntAttribute baseDirAttr = new AntAttribute("basedir");
        baseDirAttr.setDescription("The base directory from which all path calculations are done.\nThis attribute might be overridden by setting the \"basedir\" property beforehand. When this is done, it must be omitted in the project tag.\nIf neither the attribute nor the property have been set, the parent directory of the buildfile will be used.\nA relative path is resolved relative to the directory containing the build file.");
        attrs.add(baseDirAttr);
        return attrs;
    }

    @Override
    protected List<IAntElement> collectChildren() {
        ArrayList<IAntElement> elems = new ArrayList<IAntElement>();
        TargetElement targetElem = new TargetElement(this.projectElementsRepository);
        targetElem.setDescription("A target is a container of tasks that cooperate to reach a desired state during the build process.");
        elems.add(targetElem);
        ExtensionPointElement extensionPointElem = new ExtensionPointElement(this.projectElementsRepository);
        extensionPointElem.setDescription("Extension-Points are similar to targets in that they have a name and a depends list and can be executed from the command line.\nJust like targets they represent a state during the build process.\n\nUnlike targets they don't contain any tasks, their main purpose is to collect targets that contribute to the desired state in their depends list.");
        elems.add(extensionPointElem);
        elems.addAll(this.projectElementsRepository.getTaskElements());
        elems.addAll(this.projectElementsRepository.getTypeElements());
        return elems;
    }
}

