/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.external.ant.element;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import ro.sync.contentcompletion.external.ant.doc.DocElementRepository;
import ro.sync.contentcompletion.external.ant.element.TaskElement;
import ro.sync.contentcompletion.external.ant.element.TypeElement;
import ro.sync.exml.ant.core.project.AntProject;

public class ElementsRepository {
    private final AntProject project;
    private List<TaskElement> taskElements;
    private List<TypeElement> typeElements;

    public ElementsRepository(AntProject project) {
        this.project = project;
    }

    private void collectTaskAndTypeElements() {
        Hashtable antTypeTable;
        this.taskElements = new ArrayList<TaskElement>();
        this.typeElements = new ArrayList<TypeElement>();
        ComponentHelper ch = ComponentHelper.getComponentHelper((Project)this.project);
        if (ch != null && (antTypeTable = ch.getAntTypeTable()) != null) {
            Set entries = antTypeTable.entrySet();
            for (Map.Entry definitionEntry : entries) {
                String typeName = (String)definitionEntry.getKey();
                AntTypeDefinition definition = (AntTypeDefinition)definitionEntry.getValue();
                Class typeClass = definition.getTypeClass((Project)this.project);
                Class exposedClass = definition.getExposedClass((Project)this.project);
                if (exposedClass == null) continue;
                boolean isTask = Task.class.isAssignableFrom(exposedClass);
                if (isTask) {
                    TaskElement taskElement = new TaskElement(typeName, typeClass, this);
                    taskElement.setDocumentationElement(DocElementRepository.getInstance().getDocumentation(typeName));
                    this.taskElements.add(taskElement);
                    continue;
                }
                TypeElement typeElement = new TypeElement(typeName, typeClass, this);
                typeElement.setDocumentationElement(DocElementRepository.getInstance().getDocumentation(typeName));
                this.typeElements.add(typeElement);
            }
        }
    }

    public List<TaskElement> getTaskElements() {
        if (this.taskElements == null) {
            this.collectTaskAndTypeElements();
        }
        return this.taskElements;
    }

    public List<TypeElement> getTypeElements() {
        if (this.typeElements == null) {
            this.collectTaskAndTypeElements();
        }
        return this.typeElements;
    }

    public List<TypeElement> getTypeElements(Class<?> typeCls) {
        ArrayList<TypeElement> typeElems = new ArrayList<TypeElement>();
        List<TypeElement> allTypeElements = this.getTypeElements();
        for (TypeElement typeElement : allTypeElements) {
            if (!typeCls.isAssignableFrom(typeElement.getDefinitionClass())) continue;
            typeElems.add(typeElement);
        }
        return typeElems;
    }

    public TaskElement getTaskElement(Class<?> taskCls, String elementName) {
        TaskElement toReturn = null;
        List<TaskElement> allTaskElements = this.getTaskElements();
        for (TaskElement taskElement : allTaskElements) {
            if (!taskCls.equals(taskElement.getDefinitionClass()) || !elementName.equals(taskElement.getName())) continue;
            toReturn = taskElement;
            break;
        }
        if (toReturn == null) {
            toReturn = new TaskElement(elementName, taskCls, this);
            toReturn.setDocumentationElement(DocElementRepository.getInstance().getDocumentation(elementName));
        }
        return toReturn;
    }
}

