/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.external.ant.element;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.contentcompletion.external.ant.doc.DocAttribute;
import ro.sync.contentcompletion.external.ant.doc.DocElement;
import ro.sync.contentcompletion.external.ant.element.AntAttribute;
import ro.sync.contentcompletion.external.ant.element.AntElement;
import ro.sync.contentcompletion.external.ant.element.ElementsRepository;
import ro.sync.contentcompletion.external.ant.element.IAntAttribute;
import ro.sync.contentcompletion.external.ant.element.IAntElement;
import ro.sync.contentcompletion.external.ant.element.NestedElement;
import ro.sync.contentcompletion.external.ant.element.TaskElement;
import ro.sync.contentcompletion.external.ant.element.TypeElement;

public abstract class ClassElement
extends AntElement {
    private static final Logger logger = LoggerFactory.getLogger((String)ClassElement.class.getName());
    private final Class<?> definitionClass;
    protected Set<Method> publicMethods = null;
    private boolean hasText = false;
    private final boolean isTaskContainer;
    private DocElement docElement;
    private static final String REFID_ATTR_NAME = "refid";
    private static final String ID_ATTR_NAME = "id";

    public ClassElement(String name, Class<?> definitionClass, ElementsRepository projectElementsRepository) {
        super(name, projectElementsRepository);
        this.definitionClass = definitionClass;
        this.isTaskContainer = TaskContainer.class.isAssignableFrom(definitionClass);
    }

    public Class<?> getDefinitionClass() {
        return this.definitionClass;
    }

    protected void collectDefinitionClassPublicMethods() {
        block3: {
            this.publicMethods = new HashSet<Method>();
            try {
                Method[] methods = this.definitionClass.getMethods();
                if (methods != null) {
                    this.publicMethods.addAll(Arrays.asList(methods));
                }
                this.removeMethods(ProjectComponent.class);
                this.removeMethods(TypeAdapter.class);
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Could not obtain the public methods for: " + this.definitionClass, t);
            }
        }
    }

    @Override
    protected List<IAntAttribute> collectAttributes() {
        if (this.publicMethods == null) {
            this.collectDefinitionClassPublicMethods();
        }
        ArrayList<IAntAttribute> attributes = new ArrayList<IAntAttribute>();
        boolean encounteredRefID = false;
        boolean encounteredID = false;
        for (Method method : this.publicMethods) {
            DocAttribute attributeDoc;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (methodName == null || !methodName.startsWith("set") || returnType != Void.TYPE || parameterTypes == null || parameterTypes.length != 1) continue;
            Class<?> type = parameterTypes[0];
            List<String> values = this.getAllPossibleValues(type);
            String attrName = methodName.substring("set".length()).toLowerCase();
            if (attrName.isEmpty()) continue;
            boolean addAttribute = true;
            Iterator iterator = attributes.iterator();
            while (iterator.hasNext()) {
                IAntAttribute attr = (IAntAttribute)iterator.next();
                if (!attrName.equals(attr.getName())) continue;
                String[] possibleValues = attr.getPossibleValues();
                if (possibleValues == null) {
                    iterator.remove();
                    break;
                }
                addAttribute = false;
                break;
            }
            if (!addAttribute) continue;
            AntAttribute antAttribute = null;
            antAttribute = values != null ? new AntAttribute(attrName, values.toArray(new String[0])) : new AntAttribute(attrName);
            if (this.docElement != null && (attributeDoc = this.docElement.getAttribute(attrName)) != null) {
                antAttribute.setDescription(attributeDoc.getDescription());
                antAttribute.setDocumentationBaseURL("https://ant.apache.org/manual/Tasks/");
            }
            attributes.add(antAttribute);
            if (REFID_ATTR_NAME.equals(attrName)) {
                encounteredRefID = true;
            }
            if (!ID_ATTR_NAME.equals(attrName)) continue;
            encounteredID = true;
        }
        if (!encounteredID && encounteredRefID) {
            DocAttribute attributeDoc;
            AntAttribute antAttribute = new AntAttribute(ID_ATTR_NAME);
            if (this.docElement != null && (attributeDoc = this.docElement.getAttribute(ID_ATTR_NAME)) != null) {
                antAttribute.setDescription(attributeDoc.getDescription());
                antAttribute.setDocumentationBaseURL("https://ant.apache.org/manual/Tasks/");
            }
            attributes.add(antAttribute);
        }
        return attributes;
    }

    @Override
    protected List<IAntElement> collectChildren() {
        if (this.publicMethods == null) {
            this.collectDefinitionClassPublicMethods();
        }
        ArrayList<IAntElement> children = new ArrayList<IAntElement>();
        if (this.isTaskContainer) {
            List<TaskElement> taskElements = this.projectElementsRepository.getTaskElements();
            children.addAll(taskElements);
        } else {
            HashSet<String> addedChildren = new HashSet<String>();
            for (Method method : this.publicMethods) {
                ClassElement nestedElement;
                String childName;
                String methodName = method.getName();
                Class<?>[] paramTypes = method.getParameterTypes();
                if ("addText".equals(methodName) && paramTypes.length == 1 && String.class.isAssignableFrom(paramTypes[0])) {
                    this.hasText = true;
                    continue;
                }
                Class<?> returnType = method.getReturnType();
                if (paramTypes.length == 1 && Void.TYPE == returnType) {
                    if ("add".equals(methodName) || "addConfigured".equals(methodName)) {
                        List<TypeElement> typeElements = this.projectElementsRepository.getTypeElements(paramTypes[0]);
                        if (typeElements == null) continue;
                        for (TypeElement typeElement : typeElements) {
                            if (addedChildren.contains(typeElement.getName())) continue;
                            children.add(typeElement);
                            addedChildren.add(typeElement.getName());
                        }
                        continue;
                    }
                    if (methodName.startsWith("addConfigured")) {
                        childName = methodName.substring("addConfigured".length()).toLowerCase();
                        if (childName.isEmpty() || addedChildren.contains(childName)) continue;
                        nestedElement = this.createChildElement(childName, paramTypes[0]);
                        children.add(nestedElement);
                        addedChildren.add(childName);
                        continue;
                    }
                    if (!methodName.startsWith("add") || (childName = methodName.substring("add".length()).toLowerCase()).isEmpty() || addedChildren.contains(childName)) continue;
                    nestedElement = this.createChildElement(childName, paramTypes[0]);
                    children.add(nestedElement);
                    addedChildren.add(childName);
                    continue;
                }
                if (!methodName.startsWith("create") || paramTypes.length != 0 || Void.TYPE == returnType || (childName = methodName.substring("create".length()).toLowerCase()).isEmpty() || addedChildren.contains(childName)) continue;
                nestedElement = this.createChildElement(childName, returnType);
                children.add(nestedElement);
                addedChildren.add(childName);
            }
        }
        return children;
    }

    private ClassElement createChildElement(String elName, Class<?> defClass) {
        ClassElement childElem = null;
        if (Task.class.isAssignableFrom(defClass)) {
            childElem = this.projectElementsRepository.getTaskElement(defClass, elName);
        } else {
            childElem = new NestedElement(elName, defClass, this.projectElementsRepository);
            if (this.docElement != null) {
                childElem.setDocumentationElement(this.docElement.getChild(elName));
            }
        }
        return childElem;
    }

    private List<String> getAllPossibleValues(Class<?> type) {
        ArrayList<String> possibleValues;
        block8: {
            possibleValues = new ArrayList<String>();
            try {
                EnumeratedAttribute enumAttr;
                String[] values;
                if (Enum.class.isAssignableFrom(type)) {
                    Method valuesMethod = type.getMethod("values", new Class[0]);
                    Enum[] values2 = (Enum[])valuesMethod.invoke(null, new Object[0]);
                    if (values2 != null) {
                        for (Enum constant : values2) {
                            possibleValues.add(constant.name());
                        }
                    }
                } else if (EnumeratedAttribute.class.isAssignableFrom(type) && (values = (enumAttr = (EnumeratedAttribute)type.newInstance()).getValues()) != null) {
                    possibleValues.addAll(Arrays.asList(values));
                }
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug("Could not obtain the set of accepted values for: " + type, t);
            }
        }
        if (possibleValues.isEmpty()) {
            possibleValues = null;
        }
        return possibleValues;
    }

    @Override
    public boolean hasText() {
        return this.hasText;
    }

    public void setDocumentationElement(DocElement docElement) {
        this.docElement = docElement;
        if (docElement != null) {
            this.setDescription(docElement.getDescription());
        }
    }

    void removeMethods(Class<?> cls) {
        if (cls.isAssignableFrom(this.definitionClass)) {
            Method[] methodsToRemove = cls.getMethods();
            Iterator<Method> iterator = this.publicMethods.iterator();
            block0: while (iterator.hasNext()) {
                Method method = iterator.next();
                for (int i = 0; i < methodsToRemove.length; ++i) {
                    if (!this.methodEqual(method, methodsToRemove[i])) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }
    }

    private boolean methodEqual(Method m1, Method m2) {
        Class<?>[] params2;
        Class<?>[] params1;
        Class<?> ret2;
        Class<?> ret1;
        Class<?> cl2;
        Class<?> cl1;
        boolean equal;
        boolean bl = equal = m1 == m2;
        if (!equal && m1 != null && m2 != null && m1.getName().equals(m2.getName()) && ((cl1 = m1.getDeclaringClass()).isAssignableFrom(cl2 = m2.getDeclaringClass()) || cl2.isAssignableFrom(cl1)) && ((ret1 = m1.getReturnType()).isAssignableFrom(ret2 = m2.getReturnType()) || ret2.isAssignableFrom(ret1)) && (params1 = m1.getParameterTypes()).length == (params2 = m2.getParameterTypes()).length) {
            boolean paramsEqual = true;
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                paramsEqual = false;
                break;
            }
            equal = paramsEqual;
        }
        return equal;
    }
}

