/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.external.ant.element;

import java.util.Collections;
import java.util.List;
import ro.sync.contentcompletion.external.ant.element.AntAttributeComparator;
import ro.sync.contentcompletion.external.ant.element.AntElementComparator;
import ro.sync.contentcompletion.external.ant.element.ElementsRepository;
import ro.sync.contentcompletion.external.ant.element.IAntAttribute;
import ro.sync.contentcompletion.external.ant.element.IAntElement;

public abstract class AntElement
implements IAntElement {
    private static final AntElementComparator ELEMENTS_COMPARATOR = new AntElementComparator();
    private static final AntAttributeComparator ATTRS_COMPARATOR = new AntAttributeComparator();
    private final String name;
    private List<IAntAttribute> attributes;
    private List<IAntElement> children;
    private String description = null;
    private boolean attributesCollected = false;
    private boolean childrenCollected = false;
    protected final ElementsRepository projectElementsRepository;

    public AntElement(String name, ElementsRepository projectElementsRepository) {
        this.name = name;
        this.projectElementsRepository = projectElementsRepository;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final List<IAntAttribute> getAttributes() {
        this.collectAttributesInternal();
        return this.attributes;
    }

    @Override
    public final List<IAntElement> getChildren() {
        this.collectChildrenInternal();
        return this.children;
    }

    @Override
    public boolean hasText() {
        return false;
    }

    private void collectAttributesInternal() {
        if (!this.attributesCollected) {
            this.attributes = this.collectAttributes();
            if (this.attributes != null) {
                Collections.sort(this.attributes, ATTRS_COMPARATOR);
            }
            this.attributesCollected = true;
        }
    }

    protected abstract List<IAntAttribute> collectAttributes();

    private void collectChildrenInternal() {
        if (!this.childrenCollected) {
            this.children = this.collectChildren();
            if (this.children != null) {
                Collections.sort(this.children, ELEMENTS_COMPARATOR);
            }
            this.childrenCollected = true;
        }
    }

    protected abstract List<IAntElement> collectChildren();

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            String documentationBaseURL = this.getDocumentationBaseURL();
            if (documentationBaseURL != null) {
                sb.append("<head><base href=\"").append(documentationBaseURL).append("\"/></head>");
            }
            sb.append("<body>").append(description).append("</body></html>");
            description = sb.toString();
        }
        this.description = description;
    }

    public String getDocumentationBaseURL() {
        return null;
    }
}

