/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.external.ant.doc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.contentcompletion.external.ant.doc.DocElement;

public class DocElementRepository {
    private static final Logger logger = LoggerFactory.getLogger((String)DocElementRepository.class.getName());
    private static final String TASKS_PROPERTIES = "/tasks.properties";
    private static DocElementRepository instance = null;
    private Map<String, DocElement> docElements = null;

    public static DocElementRepository getInstance() {
        if (instance == null) {
            instance = new DocElementRepository();
        }
        return instance;
    }

    protected DocElement createDocElement(URL u) {
        DocElement elem = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DocElement.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            elem = (DocElement)unmarshaller.unmarshal(u);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadElementsDocumentation() {
        URL propUrl = DocElementRepository.getResource(TASKS_PROPERTIES);
        if (propUrl != null) {
            Properties props;
            block7: {
                props = new Properties();
                try {
                    InputStream is = propUrl.openStream();
                    if (is == null) break block7;
                    try (InputStreamReader reader = new InputStreamReader(is);){
                        props.load(reader);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug((Object)e, (Throwable)e);
                }
            }
            this.docElements = new HashMap<String, DocElement>();
            Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                DocElement docElem;
                String path = (String)entry.getValue();
                URL u = DocElementRepository.getResource(path);
                if (u == null || (docElem = this.createDocElement(u)) == null) continue;
                this.docElements.put(docElem.getName(), docElem);
            }
        }
    }

    private static URL getResource(String path) {
        URL resource = DocElementRepository.class.getResource(path);
        return resource;
    }

    public DocElement getDocumentation(String elementName) {
        if (this.docElements == null) {
            this.loadElementsDocumentation();
        }
        return this.docElements.get(elementName);
    }
}

