/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.external.ant;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.URIResolver;
import ro.sync.contentcompletion.external.ant.AntCCAttribute;
import ro.sync.contentcompletion.external.ant.AntCCElement;
import ro.sync.contentcompletion.external.ant.AntCCValue;
import ro.sync.contentcompletion.external.ant.AntElementsModel;
import ro.sync.contentcompletion.external.ant.element.IAntAttribute;
import ro.sync.contentcompletion.external.ant.element.IAntElement;
import ro.sync.contentcompletion.external.ant.element.ProjectElement;
import ro.sync.contentcompletion.external.api.CCAttribute;
import ro.sync.contentcompletion.external.api.CCElement;
import ro.sync.contentcompletion.external.api.CCValue;
import ro.sync.contentcompletion.external.api.ExternalSchemaManager;
import ro.sync.contentcompletion.external.api.context.CCContext;
import ro.sync.contentcompletion.external.api.context.CtxtAttribute;
import ro.sync.contentcompletion.external.api.context.CtxtElement;

public class AntExternalSchemaManager
implements ExternalSchemaManager {
    AntElementsModel model = null;

    public void update(Reader reader, String systemID, URIResolver uriResolver, Map<String, String> additionalProperties) {
        AntElementsModel newModel;
        this.model = newModel = new AntElementsModel(reader, systemID, uriResolver, additionalProperties);
    }

    public List<CCElement> getRootElements() {
        ArrayList<AntCCElement> roots = null;
        if (this.model != null) {
            roots = new ArrayList<AntCCElement>(1);
            roots.add(new AntCCElement(this.model.getRoot()));
        }
        return roots;
    }

    public List<CCElement> getElements(CCContext whatElementsCanGoHereContext) {
        ArrayList<AntCCElement> elements = null;
        if (this.model != null) {
            Stack elementStack = whatElementsCanGoHereContext.getElementStack();
            if (elementStack != null && elementStack.isEmpty()) {
                elements = new ArrayList<AntCCElement>(1);
                elements.add(new AntCCElement(this.model.getRoot()));
            } else {
                List<IAntElement> children;
                IAntElement element = this.getAntElement(whatElementsCanGoHereContext);
                if (element != null && (children = element.getChildren()) != null && children.size() > 0) {
                    elements = new ArrayList(children.size());
                    for (IAntElement iAntElement : children) {
                        elements.add(new AntCCElement(iAntElement));
                    }
                }
            }
        }
        return elements;
    }

    public List<CCAttribute> getAttributes(CCContext whatAttributesCanGoHereContext) {
        List<IAntAttribute> attrs;
        IAntElement element;
        ArrayList<AntCCAttribute> ccAttributes = null;
        if (this.model != null && (element = this.getAntElement(whatAttributesCanGoHereContext)) != null && (attrs = element.getAttributes()) != null && attrs.size() > 0) {
            ccAttributes = new ArrayList<AntCCAttribute>(attrs.size());
            CtxtElement currentElement = (CtxtElement)whatAttributesCanGoHereContext.getElementStack().peek();
            List attributes = currentElement.getAttributes();
            for (IAntAttribute attr : attrs) {
                boolean addAttribute = true;
                if (attributes != null) {
                    for (CtxtAttribute ctxtAttribute : attributes) {
                        if (!attr.getName().equals(ctxtAttribute.getLocalName())) continue;
                        addAttribute = false;
                        break;
                    }
                }
                if (!addAttribute) continue;
                ccAttributes.add(new AntCCAttribute(attr));
            }
        }
        return ccAttributes;
    }

    public List<CCValue> getAttributeValues(CCContext ctxt) {
        IAntElement element;
        ArrayList<AntCCValue> valuesList = null;
        if (this.model != null && (element = this.getAntElement(ctxt)) != null) {
            String attributeName = ctxt.getAttributeName();
            List<IAntAttribute> attrs = element.getAttributes();
            if (attrs != null && attrs.size() > 0) {
                for (IAntAttribute attr : attrs) {
                    if (!attributeName.equals(attr.getName())) continue;
                    String[] possibleValues = attr.getPossibleValues();
                    if (possibleValues == null || possibleValues.length <= 0) break;
                    valuesList = new ArrayList<AntCCValue>();
                    for (String value : possibleValues) {
                        valuesList.add(new AntCCValue(value));
                    }
                }
            }
        }
        return valuesList;
    }

    public CCAttribute getAttribute(CCContext ctxt) {
        IAntElement element;
        AntCCAttribute attribute = null;
        if (this.model != null && (element = this.getAntElement(ctxt)) != null) {
            String attributeName = ctxt.getAttributeName();
            List<IAntAttribute> attrs = element.getAttributes();
            if (attrs != null && attrs.size() > 0) {
                for (IAntAttribute attr : attrs) {
                    if (!attributeName.equals(attr.getName())) continue;
                    attribute = new AntCCAttribute(attr);
                    break;
                }
            }
        }
        return attribute;
    }

    public CCElement getElement(CCContext ctxt) {
        IAntElement element;
        if (this.model != null && (element = this.getAntElement(ctxt)) != null) {
            return new AntCCElement(element);
        }
        return null;
    }

    private IAntElement getAntElement(CCContext context) {
        return this.searchElement(context.getElementStack());
    }

    private IAntElement searchElement(Stack<CtxtElement> elementStack) {
        ProjectElement element = null;
        if (!elementStack.isEmpty()) {
            int stackSize = elementStack.size();
            ProjectElement root = this.model.getRoot();
            CtxtElement currentCtxtElement = (CtxtElement)elementStack.get(0);
            if (root.getName().equals(currentCtxtElement.getQName())) {
                if (stackSize == 1) {
                    element = root;
                } else {
                    IAntElement parentElement = root;
                    for (int index = 1; index < stackSize && parentElement != null; ++index) {
                        currentCtxtElement = (CtxtElement)elementStack.get(index);
                        List<IAntElement> children = parentElement.getChildren();
                        boolean found = false;
                        if (children != null && !children.isEmpty()) {
                            for (IAntElement child : children) {
                                if (!currentCtxtElement.getQName().equals(child.getName())) continue;
                                parentElement = child;
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        parentElement = null;
                    }
                    element = parentElement;
                }
            }
        }
        return element;
    }
}

