/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.external.ant;

import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.URIResolver;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelperRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.contentcompletion.external.ant.element.ElementsRepository;
import ro.sync.contentcompletion.external.ant.element.ProjectElement;
import ro.sync.exml.ant.core.project.AntParserInput;
import ro.sync.exml.ant.core.project.AntProject;
import ro.sync.exml.ant.core.project.AntProjectHelper;
import ro.sync.exml.ant.core.util.AntUtil;

public class AntElementsModel {
    private static final Logger logger = LoggerFactory.getLogger((String)AntElementsModel.class.getName());
    private final AntProject antProject;
    private final ProjectElement projectElement;

    public AntElementsModel(Reader reader, String systemID, URIResolver uriResolver, Map<String, String> additionalProperties) {
        this.antProject = new AntProject(systemID, uriResolver);
        if (additionalProperties != null) {
            Set<Map.Entry<String, String>> entries = additionalProperties.entrySet();
            for (Map.Entry<String, String> property : entries) {
                this.antProject.setProperty(property.getKey(), property.getValue());
            }
        }
        try {
            if (reader != null) {
                AntProjectHelper helper = new AntProjectHelper();
                AntUtil.prepareProject((AntProject)this.antProject, (String)systemID, (AntProjectHelper)helper);
                helper.parse((Project)this.antProject, (Object)new AntParserInput(reader, systemID));
            }
        }
        catch (BuildException e) {
            logger.warn((Object)e, (Throwable)e);
        }
        this.projectElement = new ProjectElement(new ElementsRepository(this.antProject));
    }

    public ProjectElement getRoot() {
        return this.projectElement;
    }

    static {
        try {
            ProjectHelperRepository projectHelperRepository = ProjectHelperRepository.getInstance();
            Iterator helpers = projectHelperRepository.getHelpers();
            if (helpers != null && helpers.hasNext() && !(helpers.next() instanceof AntProjectHelper)) {
                projectHelperRepository.registerProjectHelper(AntProjectHelper.class);
            }
        }
        catch (Exception e) {
            logger.error("Could not register project helper class! " + e.getMessage());
        }
    }
}

