/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.xom;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.option.xom.XOMDocumentWrapper;
import net.sf.saxon.option.xom.XOMWriter;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import nu.xom.Document;
import nu.xom.Node;

public class XOMObjectModel
extends TreeModel
implements ExternalObjectModel {
    private static final XOMObjectModel THE_INSTANCE = new XOMObjectModel();

    public static XOMObjectModel getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getDocumentClassName() {
        return "nu.xom.Document";
    }

    @Override
    public String getIdentifyingURI() {
        return "http://www.xom.nu/jaxp/xpath/xom";
    }

    @Override
    public String getName() {
        return "XOM";
    }

    @Override
    public Builder makeBuilder(PipelineConfiguration pipe) {
        return new XOMWriter(pipe);
    }

    @Override
    public PJConverter getPJConverter(Class<?> targetClass) {
        if (this.isRecognizedNodeClass(targetClass)) {
            return new PJConverter(){

                @Override
                public Object convert(Sequence value, Class<?> targetClass, XPathContext context) throws XPathException {
                    return XOMObjectModel.this.convertXPathValueToObject(value, targetClass);
                }
            };
        }
        return null;
    }

    @Override
    public JPConverter getJPConverter(Class sourceClass, Configuration config) {
        if (this.isRecognizedNodeClass(sourceClass)) {
            return new JPConverter(){

                @Override
                public GroundedValue convert(Object object, XPathContext context) {
                    return XOMObjectModel.this.convertObjectToXPathValue(object, context.getConfiguration());
                }

                @Override
                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    @Override
    public PJConverter getNodeListCreator(Object node) {
        return null;
    }

    public boolean isRecognizedNode(Object object) {
        return object instanceof Node;
    }

    public boolean isRecognizedNodeClass(Class nodeClass) {
        return Node.class.isAssignableFrom(nodeClass);
    }

    @Override
    public Receiver getDocumentBuilder(Result result) {
        return null;
    }

    @Override
    public NodeInfo unravel(Source source, Configuration config) {
        return null;
    }

    private GroundedValue convertObjectToXPathValue(Object object, Configuration config) {
        if (object instanceof Node) {
            return this.wrapNode((Node)object, config);
        }
        if (object instanceof Node[]) {
            Item[] nodes = new NodeInfo[((Node[])object).length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.wrapNode(((Node[])object)[i], config);
            }
            return new SequenceExtent.Of(nodes);
        }
        return null;
    }

    private synchronized NodeInfo wrapNode(Node node, Configuration config) {
        return new XOMDocumentWrapper((Node)node.getDocument(), config).wrap(node);
    }

    public Object convertXPathValueToObject(Sequence value, Class<?> targetClass) throws XPathException {
        Item item;
        boolean allowXOM;
        boolean requireXOM = Node.class.isAssignableFrom(targetClass) || targetClass.isArray() && Node.class.isAssignableFrom(targetClass.getComponentType());
        boolean bl = allowXOM = targetClass == Object.class || targetClass.isAssignableFrom(ArrayList.class) || targetClass.isAssignableFrom(HashSet.class) || targetClass.isArray() && targetClass.getComponentType() == Object.class;
        if (!requireXOM && !allowXOM) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(20);
        SequenceIterator iter = value.iterate();
        while ((item = iter.next()) != null) {
            if (item instanceof VirtualNode) {
                Object o = ((VirtualNode)item).getRealNode();
                if (o instanceof Node) {
                    nodes.add((Node)o);
                    continue;
                }
                if (!requireXOM) continue;
                throw new XPathException("Extension function required class " + targetClass.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
            }
            if (requireXOM) {
                throw new XPathException("Extension function required class " + targetClass.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
            }
            return null;
        }
        if (nodes.isEmpty() && !requireXOM) {
            return null;
        }
        if (Node.class.isAssignableFrom(targetClass)) {
            if (nodes.size() != 1) {
                throw new XPathException("Extension function requires a single XOM Node; supplied value contains " + nodes.size() + " nodes");
            }
            return nodes.get(0);
        }
        if (targetClass.isArray() && Node.class.isAssignableFrom(targetClass.getComponentType())) {
            Node[] array = (Node[])Array.newInstance(targetClass.getComponentType(), nodes.size());
            array = nodes.toArray(array);
            return array;
        }
        if (targetClass.isAssignableFrom(ArrayList.class)) {
            return nodes;
        }
        if (targetClass.isAssignableFrom(HashSet.class)) {
            return new HashSet(nodes);
        }
        return null;
    }

    public TreeInfo wrapDocument(Object node, Configuration config) {
        Document documentNode = ((Node)node).getDocument();
        return new XOMDocumentWrapper((Node)documentNode, config);
    }

    public NodeInfo wrapNode(TreeInfo document, Object node) {
        if (!(node instanceof Node)) {
            throw new IllegalArgumentException("Object to be wrapped is not a XOM Node: " + node.getClass());
        }
        return ((XOMDocumentWrapper)document).wrap((Node)node);
    }
}

