/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.local;

import java.util.Locale;
import net.sf.saxon.expr.number.AbstractNumberer;

public class Numberer_tr
extends AbstractNumberer {
    private final String[] birler = new String[]{"s\u0131f\u0131r", "bir", "iki", "\u00fc\u00e7", "d\u00f6rt", "be\u015f", "alt\u0131", "yedi", "sekiz", "dokuz"};
    private final String[] onlar = new String[]{"", "on", "yirmi", "otuz", "k\u0131rk", "elli", "altm\u0131\u015f", "yetmi\u015f", "seksen", "doksan"};
    private final String[] ten2the3rds = new String[]{"kentilyon", "katrilyon", "trilyon", "milyar", "milyon", "bin"};
    private final Locale turkish = new Locale("tr");

    public String formatWord(String word, int formatIdx) {
        switch (formatIdx) {
            case 0: {
                return word.toUpperCase(this.turkish);
            }
            case 2: {
                return word.substring(0, 1).toUpperCase(this.turkish) + word.substring(1);
            }
        }
        return word.toLowerCase(this.turkish);
    }

    public String numberer(long number, int format) {
        if (number < 10L) {
            return this.birler[(int)number];
        }
        StringBuffer sb = new StringBuffer(200);
        int grup = 0;
        for (long bolen = 1000000000000000000L; bolen > 100L; bolen /= 1000L) {
            int bolum = (int)(number / bolen);
            number -= (long)bolum * bolen;
            if (bolum > 0) {
                int yuz = bolum / 100;
                int on = bolum / 10 % 10;
                int bir = bolum % 10;
                if (yuz != 0) {
                    if (yuz != 1) {
                        sb.append(this.formatWord(this.birler[yuz], format));
                        sb.append(' ');
                    }
                    sb.append(this.formatWord("y\u00fcz", format));
                    sb.append(' ');
                }
                if (on != 0) {
                    sb.append(this.formatWord(this.onlar[on], format));
                    sb.append(' ');
                }
                if (bir != 0 && (bolen > 1000L || bir > 1 || yuz != 0 || on != 0)) {
                    sb.append(this.formatWord(this.birler[bir], format));
                    sb.append(' ');
                }
                sb.append(this.formatWord(this.ten2the3rds[grup], format));
                sb.append(' ');
            }
            ++grup;
        }
        if (number > 0L) {
            int yuz = (int)(number / 100L);
            int on = (int)(number / 10L % 10L);
            int bir = (int)(number % 10L);
            if (yuz != 0) {
                if (yuz != 1) {
                    sb.append(this.formatWord(this.birler[yuz], format));
                    sb.append(' ');
                }
                sb.append(this.formatWord("y\u00fcz", format));
                sb.append(' ');
            }
            if (on != 0) {
                sb.append(this.formatWord(this.onlar[on], format));
                sb.append(' ');
            }
            if (bir != 0) {
                sb.append(this.formatWord(this.birler[bir], format));
                sb.append(' ');
            }
        }
        return sb.toString().trim();
    }

    @Override
    public String toWords(String cardinal, long l) {
        return this.numberer(l, 1);
    }

    @Override
    public String toWords(String cardinal, long l, int format) {
        return this.numberer(l, format);
    }

    @Override
    public String toOrdinalWords(String str, long l, int format) {
        String number = this.numberer(l, format);
        String[] lookFor = new String[]{"s\u0131f\u0131r", "bir", "iki", "\u00fc\u00e7", "d\u00f6rt", "be\u015f", "alt\u0131", "yedi", "sekiz", "dokuz", "on", "yirmi", "otuz", "k\u0131rk", "elli", "altm\u0131\u015f", "yetmi\u015f", "seksen", "doksan", "y\u00fcz", "kentilyon", "katrilyon", "trilyon", "milyar", "milyon", "bin"};
        String[] replaceWith = new String[]{"s\u0131f\u0131r\u0131nc\u0131", "birinci", "ikinci", "\u00fc\u00e7\u00fcnc\u00fc", "d\u00f6rd\u00fcnc\u00fc", "be\u015finci", "alt\u0131nc\u0131", "yedinci", "sekizinci", "dokuzuncu", "onuncu", "yirminci", "otuzuncu", "k\u0131rk\u0131nc\u0131", "ellinci", "altm\u0131\u015f\u0131nc\u0131", "yetmi\u015finci", "sekseninci", "doksan\u0131nc\u0131", "y\u00fcz\u00fcnc\u00fc", "kentilyonuncu", "katrilyonuncu", "trilyonuncu", "milyar\u0131nc\u0131", "milyonuncu", "bininci"};
        int idx = number.lastIndexOf(32);
        if (idx < 0) {
            idx = 0;
        }
        String lastWord = number.substring(idx + 1);
        int found = -1;
        for (int w = 0; w < lookFor.length; ++w) {
            if (!lookFor[w].toLowerCase(this.turkish).equals(lastWord.toLowerCase(this.turkish))) continue;
            found = w;
            break;
        }
        if (found == -1) {
            return number;
        }
        return number.substring(0, idx + 1) + this.formatWord(replaceWith[found], format);
    }

    @Override
    public String monthName(int ay, int min, int max) {
        String[] aylar = new String[]{"Ocak", "\u015eubat", "Mart", "Nisan", "May\u0131s", "Haziran", "Temmuz", "A\u011fustos", "Eyl\u00fcl", "Ekim", "Kas\u0131m", "Aral\u0131k"};
        if (ay < 1 || ay > 12) {
            return "";
        }
        StringBuilder ayAdi = new StringBuilder(this.abbreviate(aylar[ay - 1], max));
        while (ayAdi.length() < min) {
            ayAdi.append(' ');
        }
        return ayAdi.toString();
    }

    @Override
    public String dayName(int gun, int min, int max) {
        String[] gunler = new String[]{"Pazartesi", "Sal\u0131", "\u00c7ar\u015famba", "Per\u015fembe", "Cuma", "Cumartesi", "Pazar"};
        if (gun < 1 || gun > 7) {
            return "";
        }
        StringBuffer gunAdi = new StringBuffer(this.abbreviate(gunler[gun - 1], max));
        while (gunAdi.length() < min) {
            gunAdi.append(' ');
        }
        return gunAdi.toString();
    }

    private String abbreviate(String str, int max) {
        if (str.length() <= max) {
            return str;
        }
        if ((str = this.camelBump(str)).length() <= max) {
            return str;
        }
        if ((str = this.removeVowels(str, max)).length() <= max) {
            return str;
        }
        if ((str = this.removeConsonants(str, max)).length() <= max) {
            return str;
        }
        return str.substring(0, max);
    }

    public String camelBump(String str) {
        char[] chars = str.trim().toCharArray();
        char[] camelBump = new char[chars.length];
        int n = 0;
        boolean precedingSpace = true;
        for (int c = 0; c < chars.length; ++c) {
            if (Character.isWhitespace(chars[c])) {
                precedingSpace = true;
                continue;
            }
            if (precedingSpace) {
                String toUp = new String(new char[]{chars[c]});
                toUp = toUp.toUpperCase(this.turkish);
                camelBump[n++] = toUp.charAt(0);
            } else {
                camelBump[n++] = chars[c];
            }
            precedingSpace = false;
        }
        str = new String(camelBump, 0, n);
        return str;
    }

    private String removeVowels(String str, int max) {
        int diff = str.length() - max;
        String toRemove = "ae\u0131io\u00f6u\u00fc";
        StringBuffer sb = new StringBuffer();
        str = this.reverse(str);
        for (int c = 0; c < str.length(); ++c) {
            if (diff <= 0) {
                sb.append(str.charAt(c));
                continue;
            }
            if (toRemove.indexOf(str.charAt(c)) == -1) {
                sb.append(str.charAt(c));
                continue;
            }
            --diff;
        }
        return this.reverse(sb.toString());
    }

    private String removeConsonants(String str, int max) {
        int diff = str.length() - max;
        String toRemove = "bc\u00e7dfg\u011fhjklmnprs\u015ftvyz";
        StringBuffer sb = new StringBuffer();
        str = this.reverse(str);
        for (int c = 0; c < str.length(); ++c) {
            if (diff <= 0) {
                sb.append(str.charAt(c));
                continue;
            }
            if (toRemove.indexOf(str.charAt(c)) == -1) {
                sb.append(str.charAt(c));
                continue;
            }
            --diff;
        }
        return this.reverse(sb.toString());
    }

    private String reverse(String toString) {
        char[] rev = new char[toString.length()];
        for (int c = 0; c < rev.length; ++c) {
            rev[rev.length - (c + 1)] = toString.charAt(c);
        }
        return new String(rev);
    }

    public static void main(String[] args) {
        Numberer_tr tn = new Numberer_tr();
        System.out.println("Running some tests...");
        System.out.println("9223372036854775807 (Long.MAX_VALUE) in words: '" + tn.toWords("", Long.MAX_VALUE, 2) + "'");
        System.out.println("4425408 in words: '" + tn.toWords("", 4425408L, 2) + "'");
        System.out.println("5323156550 in words: '" + tn.toWords("", 5323156550L, 2) + "'");
        System.out.println("10101010101 in words: '" + tn.toWords("", 10101010101L, 2) + "'");
        System.out.println("101010101010 in words: '" + tn.toWords("", 101010101010L, 2) + "'");
        System.out.println("111111111111 in words: '" + tn.toWords("", 111111111111L, 2) + "'");
        System.out.println("156156 in words: '" + tn.toWords("", 156156L, 2) + "'");
        System.out.println();
        System.out.println("9223372036854775807 (Long.MAX_VALUE) in ordinal words: '" + tn.toOrdinalWords("", Long.MAX_VALUE, 2) + "'");
        System.out.println("4425408 in ordinal words: '" + tn.toOrdinalWords("", 4425408L, 2) + "'");
        System.out.println("5323156550 in ordinal words: '" + tn.toOrdinalWords("", 5323156550L, 2) + "'");
        System.out.println("10101010101 in ordinal words: '" + tn.toOrdinalWords("", 10101010101L, 2) + "'");
        System.out.println("101010101010 in ordinal words: '" + tn.toOrdinalWords("", 101010101010L, 2) + "'");
        System.out.println("111111111111 in ordinal words: '" + tn.toOrdinalWords("", 111111111111L, 2) + "'");
        System.out.println("156156 in ordinal words: '" + tn.toOrdinalWords("", 156156L, 2) + "'");
        System.out.println();
        for (int month = 1; month <= 12; ++month) {
            System.out.println("month " + month + " in 4 characters, minimum 5 characters wide result: '" + tn.monthName(month, 5, 4) + "'");
            System.out.println("month " + month + " in 5 characters, minimum 4 characters wide result: '" + tn.monthName(month, 4, 5) + "'");
            System.out.println("month " + month + " in 10 characters, minimum 10 characters wide result: '" + tn.monthName(month, 10, 10) + "'");
        }
        System.out.println();
        for (int day = 1; day <= 7; ++day) {
            System.out.println("day " + day + " in 4 characters, minimum 5 characters wide result: '" + tn.dayName(day, 5, 4) + "'");
            System.out.println("day " + day + " in 5 characters, minimum 4 characters wide result: '" + tn.dayName(day, 4, 5) + "'");
            System.out.println("day " + day + " in 10 characters, minimum 10 characters wide result: '" + tn.dayName(day, 10, 10) + "'");
        }
        System.out.println();
        System.out.println("abbreviating 156156 in (lower case) words to 18 characters: '" + tn.abbreviate(tn.numberer(156156L, 1), 18) + "'");
        System.out.println("abbreviating 156156 in (upper case) words to 18 characters: '" + tn.abbreviate(tn.numberer(156156L, 0), 18) + "'");
        System.out.println("abbreviating 156156 in (title case) words to 18 characters: '" + tn.abbreviate(tn.numberer(156156L, 2), 18) + "'");
    }
}

