/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.local;

import net.sf.saxon.expr.number.AbstractNumberer;

public class Numberer_sv
extends AbstractNumberer {
    private static final long serialVersionUID = 1L;
    private static final String[] swedishOrdinalUnits = new String[]{"", "f\u00f6rsta", "andra", "tredje", "fj\u00e4rde", "femte", "sj\u00e4tte", "sjunde", "\u00e5ttonde", "nionde", "tionde", "elfte", "tolfte", "trettonde", "fjortonde", "femtonde", "sextonde", "sjuttonde", "artonde", "n\u00edttonde"};
    private static final String[] swedishOrdinalTens = new String[]{"", "tionde", "tjugonde", "trettionde", "fyrtionde", "femtionde", "sextionde", "sjuttionde", "\u00e5ttionde", "n\u00edttionde"};
    private static final String[] swedishUnits = new String[]{"", "ett", "tv\u00e5", "tre", "fyra", "fem", "sex", "sju", "\u00e5tta", "nio", "tio", "elva", "tolv", "tretton", "fjorton", "femton", "sexton", "sjutton", "arton", "nitton"};
    private static final String[] swedishTens = new String[]{"", "tio", "tjugo", "trettio", "fyrtio", "femtio", "sextio", "sjuttio", "\u00e5ttio", "nittio"};
    private static final String[] swedishMonths = new String[]{"januari", "februari", "mars", "april", "maj", "juni", "juli", "augusti", "september", "oktober", "november", "december"};
    private static final String[] swedishDays = new String[]{"m\u00e5ndag", "tisdag", "onsdag", "torsdag", "fredag", "l\u00f6rdag", "s\u00f6ndag"};
    private static final String[] swedishDayAbbreviations = new String[]{"m\u00e5", "ti", "on", "to", "fr", "l\u00f6", "s\u00f6"};
    private static final int[] minUniqueDayLength = new int[]{1, 2, 1, 2, 1, 2, 2};

    @Override
    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        String s;
        if (number == 1000000000L) {
            s = "miljardte";
        } else if (number == 1000000L) {
            s = "miljonte";
        } else if (number == 1000L) {
            s = "tusende";
        } else if (number == 100L) {
            s = "hundrade";
        } else if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            s = (number / 1000000000L == 1L ? "en" : this.toWords("", number / 1000000000L)) + " miljard " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 1000000L) {
            long rem = number % 1000000L;
            s = (number / 1000000L == 1L ? "en" : this.toWords("", number / 1000000L)) + " miljon " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 1000L) {
            long rem = number % 1000L;
            s = (number / 1000L == 1L ? "et" : this.toWords("", number / 1000L)) + "tusen " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 100L) {
            long rem = number % 100L;
            s = (number / 100L == 1L ? "" : this.toWords("", number / 100L)) + "hundra" + (rem == 0L || rem > 19L ? "" : "en") + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else {
            int rem;
            s = number < 20L ? swedishOrdinalUnits[(int)number] : ((rem = (int)(number % 10L)) == 0 ? swedishOrdinalTens[(int)number / 10] : swedishTens[(int)number / 10] + swedishOrdinalUnits[rem]);
        }
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public String toWords(String cardinal, long number) {
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            return (number / 1000000000L == 1L ? "en " : this.toWords(cardinal, number / 1000000000L)) + "miljard" + (rem == 0L ? "" : " ") + this.toWords(cardinal, rem);
        }
        if (number >= 1000000L) {
            long rem = number % 1000000L;
            return (number / 1000000L == 1L ? "en " : this.toWords(cardinal, number / 1000000L)) + "miljon" + (rem == 0L ? "" : " ") + this.toWords(cardinal, rem);
        }
        if (number >= 1000L) {
            long rem = number % 1000L;
            return (number / 1000L == 1L ? "et" : this.toWords(cardinal, number / 1000L)) + "tusen" + (rem == 0L ? "" : (rem < 100L ? "en" : " ") + this.toWords(cardinal, rem));
        }
        if (number >= 100L) {
            long rem = number % 100L;
            return (number / 100L == 1L ? "" : this.toWords(cardinal, number / 100L)) + "hundra" + this.toWords(cardinal, rem);
        }
        if (number < 20L) {
            return swedishUnits[(int)number];
        }
        int rem = (int)(number % 10L);
        return swedishTens[(int)number / 10] + swedishUnits[rem];
    }

    @Override
    public String toWords(String cardinal, long number, int wordCase) {
        String s = number == 0L ? "noll" : this.toWords(cardinal, number);
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    @Override
    public String monthName(int month, int minWidth, int maxWidth) {
        String name = swedishMonths[month - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        return name;
    }

    @Override
    public String dayName(int day, int minWidth, int maxWidth) {
        String name = swedishDays[day - 1];
        if (maxWidth < 2) {
            maxWidth = 2;
        }
        if (name.length() > maxWidth && (name = swedishDayAbbreviations[day - 1]).length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        if (minWidth == 1 && maxWidth == 2) {
            name = name.substring(0, minUniqueDayLength[day - 1]);
        }
        return name;
    }
}

