/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.exslt;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DoubleValue;

public abstract class Random {
    public static SequenceIterator randomSequence(int numberOfItems, double seed) throws IllegalArgumentException {
        if (numberOfItems < 1) {
            throw new IllegalArgumentException("numberOfItems supplied to randomSequence() must be positive");
        }
        long javaSeed = Double.doubleToLongBits(seed);
        return new RandomIterator(numberOfItems, javaSeed);
    }

    public static SequenceIterator randomSequence(int numberOfItems) throws IllegalArgumentException {
        return Random.randomSequence(numberOfItems, System.currentTimeMillis());
    }

    public static DoubleValue randomSequence() throws XPathException {
        return (DoubleValue)Random.randomSequence(1).next();
    }

    private static class RandomIterator
    implements SequenceIterator {
        protected int position = 0;
        private final int count;
        private final long seed;
        private final java.util.Random generator;

        public RandomIterator(int count, long seed) {
            this.count = count;
            this.seed = seed;
            this.generator = new java.util.Random(seed);
        }

        @Override
        public Item next() {
            if (this.position++ >= this.count) {
                this.position = -1;
                return null;
            }
            return new DoubleValue(this.generator.nextDouble());
        }
    }
}

