/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.axiom;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.axiom.AxiomAttributeWrapper;
import net.sf.saxon.option.axiom.AxiomDocument;
import net.sf.saxon.option.axiom.AxiomDocumentNodeWrapper;
import net.sf.saxon.option.axiom.AxiomParentNodeWrapper;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

public class AxiomElementNodeWrapper
extends AxiomParentNodeWrapper {
    private AxiomParentNodeWrapper parent;
    protected AxiomDocument docWrapper;
    protected int index;
    private NamespaceMap inScopeNamespaces = null;

    protected AxiomElementNodeWrapper(OMElement node, AxiomDocument docWrapper, AxiomParentNodeWrapper parent, int index) {
        super((OMContainer)node);
        this.parent = parent;
        this.docWrapper = docWrapper;
        this.index = index;
        this.treeInfo = docWrapper;
    }

    @Override
    public int getNodeKind() {
        return 1;
    }

    @Override
    public SchemaType getSchemaType() {
        return Untyped.getInstance();
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof AxiomDocument) {
            return 1;
        }
        if (other instanceof AxiomAttributeWrapper) {
            if (other.getParent() == this) {
                return -1;
            }
            return this.compareOrder(other.getParent());
        }
        if (other instanceof NamespaceNode) {
            return -other.compareOrder(this);
        }
        return Navigator.compareOrder(this, (SiblingCountingNode)other);
    }

    @Override
    public String getLocalPart() {
        return ((OMElement)this.node).getLocalName();
    }

    @Override
    public String getPrefix() {
        String prefix = ((OMElement)this.node).getPrefix();
        return prefix == null ? "" : prefix;
    }

    @Override
    public NamespaceUri getNamespaceUri() {
        String uri = ((OMElement)this.node).getNamespaceURI();
        return NamespaceUri.of(uri);
    }

    @Override
    public AxiomParentNodeWrapper getParent() {
        if (this.parent == null) {
            OMContainer rawParent = ((OMElement)this.node).getParent();
            this.parent = rawParent instanceof OMDocument ? (AxiomDocumentNodeWrapper)this.docWrapper.getRootNode() : (AxiomElementNodeWrapper)AxiomDocument.makeWrapper((OMNode)((OMElement)rawParent), this.docWrapper, null, -1);
        }
        return this.parent;
    }

    @Override
    public int getSiblingPosition() {
        if (this.index != -1) {
            return this.index;
        }
        OMContainer p = this.getParent().node;
        int ix = 0;
        Iterator kids = p.getChildren();
        while (kids.hasNext()) {
            if (kids.next() == this.node) {
                this.index = ix;
                return this.index;
            }
            ++ix;
        }
        throw new IllegalStateException("Bad child/parent relationship in Axiom tree");
    }

    @Override
    protected AxisIterator iterateAttributes(NodeTest nodeTest) {
        if (!((OMElement)this.node).getAllAttributes().hasNext()) {
            return EmptyIterator.ofNodes();
        }
        if (nodeTest instanceof NameTest) {
            String local;
            String uri = ((NameTest)nodeTest).getNamespaceURI().toString();
            OMAttribute att = ((OMElement)this.node).getAttribute(new QName(uri, local = ((NameTest)nodeTest).getLocalPart()));
            if (att == null) {
                return EmptyIterator.ofNodes();
            }
            return SingleNodeIterator.makeIterator(new AxiomAttributeWrapper(att, this, -1));
        }
        return new AttributeAxisIterator(this, nodeTest);
    }

    @Override
    protected AxisIterator iterateSiblings(NodeTest nodeTest, boolean forwards) {
        if (forwards) {
            if (nodeTest instanceof AnyNodeTest) {
                return new AxiomDocument.FollowingSiblingIterator((OMNode)((OMElement)this.node), this.parent, this.docWrapper);
            }
            return new Navigator.AxisFilter(new AxiomDocument.FollowingSiblingIterator((OMNode)((OMElement)this.node), this.parent, this.docWrapper), nodeTest);
        }
        if (nodeTest instanceof AnyNodeTest) {
            return new AxiomDocument.PrecedingSiblingIterator((OMNode)((OMElement)this.node), this.parent, this.docWrapper);
        }
        return new Navigator.AxisFilter(new AxiomDocument.PrecedingSiblingIterator((OMNode)((OMElement)this.node), this.parent, this.docWrapper), nodeTest);
    }

    @Override
    public String getAttributeValue(NamespaceUri uri, String local) {
        return ((OMElement)this.node).getAttributeValue(new QName(uri.toString(), local, ""));
    }

    @Override
    public NodeInfo getRoot() {
        return this.docWrapper.getRootNode();
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        OMElement elem = (OMElement)this.node;
        ArrayList<NamespaceBinding> list = new ArrayList<NamespaceBinding>();
        Iterator iter = elem.getAllDeclaredNamespaces();
        while (iter.hasNext()) {
            OMNamespace ns = (OMNamespace)iter.next();
            NamespaceBinding nb = new NamespaceBinding(ns.getPrefix(), NamespaceUri.of(ns.getNamespaceURI()));
            list.add(nb);
        }
        NamespaceBinding[] array = new NamespaceBinding[list.size()];
        return list.toArray(array);
    }

    @Override
    public NamespaceMap getAllNamespaces() {
        if (this.getNodeKind() == 1) {
            if (this.inScopeNamespaces != null) {
                return this.inScopeNamespaces;
            }
            AxiomParentNodeWrapper parent = this.getParent();
            NamespaceMap nsMap = parent != null && parent.getNodeKind() == 1 ? parent.getAllNamespaces() : NamespaceMap.emptyMap();
            OMElement elem = (OMElement)this.node;
            Iterator iter = elem.getAllDeclaredNamespaces();
            while (iter.hasNext()) {
                OMNamespace ns = (OMNamespace)iter.next();
                nsMap = nsMap.bind(ns.getPrefix(), NamespaceUri.of(ns.getNamespaceURI()));
            }
            this.inScopeNamespaces = nsMap;
            return this.inScopeNamespaces;
        }
        return null;
    }

    private final class AttributeAxisIterator
    implements AxisIterator {
        private final AxiomElementNodeWrapper element;
        private final Iterator base;
        private NodeInfo current;
        private int index;
        private final NodeTest nodeTest;

        public AttributeAxisIterator(AxiomElementNodeWrapper element, NodeTest test) {
            this.element = element;
            if (test == AnyNodeTest.getInstance() || test == NodeKindTest.ATTRIBUTE) {
                test = null;
            }
            this.base = ((OMElement)element.node).getAllAttributes();
            this.nodeTest = test;
            this.index = 0;
        }

        @Override
        public NodeInfo next() {
            NodeInfo curr;
            while ((curr = this.advance()) != null && this.nodeTest != null && !this.nodeTest.test(curr)) {
            }
            this.current = curr;
            return curr;
        }

        private NodeInfo advance() {
            if (this.base.hasNext()) {
                OMAttribute nextAtt = (OMAttribute)this.base.next();
                ++this.index;
                return new AxiomAttributeWrapper(nextAtt, this.element, this.index);
            }
            return null;
        }
    }
}

