/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.axiom;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.option.axiom.AxiomDocument;
import net.sf.saxon.option.axiom.AxiomElementNodeWrapper;
import net.sf.saxon.option.axiom.AxiomLeafNodeWrapper;
import net.sf.saxon.option.axiom.AxiomParentNodeWrapper;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class AxiomDocumentNodeWrapper
extends AxiomParentNodeWrapper {
    public AxiomDocumentNodeWrapper(OMDocument root, String baseURI, Configuration config) {
        super((OMContainer)root);
        config.requireProfessionalLicense("AXIOM");
        this.treeInfo = new AxiomDocument(root, baseURI, config);
        ((GenericTreeInfo)this.treeInfo).setRootNode(this);
    }

    AxiomDocumentNodeWrapper(OMDocument root, String baseURI, Configuration config, TreeInfo treeInfo) {
        super((OMContainer)root);
        this.treeInfo = treeInfo;
    }

    protected static NodeInfo makeWrapper(OMNode node, AxiomDocument docWrapper, AxiomParentNodeWrapper parent, int index) {
        if (node instanceof OMDocument) {
            return docWrapper.getRootNode();
        }
        if (node instanceof OMElement) {
            return new AxiomElementNodeWrapper((OMElement)node, docWrapper, parent, index);
        }
        return new AxiomLeafNodeWrapper(node, docWrapper, parent, index);
    }

    public boolean isTyped() {
        return false;
    }

    @Override
    public int getSiblingPosition() {
        return 0;
    }

    @Override
    public int getNodeKind() {
        return 9;
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public String getBaseURI() {
        return this.getTreeInfo().getRootNode().getBaseURI();
    }

    @Override
    public String getSystemId() {
        return ((GenericTreeInfo)this.getTreeInfo()).getSystemId();
    }

    @Override
    public void setSystemId(String systemId) {
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public String getLocalPart() {
        return "";
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public NamespaceUri getNamespaceUri() {
        return NamespaceUri.NULL;
    }

    @Override
    public String getDisplayName() {
        return "";
    }

    @Override
    public NodeInfo getRoot() {
        return this;
    }

    @Override
    protected AxisIterator iterateAttributes(NodeTest nodeTest) {
        return EmptyIterator.ofNodes();
    }

    @Override
    protected AxisIterator iterateSiblings(NodeTest nodeTest, boolean forwards) {
        return EmptyIterator.ofNodes();
    }

    @Override
    public int compareOrder(NodeInfo other) {
        return other == this ? 0 : -1;
    }

    protected static class PrecedingSiblingIterator
    implements AxisIterator {
        private final OMNode start;
        private OMNode currentOMNode;
        private final AxiomParentNodeWrapper commonParent;
        private final AxiomDocument docWrapper;

        public PrecedingSiblingIterator(OMNode start, AxiomParentNodeWrapper commonParent, AxiomDocument docWrapper) {
            this.start = start;
            this.currentOMNode = start;
            this.commonParent = commonParent;
            this.docWrapper = docWrapper;
        }

        @Override
        public NodeInfo next() {
            if (this.currentOMNode == null) {
                return null;
            }
            this.currentOMNode = this.currentOMNode.getPreviousOMSibling();
            if (this.currentOMNode == null) {
                return null;
            }
            return AxiomDocumentNodeWrapper.makeWrapper(this.currentOMNode, this.docWrapper, this.commonParent, -1);
        }
    }

    protected static class FollowingSiblingIterator
    implements AxisIterator {
        private final OMNode start;
        private OMNode currentOMNode;
        private final AxiomParentNodeWrapper commonParent;
        private final AxiomDocument docWrapper;

        public FollowingSiblingIterator(OMNode start, AxiomParentNodeWrapper commonParent, AxiomDocument docWrapper) {
            this.start = start;
            this.currentOMNode = start;
            this.commonParent = commonParent;
            this.docWrapper = docWrapper;
        }

        @Override
        public NodeInfo next() {
            if (this.currentOMNode == null) {
                return null;
            }
            this.currentOMNode = this.currentOMNode.getNextOMSibling();
            if (this.currentOMNode == null) {
                return null;
            }
            return AxiomDocumentNodeWrapper.makeWrapper(this.currentOMNode, this.docWrapper, this.commonParent, -1);
        }
    }
}

