/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import com.saxonica.ee.config.StandardSchemaResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.functions.RegexFunction;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegexMatchHandler;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.StringValue;

public class AnalyzeStringFn
extends RegexFunction {
    private ResultNamesAndTypes vocab = new ResultNamesAndTypes();

    @Override
    protected boolean allowRegexMatchingEmptyString() {
        return false;
    }

    private synchronized void init(Configuration config, boolean schemaAware) throws XPathException {
        this.vocab.resultName = new FingerprintedQName("", NamespaceUri.FN, "analyze-string-result");
        this.vocab.nonMatchName = new FingerprintedQName("", NamespaceUri.FN, "non-match");
        this.vocab.matchName = new FingerprintedQName("", NamespaceUri.FN, "match");
        this.vocab.groupName = new FingerprintedQName("", NamespaceUri.FN, "group");
        this.vocab.groupNrName = new NoNamespaceName("nr");
        if (schemaAware) {
            this.vocab.resultType = config.getSchemaType(new StructuredQName("", NamespaceUri.FN, "analyze-string-result-type"));
            this.vocab.nonMatchType = BuiltInAtomicType.STRING;
            this.vocab.matchType = config.getSchemaType(new StructuredQName("", NamespaceUri.FN, "match-type"));
            this.vocab.groupType = config.getSchemaType(new StructuredQName("", NamespaceUri.FN, "group-type"));
            this.vocab.groupNrType = BuiltInAtomicType.POSITIVE_INTEGER;
            if (this.vocab.resultType == null || this.vocab.matchType == null || this.vocab.groupType == null) {
                throw new XPathException("Schema for analyze-string has not been successfully loaded");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeInfo call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue item;
        Item inputItem = arguments[0].head();
        UnicodeString input = inputItem == null ? EmptyUnicodeString.getInstance() : inputItem.getUnicodeStringValue();
        RegularExpression re = this.getRegularExpression(arguments, 1, 2);
        RegexIterator iter = re.analyze(input);
        if (this.vocab.resultName == null) {
            Configuration config;
            boolean schemaAware = context.getController().getExecutable().isSchemaAware();
            Configuration configuration = config = context.getConfiguration();
            synchronized (configuration) {
                if (schemaAware && !config.isSchemaAvailable(NamespaceUri.FN)) {
                    config.addSchemaSource(StandardSchemaResolver.fetchResource("xpath-functions.scm", config));
                }
            }
            this.init(context.getConfiguration(), schemaAware);
        }
        Builder builder = context.getController().makeBuilder();
        ComplexContentOutputter out = new ComplexContentOutputter(builder);
        LocalRegexMatchHandler handler = new LocalRegexMatchHandler(out, this.vocab);
        builder.setBaseURI(this.getStaticBaseUriString());
        builder.setDurability(Durability.TEMPORARY);
        out.open();
        out.startElement(this.vocab.resultName, this.vocab.resultType, Loc.NONE, 0);
        out.startContent();
        while ((item = iter.next()) != null) {
            if (iter.isMatching()) {
                out.startElement(this.vocab.matchName, this.vocab.matchType, Loc.NONE, 0);
                out.startContent();
                iter.processMatchingSubstring(handler);
                out.endElement();
                continue;
            }
            out.startElement(this.vocab.nonMatchName, this.vocab.nonMatchType, Loc.NONE, 0);
            out.startContent();
            out.characters(item.getUnicodeStringValue(), Loc.NONE, 0);
            out.endElement();
        }
        out.endElement();
        out.close();
        return builder.getCurrentRoot();
    }

    private static class LocalRegexMatchHandler
    implements RegexMatchHandler {
        private final ComplexContentOutputter out;
        private final ResultNamesAndTypes vocab;

        public LocalRegexMatchHandler(ComplexContentOutputter out, ResultNamesAndTypes vocab) {
            this.out = out;
            this.vocab = vocab;
        }

        @Override
        public void characters(UnicodeString s) throws XPathException {
            this.out.characters(s, Loc.NONE, 0);
        }

        @Override
        public void onGroupStart(int groupNumber) throws XPathException {
            this.out.startElement(this.vocab.groupName, this.vocab.groupType, Loc.NONE, 0);
            this.out.attribute(this.vocab.groupNrName, this.vocab.groupNrType, "" + groupNumber, Loc.NONE, 0);
            this.out.startContent();
        }

        @Override
        public void onGroupEnd(int groupNumber) throws XPathException {
            this.out.endElement();
        }
    }

    private static class ResultNamesAndTypes {
        public NodeName resultName;
        public NodeName nonMatchName;
        public NodeName matchName;
        public NodeName groupName;
        public NodeName groupNrName;
        public SchemaType resultType = Untyped.getInstance();
        public SchemaType nonMatchType = Untyped.getInstance();
        public SchemaType matchType = Untyped.getInstance();
        public SchemaType groupType = Untyped.getInstance();
        public SimpleType groupNrType = BuiltInAtomicType.UNTYPED_ATOMIC;

        private ResultNamesAndTypes() {
        }
    }
}

