/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class OuterNewlineInserter
extends ProxyReceiver {
    private int level = 0;
    private boolean beforeFirstElement = true;
    private static final UnicodeString NEWLINE = BMPString.of("\n");

    public OuterNewlineInserter(XMLEmitter next) {
        super(next);
    }

    @Override
    public void open() throws XPathException {
        this.nextReceiver.open();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.nextReceiver.startElement(elemName, type, attributes, namespaces, location, properties);
        ++this.level;
        this.beforeFirstElement = false;
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        this.nextReceiver.endElement();
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        if (this.level == 0 && !this.beforeFirstElement) {
            this.characters(NEWLINE, locationId, 0);
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
        if (this.level == 0 && this.beforeFirstElement) {
            this.characters(NEWLINE, locationId, 0);
        }
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.level == 0 && !this.beforeFirstElement) {
            this.characters(NEWLINE, locationId, 0);
        }
        this.nextReceiver.comment(chars, locationId, properties);
        if (this.level == 0 && this.beforeFirstElement) {
            this.characters(NEWLINE, locationId, 0);
        }
    }
}

