/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public abstract class ItemsEnding
extends SystemFunction {
    protected abstract boolean includeMatchingItem();

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence input = arguments[0];
        FunctionItem endCondition = (FunctionItem)arguments[1].head();
        return new LazySequence(new EndingIterator(input.iterate(), endCondition, this.includeMatchingItem(), context));
    }

    private static class EndingIterator
    implements SequenceIterator {
        private final SequenceIterator baseIterator;
        private final FunctionItem end;
        private final boolean inclusive;
        private final XPathContext context;
        private boolean finished;

        EndingIterator(SequenceIterator in, FunctionItem end, boolean inclusive, XPathContext context) {
            this.baseIterator = in;
            this.end = end;
            this.inclusive = inclusive;
            this.context = context;
        }

        @Override
        public Item next() {
            try {
                if (this.finished) {
                    return null;
                }
                Item item = this.baseIterator.next();
                if (item == null) {
                    this.finished = true;
                    return null;
                }
                BooleanValue matches = (BooleanValue)this.end.call(this.context, SequenceTool.fromItems(item)).head();
                if (matches.getBooleanValue()) {
                    this.finished = true;
                    if (this.inclusive) {
                        return item;
                    }
                    this.baseIterator.close();
                    return null;
                }
                return item;
            }
            catch (XPathException e) {
                throw new UncheckedXPathException(e);
            }
        }

        @Override
        public void close() {
            this.baseIterator.close();
        }
    }

    public static class ItemsBefore
    extends ItemsEnding {
        @Override
        protected boolean includeMatchingItem() {
            return false;
        }

        @Override
        public String getStreamerName() {
            return "saxon:ItemsBefore";
        }
    }

    public static class ItemsUntil
    extends ItemsEnding {
        @Override
        protected boolean includeMatchingItem() {
            return true;
        }

        @Override
        public String getStreamerName() {
            return "saxon:ItemsUntil";
        }
    }
}

